/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.net.URI;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.cluster.AbstractModeSwitcher;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.ha.transaction.CommitPusher;
import org.neo4j.kernel.ha.transaction.MasterTxIdGenerator;
import org.neo4j.kernel.ha.transaction.SlaveTxIdGenerator;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;

public class TxIdGeneratorModeSwitcher
extends AbstractModeSwitcher<TxIdGenerator> {
    private final HaXaDataSourceManager xaDsm;
    private final DelegateInvocationHandler<Master> master;
    private final RequestContextFactory requestContextFactory;
    private final StringLogger msgLog;
    private final Config config;
    private final Slaves slaves;
    private final AbstractTransactionManager tm;
    private final JobScheduler scheduler;

    public TxIdGeneratorModeSwitcher(HighAvailabilityMemberStateMachine stateMachine, DelegateInvocationHandler<TxIdGenerator> delegate, HaXaDataSourceManager xaDsm, DelegateInvocationHandler<Master> master, RequestContextFactory requestContextFactory, StringLogger msgLog, Config config, Slaves slaves, AbstractTransactionManager tm, JobScheduler scheduler) {
        super(stateMachine, delegate);
        this.xaDsm = xaDsm;
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.msgLog = msgLog;
        this.config = config;
        this.slaves = slaves;
        this.tm = tm;
        this.scheduler = scheduler;
    }

    @Override
    protected TxIdGenerator getMasterImpl() {
        return new MasterTxIdGenerator(MasterTxIdGenerator.from(this.config), this.msgLog, this.slaves, new CommitPusher(this.scheduler));
    }

    @Override
    protected TxIdGenerator getSlaveImpl(URI serverHaUri) {
        return new SlaveTxIdGenerator((Integer)this.config.get(ClusterSettings.server_id), this.master.cement(), HighAvailabilityModeSwitcher.getServerId(serverHaUri), this.requestContextFactory, this.xaDsm, this.tm);
    }
}

