/*
 * Decompiled with CFR 0.152.
 */
package jmx;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.com.ServerUtil;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.impl.JmxKernelExtension;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.management.BranchedStore;
import org.neo4j.management.ClusterMemberInfo;
import org.neo4j.management.HighAvailability;
import org.neo4j.management.Neo4jManager;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class HaBeanIT {
    @Rule
    public final TestName testName = new TestName();
    private static final TargetDirectory dir = TargetDirectory.forTest(HaBeanIT.class);
    private ClusterManager.ManagedCluster cluster;
    private ClusterManager clusterManager;

    public void startCluster(int size) throws Throwable {
        this.clusterManager = new ClusterManager(ClusterManager.clusterOfSize(size), dir.cleanDirectory(this.testName.getMethodName()), MapUtil.stringMap((String[])new String[0])){

            @Override
            protected void config(GraphDatabaseBuilder builder, String clusterName, int serverId) {
                builder.setConfig("jmx.port", "" + (9912 + serverId));
                builder.setConfig(HaSettings.ha_server, ":" + (1136 + serverId));
                builder.setConfig(GraphDatabaseSettings.forced_kernel_id, HaBeanIT.this.testName.getMethodName() + serverId);
            }
        };
        this.clusterManager.start();
        this.cluster = this.clusterManager.getDefaultCluster();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
    }

    @After
    public void stopCluster() throws Throwable {
        this.clusterManager.stop();
    }

    public Neo4jManager beans(HighlyAvailableGraphDatabase db) {
        return new Neo4jManager((Kernel)((JmxKernelExtension)db.getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(Kernel.class));
    }

    public HighAvailability ha(HighlyAvailableGraphDatabase db) {
        return this.beans(db).getHighAvailabilityBean();
    }

    @Test
    public void canGetHaBean() throws Throwable {
        this.startCluster(1);
        HighAvailability ha = this.ha(this.cluster.getMaster());
        Assert.assertNotNull((String)"could not get ha bean", (Object)ha);
        this.assertMasterInformation(ha);
    }

    private void assertMasterInformation(HighAvailability ha) {
        Assert.assertTrue((String)"single instance should be master and available", (boolean)ha.isAvailable());
        Assert.assertEquals((String)"single instance should be master", (Object)"master", (Object)ha.getRole());
        ClusterMemberInfo info = ha.getInstancesInCluster()[0];
        Assert.assertEquals((String)"single instance should be the returned instance id", (Object)"1", (Object)info.getInstanceId());
    }

    @Test
    public void testLatestTxInfoIsCorrect() throws Throwable {
        this.startCluster(1);
        HighlyAvailableGraphDatabase db = this.cluster.getMaster();
        HighAvailability masterHa = this.ha(db);
        long lastCommitted = masterHa.getLastCommittedTxId();
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        tx.finish();
        Assert.assertEquals((long)(lastCommitted + 1L), (long)masterHa.getLastCommittedTxId());
    }

    @Test
    public void testUpdatePullWorksAndUpdatesLastUpdateTime() throws Throwable {
        this.startCluster(2);
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Transaction tx = master.beginTx();
        master.createNode();
        tx.success();
        tx.finish();
        HighAvailability slaveBean = this.ha(slave);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-DD kk:mm:ss.SSSZZZZ");
        Assert.assertEquals((Object)"N/A", (Object)slaveBean.getLastUpdateTime());
        slaveBean.update();
        long timeUpdated = format.parse(slaveBean.getLastUpdateTime()).getTime();
        Assert.assertTrue((timeUpdated > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testAfterGentleMasterSwitchClusterInfoIsCorrect() throws Throwable {
        this.startCluster(3);
        ClusterManager.RepairKit masterShutdown = this.cluster.shutdown(this.cluster.getMaster());
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        for (HighlyAvailableGraphDatabase db : this.cluster.getAllMembers()) {
            Assert.assertEquals((long)2L, (long)this.ha(db).getInstancesInCluster().length);
        }
        masterShutdown.repair();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        for (HighlyAvailableGraphDatabase db : this.cluster.getAllMembers()) {
            HighAvailability bean = this.ha(db);
            Assert.assertEquals((long)3L, (long)bean.getInstancesInCluster().length);
            for (ClusterMemberInfo info : bean.getInstancesInCluster()) {
                Assert.assertTrue((String)"every instance should be available", (boolean)info.isAvailable());
                Assert.assertTrue((String)"every instances should have at least one role", (info.getRoles().length > 0 ? 1 : 0) != 0);
                if ("master".equals(info.getRoles()[0])) {
                    Assert.assertEquals((String)"coordinator should be master", (Object)"master", (Object)info.getHaRole());
                } else {
                    Assert.assertEquals((String)"Either master or slave, no other way", (Object)"slave", (Object)info.getRoles()[0]);
                    Assert.assertEquals((String)("instance " + info.getInstanceId() + " is cluster slave but HA master"), (Object)"slave", (Object)info.getHaRole());
                }
                for (String uri : info.getUris()) {
                    Assert.assertTrue((String)"roles should contain URIs", (boolean)uri.startsWith("ha://"));
                }
            }
        }
    }

    @Test
    public void testAfterHardMasterSwitchClusterInfoIsCorrect() throws Throwable {
        this.startCluster(3);
        ClusterManager.RepairKit masterShutdown = this.cluster.fail(this.cluster.getMaster());
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        for (HighlyAvailableGraphDatabase db : this.cluster.getAllMembers()) {
            if (db.getInstanceState().equals(HighAvailabilityMemberState.PENDING.name())) continue;
            Assert.assertEquals((long)3L, (long)this.ha(db).getInstancesInCluster().length);
        }
        masterShutdown.repair();
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
        for (HighlyAvailableGraphDatabase db : this.cluster.getAllMembers()) {
            int mastersFound = 0;
            HighAvailability bean = this.ha(db);
            Assert.assertEquals((long)3L, (long)bean.getInstancesInCluster().length);
            for (ClusterMemberInfo info : bean.getInstancesInCluster()) {
                Assert.assertTrue((String)(bean.getInstanceId() + ": every instance should be available: " + info.getInstanceId()), (boolean)info.isAvailable());
                for (String role : info.getRoles()) {
                    if (!role.equals("master")) continue;
                    ++mastersFound;
                }
            }
            Assert.assertEquals((long)1L, (long)mastersFound);
        }
    }

    @Test
    public void canGetBranchedStoreBean() throws Throwable {
        this.startCluster(1);
        BranchedStore bs = this.beans(this.cluster.getMaster()).getBranchedStoreBean();
        Assert.assertNotNull((String)"could not get branched store bean", (Object)bs);
        Assert.assertEquals((String)"no branched stores for new db", (long)0L, (long)bs.getBranchedStores().length);
    }

    @Test
    @Ignore
    public void canGetInstanceConnectionInformation() throws Throwable {
        this.startCluster(1);
        ClusterMemberInfo[] clusterMembers = this.ha(this.cluster.getMaster()).getInstancesInCluster();
        Assert.assertNotNull((Object)clusterMembers);
        Assert.assertEquals((long)1L, (long)clusterMembers.length);
        ClusterMemberInfo clusterMember = clusterMembers[0];
        Assert.assertNotNull((Object)clusterMember);
        String id = clusterMember.getInstanceId();
        Assert.assertNotNull((String)"No instance id", (Object)id);
    }

    @Test
    @Ignore
    public void canConnectToInstance() throws Throwable {
        this.startCluster(1);
        ClusterMemberInfo[] clusterMembers = this.ha(this.cluster.getMaster()).getInstancesInCluster();
        Assert.assertNotNull((Object)clusterMembers);
        Assert.assertEquals((long)1L, (long)clusterMembers.length);
        ClusterMemberInfo clusterMember = clusterMembers[0];
        Assert.assertNotNull((Object)clusterMember);
        Pair proc = clusterMember.connect();
        Assert.assertNotNull((String)"could not connect", (Object)proc);
        Neo4jManager neo4j = (Neo4jManager)proc.first();
        HighAvailability ha = (HighAvailability)proc.other();
        Assert.assertNotNull((Object)neo4j);
        Assert.assertNotNull((Object)ha);
        clusterMembers = ha.getInstancesInCluster();
        Assert.assertNotNull((Object)clusterMembers);
        Assert.assertEquals((long)1L, (long)clusterMembers.length);
        Assert.assertEquals((Object)clusterMember.getInstanceId(), (Object)clusterMembers[0].getInstanceId());
    }

    @Test
    public void joinedInstanceShowsUpAsSlave() throws Throwable {
        this.startCluster(2);
        ClusterMemberInfo[] instancesInCluster = this.ha(this.cluster.getMaster()).getInstancesInCluster();
        Assert.assertEquals((long)2L, (long)instancesInCluster.length);
        ClusterMemberInfo[] secondInstancesInCluster = this.ha(this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0])).getInstancesInCluster();
        Assert.assertEquals((long)2L, (long)secondInstancesInCluster.length);
        this.assertMasterAndSlaveInformation(instancesInCluster);
        this.assertMasterAndSlaveInformation(secondInstancesInCluster);
    }

    @Test
    public void leftInstanceDisappearsFromMemberList() throws Throwable {
        this.startCluster(3);
        Assert.assertEquals((long)3L, (long)this.ha(this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0])).getInstancesInCluster().length);
        this.cluster.shutdown(this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesMembers(2));
        Assert.assertEquals((long)2L, (long)this.ha(this.cluster.getMaster()).getInstancesInCluster().length);
        this.assertMasterInformation(this.ha(this.cluster.getMaster()));
    }

    @Test
    public void failedMemberIsStillInMemberListAlthoughFailed() throws Throwable {
        this.startCluster(3);
        Assert.assertEquals((long)3L, (long)this.ha(this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0])).getInstancesInCluster().length);
        HighlyAvailableGraphDatabase failedDb = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        ClusterManager.RepairKit dbFailure = this.cluster.fail(failedDb);
        this.await(this.ha(this.cluster.getMaster()), this.dbAlive(false));
        this.await(this.ha(this.cluster.getAnySlave(failedDb)), this.dbAlive(false));
        dbFailure.repair();
        for (HighlyAvailableGraphDatabase db : this.cluster.getAllMembers()) {
            this.await(this.ha(db), this.dbAvailability(true));
            this.await(this.ha(db), this.dbAlive(true));
        }
    }

    private void assertMasterAndSlaveInformation(ClusterMemberInfo[] instancesInCluster) throws Exception {
        ClusterMemberInfo master = this.member(instancesInCluster, 1);
        Assert.assertEquals((long)1137L, (long)ServerUtil.getUriForScheme((String)"ha", (Iterable)Iterables.map((Function)new Function<String, URI>(){

            public URI apply(String from) {
                return URI.create(from);
            }
        }, Arrays.asList(master.getUris()))).getPort());
        Assert.assertEquals((Object)"master", (Object)master.getHaRole());
        ClusterMemberInfo slave = this.member(instancesInCluster, 2);
        Assert.assertEquals((long)1138L, (long)ServerUtil.getUriForScheme((String)"ha", (Iterable)Iterables.map((Function)new Function<String, URI>(){

            public URI apply(String from) {
                return URI.create(from);
            }
        }, Arrays.asList(slave.getUris()))).getPort());
        Assert.assertEquals((Object)"slave", (Object)slave.getHaRole());
        Assert.assertTrue((String)"Slave not available", (boolean)slave.isAvailable());
    }

    private ClusterMemberInfo member(ClusterMemberInfo[] members, int instanceId) {
        for (ClusterMemberInfo member : members) {
            if (!member.getInstanceId().equals(Integer.toString(instanceId))) continue;
            return member;
        }
        Assert.fail((String)("Couldn't find cluster member with cluster URI port " + instanceId + " among " + Arrays.toString(members)));
        return null;
    }

    private void await(HighAvailability ha, Predicate<ClusterMemberInfo> predicate) throws InterruptedException {
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(300L);
        boolean conditionMet = false;
        while (System.currentTimeMillis() < end) {
            conditionMet = predicate.accept((Object)this.member(ha.getInstancesInCluster(), 2));
            if (conditionMet) {
                return;
            }
            Thread.sleep(500L);
        }
        Assert.fail((String)"Failed instance didn't show up as such in JMX");
    }

    private Predicate<ClusterMemberInfo> dbAvailability(final boolean available) {
        return new Predicate<ClusterMemberInfo>(){

            public boolean accept(ClusterMemberInfo item) {
                return item.isAvailable() == available;
            }
        };
    }

    private Predicate<ClusterMemberInfo> dbAlive(final boolean alive) {
        return new Predicate<ClusterMemberInfo>(){

            public boolean accept(ClusterMemberInfo item) {
                return item.isAlive() == alive;
            }
        };
    }
}

