/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;

public class ConcurrentInstanceStartupIT {
    public static final int INSTANCE_COUNT = 3;
    public static TargetDirectory testDirectory = TargetDirectory.forTest(ConcurrentInstanceStartupIT.class);

    @Test
    public void concurrentStartupShouldWork() throws Exception {
        testDirectory.cleanDirectory("nothingToSeeHereMoveAlong");
        StringBuffer initialHostsBuffer = new StringBuffer("127.0.0.1:5001");
        for (int i = 2; i <= 3; ++i) {
            initialHostsBuffer.append(",127.0.0.1:500" + i);
        }
        final String initialHosts = initialHostsBuffer.toString();
        final CyclicBarrier barrier = new CyclicBarrier(3);
        ArrayList<Thread> daThreads = new ArrayList<Thread>(3);
        final HighlyAvailableGraphDatabase[] dbs = new HighlyAvailableGraphDatabase[3];
        int i = 1;
        while (i <= 3) {
            final int finalI = i++;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        barrier.await();
                        dbs[finalI - 1] = ConcurrentInstanceStartupIT.this.startDbAtBase(finalI, initialHosts);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    catch (BrokenBarrierException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            daThreads.add(t);
            t.start();
        }
        for (Thread daThread : daThreads) {
            daThread.join();
        }
        boolean masterDone = false;
        for (HighlyAvailableGraphDatabase db : dbs) {
            if (db.isMaster()) {
                if (masterDone) {
                    throw new Exception("Two masters discovered");
                }
                masterDone = true;
            }
            Transaction tx = db.beginTx();
            db.createNode();
            tx.success();
            tx.finish();
        }
        Assert.assertTrue((boolean)masterDone);
        for (HighlyAvailableGraphDatabase db : dbs) {
            db.shutdown();
        }
    }

    private HighlyAvailableGraphDatabase startDbAtBase(int i, String initialHosts) {
        GraphDatabaseBuilder masterBuilder = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.path(i).getAbsolutePath()).setConfig(ClusterSettings.initial_hosts, initialHosts).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (5000 + i)).setConfig(ClusterSettings.server_id, "" + i).setConfig(HaSettings.ha_server, ":" + (8000 + i)).setConfig(HaSettings.tx_push_factor, "0");
        return (HighlyAvailableGraphDatabase)masterBuilder.newGraphDatabase();
    }

    private File path(int i) {
        return testDirectory.cleanDirectory(i + "");
    }
}

