/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;

public class HighAvailabilityModeSwitcherTest {
    @Test
    public void shouldBroadcastMasterIsAvailableIfMasterAndReceiveMasterIsElected() throws Exception {
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), availability, StringLogger.DEV_NULL);
        toTest.masterIsElected(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.MASTER, HighAvailabilityMemberState.MASTER, new InstanceId(2), URI.create("ha://someone")));
        ((ClusterMemberAvailability)Mockito.verify((Object)availability, (VerificationMode)Mockito.times((int)1))).memberIsAvailable("master", null);
    }

    @Test
    public void shouldBroadcastSlaveIsAvailableIfSlaveAndReceivesMasterIsAvailable() throws Exception {
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), availability, StringLogger.DEV_NULL);
        toTest.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.SLAVE, HighAvailabilityMemberState.SLAVE, new InstanceId(2), URI.create("ha://someone")));
        ((ClusterMemberAvailability)Mockito.verify((Object)availability, (VerificationMode)Mockito.times((int)1))).memberIsAvailable("slave", null);
    }

    @Test
    public void shouldNotBroadcastIfSlaveAndReceivesMasterIsElected() throws Exception {
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), availability, StringLogger.DEV_NULL);
        toTest.masterIsElected(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.SLAVE, HighAvailabilityMemberState.SLAVE, new InstanceId(2), URI.create("ha://someone")));
        Mockito.verifyZeroInteractions((Object[])new Object[]{availability});
    }

    @Test
    public void shouldNotBroadcastIfMasterAndReceivesSlaveIsAvailable() throws Exception {
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), availability, StringLogger.DEV_NULL);
        toTest.slaveIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.MASTER, HighAvailabilityMemberState.MASTER, new InstanceId(2), URI.create("ha://someone")));
        Mockito.verifyZeroInteractions((Object[])new Object[]{availability});
    }

    @Test
    public void shouldReswitchToSlaveIfNewMasterBecameAvailableDuringSwitch() throws Throwable {
        final CountDownLatch switching = new CountDownLatch(1);
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch slaveAvailable = new CountDownLatch(2);
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        SwitchToSlave switchToSlave = (SwitchToSlave)Mockito.mock(SwitchToSlave.class);
        SwitchToMaster switchToMaster = (SwitchToMaster)Mockito.mock(SwitchToMaster.class);
        Mockito.when((Object)switchToSlave.switchToSlave((LifeSupport)Matchers.any(LifeSupport.class), (URI)Matchers.any(URI.class), (URI)Matchers.any(URI.class))).thenAnswer((Answer)new Answer<URI>(){

            public URI answer(InvocationOnMock invocationOnMock) throws Throwable {
                switching.countDown();
                latch.await();
                slaveAvailable.countDown();
                return URI.create("ha://slave");
            }
        });
        Logging logging = (Logging)Mockito.mock(Logging.class);
        ((Logging)Mockito.doReturn((Object)new ConsoleLogger(StringLogger.DEV_NULL)).when((Object)logging)).getConsoleLog(HighAvailabilityModeSwitcher.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher(switchToSlave, switchToMaster, (Election)Mockito.mock(Election.class), availability, StringLogger.DEV_NULL);
        toTest.init();
        toTest.start();
        toTest.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_SLAVE, new InstanceId(1), URI.create("ha://server1")));
        switching.await();
        toTest.masterIsElected(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.TO_SLAVE, HighAvailabilityMemberState.PENDING, new InstanceId(2), URI.create("ha://server2")));
        toTest.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_SLAVE, new InstanceId(2), URI.create("ha://server2")));
        latch.countDown();
        slaveAvailable.await();
    }
}

