/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.correctness;

import java.net.URI;
import java.util.Arrays;
import junit.framework.TestCase;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.ha.correctness.ClusterAction;
import org.neo4j.ha.correctness.ClusterInstance;
import org.neo4j.ha.correctness.ClusterState;
import org.neo4j.ha.correctness.MessageDeliveryAction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.util.TestLogging;
import org.neo4j.kernel.logging.Logging;

public class TestProver {
    @Test
    public void aClusterSnapshotShouldEqualItsOrigin() throws Exception {
        TestLogging logging = new TestLogging();
        ClusterConfiguration config = new ClusterConfiguration("default", logging.getMessagesLog(ClusterConfiguration.class), new String[]{"cluster://localhost:5001", "cluster://localhost:5002", "cluster://localhost:5003"});
        ClusterState state = new ClusterState(Arrays.asList(ClusterInstance.newClusterInstance(new InstanceId(1), new URI("cluster://localhost:5001"), config, (Logging)logging), ClusterInstance.newClusterInstance(new InstanceId(2), new URI("cluster://localhost:5002"), config, (Logging)logging), ClusterInstance.newClusterInstance(new InstanceId(3), new URI("cluster://localhost:5003"), config, (Logging)logging)), IteratorUtil.emptySetOf(ClusterAction.class));
        ClusterState snapshot = state.snapshot();
        TestCase.assertEquals((Object)state, (Object)snapshot);
        TestCase.assertEquals((int)state.hashCode(), (int)snapshot.hashCode());
    }

    @Test
    public void twoStatesWithSameSetupAndPendingMessagesShouldBeEqual() throws Exception {
        TestLogging logging = new TestLogging();
        ClusterConfiguration config = new ClusterConfiguration("default", logging.getMessagesLog(ClusterConfiguration.class), new String[]{"cluster://localhost:5001", "cluster://localhost:5002", "cluster://localhost:5003"});
        ClusterState state = new ClusterState(Arrays.asList(ClusterInstance.newClusterInstance(new InstanceId(1), new URI("cluster://localhost:5001"), config, (Logging)logging), ClusterInstance.newClusterInstance(new InstanceId(2), new URI("cluster://localhost:5002"), config, (Logging)logging), ClusterInstance.newClusterInstance(new InstanceId(3), new URI("cluster://localhost:5003"), config, (Logging)logging)), IteratorUtil.emptySetOf(ClusterAction.class));
        ClusterState firstState = state.performAction(new MessageDeliveryAction(Message.to((MessageType)ClusterMessage.join, (URI)new URI("cluster://localhost:5002"), (Object)new Object[]{"defaultcluster", new URI[]{new URI("cluster://localhost:5003")}}).setHeader("conversation-id", "-1").setHeader("from", "cluster://localhost:5002")));
        ClusterState secondState = state.performAction(new MessageDeliveryAction(Message.to((MessageType)ClusterMessage.join, (URI)new URI("cluster://localhost:5002"), (Object)new Object[]{"defaultcluster", new URI[]{new URI("cluster://localhost:5003")}}).setHeader("conversation-id", "-1").setHeader("from", "cluster://localhost:5002")));
        TestCase.assertEquals((Object)firstState, (Object)secondState);
        TestCase.assertEquals((int)firstState.hashCode(), (int)secondState.hashCode());
    }
}

