/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.transaction.DenseNodeTransactionTranslator;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdSequence;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.xa.LogEntryVerifyingOutput;
import org.neo4j.kernel.impl.nioneo.xa.TransactionDataBuilder;
import org.neo4j.kernel.impl.nioneo.xa.TransactionWriter;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.nioneo.xa.command.CommandRecordVisitor;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.EphemeralFileSystemRule;

public class DenseNodeTransactionTranslatorTest {
    @Rule
    public final CleanupRule cleanup = new CleanupRule();
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void shouldConvertFirstRelationshipForNodeCreation() throws Exception {
        final Id nodeId = DenseNodeTransactionTranslatorTest.id();
        final Id relationshipId = DenseNodeTransactionTranslatorTest.id();
        final Id type = DenseNodeTransactionTranslatorTest.id();
        NeoStore existingStore = this.existingStore(new ExistingContents(){

            @Override
            public void fill(NeoStore neoStore, TransactionDataBuilder transaction) {
                type.get((IdSequence)neoStore.getRelationshipTypeStore());
                relationshipId.get((IdSequence)neoStore.getRelationshipStore());
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get((IdSequence)neoStore.getNodeStore())).asInUse());
            }
        });
        List<LogEntry> transaction = this.transaction(new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()).asInUse().withNextRel(relationshipId.get()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(relationshipId.get(), nodeId.get(), nodeId.get(), (int)type.get()).asInUse());
            }
        });
        List<LogEntry> translated = this.translate(existingStore, transaction);
        Assert.assertThat(translated, DenseNodeTransactionTranslatorTest.matchesLogEntriesIn(transaction));
    }

    private static Matcher<? super List<LogEntry>> matchesLogEntriesIn(final List<LogEntry> transaction) {
        return new BaseMatcher<List<LogEntry>>(){

            public boolean matches(Object item) {
                if (!(item instanceof List)) {
                    return false;
                }
                List incoming = (List)item;
                if (incoming.size() != transaction.size()) {
                    return false;
                }
                boolean lastCompare = true;
                block8: for (int i = 0; i < incoming.size() && lastCompare; ++i) {
                    LogEntry incomingEntry = (LogEntry)incoming.get(i);
                    LogEntry realEntry = (LogEntry)transaction.get(i);
                    if (incomingEntry.getType() != realEntry.getType()) {
                        return false;
                    }
                    switch (incomingEntry.getType()) {
                        case 1: {
                            lastCompare = lastCompare && this.compareStartEntries((LogEntry.Start)incomingEntry, (LogEntry.Start)realEntry);
                            continue block8;
                        }
                        case 3: {
                            lastCompare = lastCompare && this.compareCommandEntries((LogEntry.Command)incomingEntry, (LogEntry.Command)realEntry);
                            continue block8;
                        }
                        case 5: {
                            lastCompare = lastCompare && this.compare1PCEntries((LogEntry.OnePhaseCommit)incomingEntry, (LogEntry.OnePhaseCommit)realEntry);
                            continue block8;
                        }
                        case 6: {
                            lastCompare = lastCompare && this.compare2PCEntries((LogEntry.TwoPhaseCommit)incomingEntry, (LogEntry.TwoPhaseCommit)realEntry);
                            continue block8;
                        }
                        case 2: {
                            lastCompare = lastCompare && this.comparePrepareEntries((LogEntry.Prepare)incomingEntry, (LogEntry.Prepare)realEntry);
                            continue block8;
                        }
                        case 4: {
                            lastCompare = lastCompare && this.compareDoneEntries((LogEntry.Done)incoming, (LogEntry.Done)realEntry);
                            continue block8;
                        }
                        default: {
                            throw new IllegalArgumentException("What am i supposed to do with command entry " + incomingEntry + " ?");
                        }
                    }
                }
                return lastCompare;
            }

            private boolean compareStartEntries(LogEntry.Start incomingEntry, LogEntry.Start realEntry) {
                if (!this.compareBaseEntries((LogEntry)incomingEntry, (LogEntry)realEntry)) {
                    return false;
                }
                if (incomingEntry.getLastCommittedTxWhenTransactionStarted() != realEntry.getLastCommittedTxWhenTransactionStarted()) {
                    return false;
                }
                if (incomingEntry.getMasterId() != realEntry.getMasterId()) {
                    return false;
                }
                if (incomingEntry.getLocalId() != realEntry.getLocalId()) {
                    return false;
                }
                if (incomingEntry.getStartPosition() != realEntry.getStartPosition()) {
                    return false;
                }
                if (incomingEntry.getTimeWritten() != realEntry.getTimeWritten()) {
                    return false;
                }
                return incomingEntry.getXid().equals(realEntry.getXid());
            }

            private boolean compareCommandEntries(LogEntry.Command incomingEntry, LogEntry.Command realEntry) {
                if (!this.compareBaseEntries((LogEntry)incomingEntry, (LogEntry)realEntry)) {
                    return false;
                }
                return incomingEntry.getXaCommand().equals(realEntry.getXaCommand());
            }

            private boolean compare1PCEntries(LogEntry.OnePhaseCommit incomingEntry, LogEntry.OnePhaseCommit realEntry) {
                if (!this.compareBaseEntries((LogEntry)incomingEntry, (LogEntry)realEntry)) {
                    return false;
                }
                if (incomingEntry.getTimeWritten() != realEntry.getTimeWritten()) {
                    return false;
                }
                return incomingEntry.getTxId() == realEntry.getTxId();
            }

            private boolean compare2PCEntries(LogEntry.TwoPhaseCommit incomingEntry, LogEntry.TwoPhaseCommit realEntry) {
                if (!this.compareBaseEntries((LogEntry)incomingEntry, (LogEntry)realEntry)) {
                    return false;
                }
                if (incomingEntry.getTimeWritten() != realEntry.getTimeWritten()) {
                    return false;
                }
                return incomingEntry.getTxId() == realEntry.getTxId();
            }

            private boolean comparePrepareEntries(LogEntry.Prepare incomingEntry, LogEntry.Prepare realEntry) {
                if (!this.compareBaseEntries((LogEntry)incomingEntry, (LogEntry)realEntry)) {
                    return false;
                }
                return incomingEntry.getTimeWritten() == realEntry.getTimeWritten();
            }

            private boolean compareDoneEntries(LogEntry.Done incomingEntry, LogEntry.Done realEntry) {
                return this.compareBaseEntries((LogEntry)incomingEntry, (LogEntry)realEntry);
            }

            private boolean compareBaseEntries(LogEntry incoming, LogEntry real) {
                if (incoming.getIdentifier() != real.getIdentifier()) {
                    return false;
                }
                return incoming.getType() == real.getType();
            }

            public void describeTo(Description description) {
            }
        };
    }

    @Test
    public void shouldCreateTheFirstRelationshipOfNewTypeForDenseNode() throws Exception {
        final Id denseNodeId = DenseNodeTransactionTranslatorTest.id();
        final Id otherNodeId = DenseNodeTransactionTranslatorTest.id();
        final Id thirdNodeId = DenseNodeTransactionTranslatorTest.id();
        final Id firstRelationshipId = DenseNodeTransactionTranslatorTest.id();
        final Id otherRelationshipId = DenseNodeTransactionTranslatorTest.id();
        final Id groupAId = DenseNodeTransactionTranslatorTest.id();
        final Id typeA = DenseNodeTransactionTranslatorTest.id();
        final Id typeB = DenseNodeTransactionTranslatorTest.id();
        NeoStore existingStore = this.existingStore(new ExistingContents(){

            @Override
            public void fill(NeoStore neoStore, TransactionDataBuilder transaction) {
                transaction.create((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupAId.get((IdSequence)neoStore.getRelationshipGroupStore()), (int)typeA.get((IdSequence)neoStore.getRelationshipTypeStore())).asInUse().withFirstOut(firstRelationshipId.get((IdSequence)neoStore.getRelationshipStore())));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(denseNodeId.get((IdSequence)neoStore.getNodeStore())).asInUse().asDense().withNextRel(groupAId.get()));
                otherRelationshipId.get((IdSequence)neoStore.getRelationshipStore());
                typeB.get((IdSequence)neoStore.getRelationshipTypeStore());
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(otherNodeId.get((IdSequence)neoStore.getNodeStore())).asInUse());
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(thirdNodeId.get((IdSequence)neoStore.getNodeStore())).asInUse());
            }
        });
        List<LogEntry> translated = this.translate(existingStore, this.transaction(new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(denseNodeId.get()).asInUse().asDense().withNextRel(groupAId.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(denseNodeId.get()).asInUse().withNextRel(otherRelationshipId.get()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(otherRelationshipId.get(), thirdNodeId.get(), denseNodeId.get(), (int)typeB.get()).asInUse().withEndPointers(-1L, firstRelationshipId.get()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(firstRelationshipId.get(), denseNodeId.get(), otherNodeId.get(), (int)typeA.get()).asInUse().withStartPointers(otherRelationshipId.get(), -1L));
            }
        }));
        this.assertTranslatedTransaction(translated, new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(denseNodeId.get()).asInUse().asDense().withNextRel(groupAId.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(denseNodeId.get()).asInUse().asDense().withNextRel(groupAId.get()));
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(otherNodeId.get()).asInUse(), (NodeRecord)DenseNodeTransactionTranslatorTest.node(otherNodeId.get()).asInUse().withNextRel(firstRelationshipId.get()));
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(thirdNodeId.get()).asInUse(), (NodeRecord)DenseNodeTransactionTranslatorTest.node(thirdNodeId.get()).asInUse().withNextRel(otherRelationshipId.get()));
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(firstRelationshipId.get(), denseNodeId.get(), otherNodeId.get(), (int)typeA.get()).asInUse().withStartPointers(otherRelationshipId.get(), -1L));
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(otherRelationshipId.get(), thirdNodeId.get(), denseNodeId.get(), (int)typeB.get()).asInUse().withEndPointers(-1L, firstRelationshipId.get()));
                transaction.update((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupAId.get(), (int)typeA.get()).asInUse().withNextGroup(groupAId.get() + 1L).withFirstOut(firstRelationshipId.get()));
                transaction.update((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupAId.get() + 1L, (int)typeB.get()).asInUse().withFirstIn(otherRelationshipId.get()));
            }
        });
    }

    @Test
    public void shouldUpdateNodeWithAlteredProperty() throws Exception {
        final Id nodeId = DenseNodeTransactionTranslatorTest.id();
        NeoStore existingStore = this.existingStore(new ExistingContents(){

            @Override
            public void fill(NeoStore neoStore, TransactionDataBuilder transaction) {
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get((IdSequence)neoStore.getNodeStore())).asInUse().asDense());
            }
        });
        List<LogEntry> translated = this.translate(existingStore, this.transaction(new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()).asInUse(), (NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()).asInUse().withNextProperty(12L));
            }
        }));
        this.assertTranslatedTransaction(translated, new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()).asInUse().asDense(), (NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()).asInUse().asDense().withNextProperty(12L));
            }
        });
    }

    @Test
    public void shouldCreateCreatedNode() throws Exception {
        final Id nodeId = DenseNodeTransactionTranslatorTest.id();
        NeoStore existingStore = this.existingStore(new ExistingContents(){

            @Override
            public void fill(NeoStore neoStore, TransactionDataBuilder transaction) {
                nodeId.get((IdSequence)neoStore.getNodeStore());
            }
        });
        List<LogEntry> translated = this.translate(existingStore, this.transaction(new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()));
            }
        }));
        this.assertTranslatedTransaction(translated, new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()));
            }
        });
    }

    @Test
    public void shouldCreateNodeWithPropertyAndLabelSet() throws Exception {
        final Id nodeId = DenseNodeTransactionTranslatorTest.id();
        NeoStore existingStore = this.existingStore(new ExistingContents(){

            @Override
            public void fill(NeoStore neoStore, TransactionDataBuilder transaction) {
                nodeId.get((IdSequence)neoStore.getNodeStore());
            }
        });
        List<LogEntry> translated = this.translate(existingStore, this.transaction(new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()).withNextProperty(13L).withLabelField(42L, Collections.emptySet()));
            }
        }));
        this.assertTranslatedTransaction(translated, new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()).withNextProperty(13L).withLabelField(42L, Collections.emptySet()));
            }
        });
    }

    @Test
    public void shouldDeleteDeletedNode() throws Exception {
        final Id nodeId = DenseNodeTransactionTranslatorTest.id();
        NeoStore existingStore = this.existingStore(new ExistingContents(){

            @Override
            public void fill(NeoStore neoStore, TransactionDataBuilder transaction) {
                nodeId.get((IdSequence)neoStore.getNodeStore());
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()).asInUse());
            }
        });
        List<LogEntry> translated = this.translate(existingStore, this.transaction(new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.delete((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()));
            }
        }));
        this.assertTranslatedTransaction(translated, new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.delete((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()));
            }
        });
    }

    @Test
    public void shouldPassThroughNonNodeAndRelationshipCommands() throws Exception {
        final Id keyTokenId = DenseNodeTransactionTranslatorTest.id();
        final HashSet<DynamicRecord> schemaBefore = new HashSet<DynamicRecord>();
        final HashSet<DynamicRecord> schemaAfter = new HashSet<DynamicRecord>();
        schemaBefore.add(new DynamicRecord(10L));
        schemaBefore.add(new DynamicRecord(11L));
        schemaAfter.add(new DynamicRecord(10L));
        schemaAfter.add(new DynamicRecord(11L));
        schemaAfter.add(new DynamicRecord(13L));
        NeoStore existingStore = this.existingStore(new ExistingContents(){

            @Override
            public void fill(NeoStore neoStore, TransactionDataBuilder transaction) {
                keyTokenId.get((IdSequence)neoStore.getLabelTokenStore());
            }
        });
        List<LogEntry> translated = this.translate(existingStore, this.transaction(new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.create((PropertyKeyTokenRecord)DenseNodeTransactionTranslatorTest.propertyKeyToken((int)keyTokenId.get()));
                transaction.update((NeoStoreRecord)DenseNodeTransactionTranslatorTest.neoStore());
                transaction.update(DenseNodeTransactionTranslatorTest.schemaRule(schemaBefore, schemaAfter, (SchemaRule)IndexRule.indexRule((long)19L, (int)14, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("lucene", "2.1"))));
                Command.RelationshipTypeTokenCommand typeCommand = new Command.RelationshipTypeTokenCommand();
                typeCommand.init(new RelationshipTypeTokenRecord(12));
                transaction.create(typeCommand);
                transaction.create(new LabelTokenRecord(12));
            }
        }));
        this.assertTranslatedTransaction(translated, new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.create((PropertyKeyTokenRecord)DenseNodeTransactionTranslatorTest.propertyKeyToken((int)keyTokenId.get()));
                transaction.update((NeoStoreRecord)DenseNodeTransactionTranslatorTest.neoStore());
                transaction.update(DenseNodeTransactionTranslatorTest.schemaRule(schemaBefore, schemaAfter, (SchemaRule)IndexRule.indexRule((long)19L, (int)14, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("lucene", "2.1"))));
                Command.RelationshipTypeTokenCommand typeCommand = new Command.RelationshipTypeTokenCommand();
                typeCommand.init(new RelationshipTypeTokenRecord(12));
                transaction.create(typeCommand);
                transaction.create(new LabelTokenRecord(12));
            }
        });
    }

    @Test
    public void shouldUpdateNodeWithAlteredLabel() throws Exception {
        final Id nodeId = DenseNodeTransactionTranslatorTest.id();
        NeoStore existingStore = this.existingStore(new ExistingContents(){

            @Override
            public void fill(NeoStore neoStore, TransactionDataBuilder transaction) {
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get((IdSequence)neoStore.getNodeStore())).asInUse().asDense());
            }
        });
        List<LogEntry> translated = this.translate(existingStore, this.transaction(new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()).asInUse(), (NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()).asInUse().withLabelField(14L, Collections.emptySet()));
            }
        }));
        this.assertTranslatedTransaction(translated, new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()).asInUse().asDense(), (NodeRecord)DenseNodeTransactionTranslatorTest.node(nodeId.get()).asInUse().asDense().withLabelField(14L, Collections.emptySet()));
            }
        });
    }

    @Test
    public void shouldUpdateRelationshipWithAlteredProperty() throws Exception {
        final Id startNodeId = DenseNodeTransactionTranslatorTest.id();
        final Id endNodeId = DenseNodeTransactionTranslatorTest.id();
        final Id relationshipId = DenseNodeTransactionTranslatorTest.id();
        final Id typeId = DenseNodeTransactionTranslatorTest.id();
        NeoStore existingStore = this.existingStore(new ExistingContents(){

            @Override
            public void fill(NeoStore neoStore, TransactionDataBuilder transaction) {
                startNodeId.get((IdSequence)neoStore.getNodeStore());
                endNodeId.get((IdSequence)neoStore.getNodeStore());
                relationshipId.get((IdSequence)neoStore.getRelationshipStore());
                typeId.get((IdSequence)neoStore.getRelationshipTypeStore());
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(startNodeId.get()).asInUse().withNextRel(relationshipId.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(endNodeId.get()).asInUse().withNextRel(relationshipId.get()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(relationshipId.get(), startNodeId.get(), endNodeId.get(), (int)typeId.get()).asInUse());
            }
        });
        List<LogEntry> translated = this.translate(existingStore, this.transaction(new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(relationshipId.get(), startNodeId.get(), endNodeId.get(), (int)typeId.get()).asInUse().withNextProperty(12L));
            }
        }));
        this.assertTranslatedTransaction(translated, new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(relationshipId.get(), startNodeId.get(), endNodeId.get(), (int)typeId.get()).asInUse().withNextProperty(12L));
            }
        });
    }

    @Test
    public void deleteRelationshipOnEachSideOfRelationshipOnMasterWhichIsDenseOnSlave() throws Exception {
        final Id denseNodeId = DenseNodeTransactionTranslatorTest.id();
        final Id target1 = DenseNodeTransactionTranslatorTest.id();
        final Id target2 = DenseNodeTransactionTranslatorTest.id();
        final Id target3 = DenseNodeTransactionTranslatorTest.id();
        final Id target4 = DenseNodeTransactionTranslatorTest.id();
        final Id rel1Id = DenseNodeTransactionTranslatorTest.id();
        final Id rel2Id = DenseNodeTransactionTranslatorTest.id();
        final Id rel3Id = DenseNodeTransactionTranslatorTest.id();
        final Id rel4Id = DenseNodeTransactionTranslatorTest.id();
        final Id groupAId = DenseNodeTransactionTranslatorTest.id();
        final Id groupBId = DenseNodeTransactionTranslatorTest.id();
        final Id groupCId = DenseNodeTransactionTranslatorTest.id();
        final Id typeA = DenseNodeTransactionTranslatorTest.id();
        final Id typeB = DenseNodeTransactionTranslatorTest.id();
        final Id typeC = DenseNodeTransactionTranslatorTest.id();
        NeoStore existingStore = this.existingStore(new ExistingContents(){

            @Override
            public void fill(NeoStore neoStore, TransactionDataBuilder transaction) {
                groupAId.get((IdSequence)neoStore.getRelationshipGroupStore());
                groupBId.get((IdSequence)neoStore.getRelationshipGroupStore());
                groupCId.get((IdSequence)neoStore.getRelationshipGroupStore());
                typeA.get((IdSequence)neoStore.getRelationshipTypeStore());
                typeB.get((IdSequence)neoStore.getRelationshipTypeStore());
                typeC.get((IdSequence)neoStore.getRelationshipTypeStore());
                denseNodeId.get((IdSequence)neoStore.getNodeStore());
                target1.get((IdSequence)neoStore.getNodeStore());
                target2.get((IdSequence)neoStore.getNodeStore());
                target3.get((IdSequence)neoStore.getNodeStore());
                target4.get((IdSequence)neoStore.getNodeStore());
                rel1Id.get((IdSequence)neoStore.getRelationshipStore());
                rel2Id.get((IdSequence)neoStore.getRelationshipStore());
                rel3Id.get((IdSequence)neoStore.getRelationshipStore());
                rel4Id.get((IdSequence)neoStore.getRelationshipStore());
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(denseNodeId.get()).asInUse().asDense().withNextRel(groupAId.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target1.get()).asInUse().withNextRel(rel1Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(rel2Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target3.get()).asInUse().withNextRel(rel3Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(rel4Id.get()));
                transaction.create((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupAId.get(), (int)typeA.get()).asInUse().withFirstOut(rel1Id.get()).withNextGroup(groupBId.get()));
                transaction.create((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupBId.get(), (int)typeB.get()).asInUse().withFirstOut(rel2Id.get()).withNextGroup(groupCId.get()));
                transaction.create((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupCId.get(), (int)typeC.get()).asInUse().withFirstOut(rel4Id.get()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel1Id.get(), denseNodeId.get(), target1.get(), (int)typeA.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), rel2Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel2Id.get(), denseNodeId.get(), target2.get(), (int)typeB.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel3Id.get(), denseNodeId.get(), target3.get(), (int)typeA.get()).asInUse().withStartPointers(rel1Id.get(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel4Id.get(), denseNodeId.get(), target4.get(), (int)typeC.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
            }
        });
        List<LogEntry> translated = this.translate(existingStore, this.transaction(new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel1Id.get(), denseNodeId.get(), target1.get(), (int)typeA.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), rel3Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel3Id.get(), denseNodeId.get(), target3.get(), (int)typeB.get()).asInUse().withStartPointers(rel1Id.get(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel2Id.get(), denseNodeId.get(), target2.get(), (int)typeA.get()));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel4Id.get(), denseNodeId.get(), target4.get(), (int)typeC.get()));
            }
        }));
        this.assertTranslatedTransaction(translated, new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel2Id.get(), denseNodeId.get(), target2.get(), (int)typeB.get()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel4Id.get(), denseNodeId.get(), target4.get(), (int)typeC.get()));
                transaction.update((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupAId.get(), (int)typeA.get()).asInUse().withFirstOut(rel1Id.get()).withNextGroup(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.delete((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupBId.get(), (int)typeB.get()));
                transaction.delete((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupCId.get(), (int)typeC.get()));
            }
        });
    }

    @Test
    public void deleteRelationshipOnEachSideOfRelationshipWithChangePropertyOnMasterWhichIsDenseOnSlave() throws Exception {
        final Id denseNodeId = DenseNodeTransactionTranslatorTest.id();
        final Id target1 = DenseNodeTransactionTranslatorTest.id();
        final Id target2 = DenseNodeTransactionTranslatorTest.id();
        final Id target3 = DenseNodeTransactionTranslatorTest.id();
        final Id target4 = DenseNodeTransactionTranslatorTest.id();
        final Id rel1Id = DenseNodeTransactionTranslatorTest.id();
        final Id rel2Id = DenseNodeTransactionTranslatorTest.id();
        final Id rel3Id = DenseNodeTransactionTranslatorTest.id();
        final Id rel4Id = DenseNodeTransactionTranslatorTest.id();
        final Id groupAId = DenseNodeTransactionTranslatorTest.id();
        final Id groupBId = DenseNodeTransactionTranslatorTest.id();
        final Id groupCId = DenseNodeTransactionTranslatorTest.id();
        final Id typeA = DenseNodeTransactionTranslatorTest.id();
        final Id typeB = DenseNodeTransactionTranslatorTest.id();
        final Id typeC = DenseNodeTransactionTranslatorTest.id();
        final Id propId = DenseNodeTransactionTranslatorTest.id();
        NeoStore existingStore = this.existingStore(new ExistingContents(){

            @Override
            public void fill(NeoStore neoStore, TransactionDataBuilder transaction) {
                groupAId.get((IdSequence)neoStore.getRelationshipGroupStore());
                groupBId.get((IdSequence)neoStore.getRelationshipGroupStore());
                groupCId.get((IdSequence)neoStore.getRelationshipGroupStore());
                typeA.get((IdSequence)neoStore.getRelationshipTypeStore());
                typeB.get((IdSequence)neoStore.getRelationshipTypeStore());
                typeC.get((IdSequence)neoStore.getRelationshipTypeStore());
                denseNodeId.get((IdSequence)neoStore.getNodeStore());
                target1.get((IdSequence)neoStore.getNodeStore());
                target2.get((IdSequence)neoStore.getNodeStore());
                target3.get((IdSequence)neoStore.getNodeStore());
                target4.get((IdSequence)neoStore.getNodeStore());
                rel1Id.get((IdSequence)neoStore.getRelationshipStore());
                rel2Id.get((IdSequence)neoStore.getRelationshipStore());
                rel3Id.get((IdSequence)neoStore.getRelationshipStore());
                rel4Id.get((IdSequence)neoStore.getRelationshipStore());
                propId.get((IdSequence)neoStore.getPropertyStore());
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(denseNodeId.get()).asInUse().asDense().withNextRel(groupAId.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target1.get()).asInUse().withNextRel(rel1Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(rel2Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target3.get()).asInUse().withNextRel(rel3Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(rel4Id.get()));
                transaction.create((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupAId.get(), (int)typeA.get()).asInUse().withFirstOut(rel1Id.get()).withNextGroup(groupBId.get()));
                transaction.create((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupBId.get(), (int)typeB.get()).asInUse().withFirstOut(rel2Id.get()).withNextGroup(groupCId.get()));
                transaction.create((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupCId.get(), (int)typeC.get()).asInUse().withFirstOut(rel4Id.get()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel1Id.get(), denseNodeId.get(), target1.get(), (int)typeA.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), rel3Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel2Id.get(), denseNodeId.get(), target2.get(), (int)typeB.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel3Id.get(), denseNodeId.get(), target3.get(), (int)typeA.get()).asInUse().withStartPointers(rel1Id.get(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).withNextProperty(propId.get()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel4Id.get(), denseNodeId.get(), target4.get(), (int)typeC.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.create((PropertyRecord)DenseNodeTransactionTranslatorTest.property(propId.get()).asInUse().withRelId(rel3Id.get()));
            }
        });
        List<LogEntry> translated = this.translate(existingStore, this.transaction(new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(rel2Id.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(rel4Id.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel2Id.get(), denseNodeId.get(), target2.get(), (int)typeB.get()));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel4Id.get(), denseNodeId.get(), target4.get(), (int)typeC.get()));
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel1Id.get(), denseNodeId.get(), target1.get(), (int)typeA.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), rel3Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel3Id.get(), denseNodeId.get(), target3.get(), (int)typeA.get()).asInUse().withStartPointers(rel1Id.get(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).withNextProperty(Record.NO_NEXT_PROPERTY.intValue()));
                transaction.delete((PropertyRecord)DenseNodeTransactionTranslatorTest.property(propId.get()).asInUse().withRelId(rel3Id.get()), (PropertyRecord)DenseNodeTransactionTranslatorTest.property(propId.get()).withRelId(rel3Id.get()));
            }
        }));
        this.assertTranslatedTransaction(translated, new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(rel2Id.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(rel4Id.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel3Id.get(), denseNodeId.get(), target3.get(), (int)typeA.get()).asInUse().withStartPointers(rel1Id.get(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).withNextProperty(Record.NO_NEXT_PROPERTY.intValue()).asFirstInFirstChain(false).asFirstInSecondChain(false));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel2Id.get(), denseNodeId.get(), target2.get(), (int)typeB.get()));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel4Id.get(), denseNodeId.get(), target4.get(), (int)typeC.get()));
                transaction.update((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupAId.get(), (int)typeA.get()).asInUse().withFirstOut(rel1Id.get()).withNextGroup(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.delete((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupBId.get(), (int)typeB.get()));
                transaction.delete((RelationshipGroupRecord)DenseNodeTransactionTranslatorTest.group(groupCId.get(), (int)typeC.get()));
                transaction.delete((PropertyRecord)DenseNodeTransactionTranslatorTest.property(propId.get()).asInUse().withRelId(rel3Id.get()), (PropertyRecord)DenseNodeTransactionTranslatorTest.property(propId.get()).withRelId(rel3Id.get()));
            }
        });
    }

    @Test
    public void deleteRelationshipOnEachSideOfRelationshipOnMasterWhichIsNotDenseOnSlave() throws Exception {
        final Id denseNodeId = DenseNodeTransactionTranslatorTest.id();
        final Id target1 = DenseNodeTransactionTranslatorTest.id();
        final Id target2 = DenseNodeTransactionTranslatorTest.id();
        final Id target3 = DenseNodeTransactionTranslatorTest.id();
        final Id target4 = DenseNodeTransactionTranslatorTest.id();
        final Id rel1Id = DenseNodeTransactionTranslatorTest.id();
        final Id rel2Id = DenseNodeTransactionTranslatorTest.id();
        final Id rel3Id = DenseNodeTransactionTranslatorTest.id();
        final Id rel4Id = DenseNodeTransactionTranslatorTest.id();
        final Id typeA = DenseNodeTransactionTranslatorTest.id();
        final Id typeB = DenseNodeTransactionTranslatorTest.id();
        final Id typeC = DenseNodeTransactionTranslatorTest.id();
        NeoStore existingStore = this.existingStore(new ExistingContents(){

            @Override
            public void fill(NeoStore neoStore, TransactionDataBuilder transaction) {
                typeA.get((IdSequence)neoStore.getRelationshipTypeStore());
                typeB.get((IdSequence)neoStore.getRelationshipTypeStore());
                typeC.get((IdSequence)neoStore.getRelationshipTypeStore());
                denseNodeId.get((IdSequence)neoStore.getNodeStore());
                target1.get((IdSequence)neoStore.getNodeStore());
                target2.get((IdSequence)neoStore.getNodeStore());
                target3.get((IdSequence)neoStore.getNodeStore());
                target4.get((IdSequence)neoStore.getNodeStore());
                rel1Id.get((IdSequence)neoStore.getRelationshipStore());
                rel2Id.get((IdSequence)neoStore.getRelationshipStore());
                rel3Id.get((IdSequence)neoStore.getRelationshipStore());
                rel4Id.get((IdSequence)neoStore.getRelationshipStore());
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(denseNodeId.get()).asInUse().withNextRel(rel1Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target1.get()).asInUse().withNextRel(rel1Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(rel2Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target3.get()).asInUse().withNextRel(rel3Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(rel4Id.get()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel1Id.get(), denseNodeId.get(), target1.get(), (int)typeA.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), rel2Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel2Id.get(), denseNodeId.get(), target2.get(), (int)typeA.get()).asInUse().withStartPointers(rel1Id.get(), rel3Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).asFirstInFirstChain(false).asFirstInSecondChain(true));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel3Id.get(), denseNodeId.get(), target3.get(), (int)typeB.get()).asInUse().withStartPointers(rel2Id.get(), rel4Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).asFirstInFirstChain(false).asFirstInSecondChain(true));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel4Id.get(), denseNodeId.get(), target4.get(), (int)typeC.get()).asInUse().withStartPointers(rel3Id.get(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).asFirstInFirstChain(false).asFirstInSecondChain(true));
            }
        });
        List<LogEntry> translated = this.translate(existingStore, this.transaction(new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(rel2Id.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(rel4Id.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel2Id.get(), denseNodeId.get(), target2.get(), (int)typeA.get()));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel4Id.get(), denseNodeId.get(), target4.get(), (int)typeC.get()));
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel1Id.get(), denseNodeId.get(), target1.get(), (int)typeA.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), rel3Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel3Id.get(), denseNodeId.get(), target3.get(), (int)typeB.get()).asInUse().withStartPointers(rel1Id.get(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
            }
        }));
        this.assertTranslatedTransaction(translated, new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(rel4Id.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(rel4Id.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel2Id.get(), denseNodeId.get(), target2.get(), (int)typeA.get()));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel4Id.get(), denseNodeId.get(), target4.get(), (int)typeC.get()));
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel1Id.get(), denseNodeId.get(), target1.get(), (int)typeA.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), rel3Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel3Id.get(), denseNodeId.get(), target3.get(), (int)typeB.get()).asInUse().withStartPointers(rel1Id.get(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
            }
        });
    }

    @Test
    public void deleteRelationshipOnEachSideOfRelationshipWithPropertyChangeOnMasterWhichIsNotDenseOnSlave() throws Exception {
        final Id denseNodeId = DenseNodeTransactionTranslatorTest.id();
        final Id target1 = DenseNodeTransactionTranslatorTest.id();
        final Id target2 = DenseNodeTransactionTranslatorTest.id();
        final Id target3 = DenseNodeTransactionTranslatorTest.id();
        final Id target4 = DenseNodeTransactionTranslatorTest.id();
        final Id rel1Id = DenseNodeTransactionTranslatorTest.id();
        final Id rel2Id = DenseNodeTransactionTranslatorTest.id();
        final Id rel3Id = DenseNodeTransactionTranslatorTest.id();
        final Id rel4Id = DenseNodeTransactionTranslatorTest.id();
        final Id typeA = DenseNodeTransactionTranslatorTest.id();
        final Id typeB = DenseNodeTransactionTranslatorTest.id();
        final Id typeC = DenseNodeTransactionTranslatorTest.id();
        final Id propId = DenseNodeTransactionTranslatorTest.id();
        NeoStore existingStore = this.existingStore(new ExistingContents(){

            @Override
            public void fill(NeoStore neoStore, TransactionDataBuilder transaction) {
                typeA.get((IdSequence)neoStore.getRelationshipTypeStore());
                typeB.get((IdSequence)neoStore.getRelationshipTypeStore());
                typeC.get((IdSequence)neoStore.getRelationshipTypeStore());
                denseNodeId.get((IdSequence)neoStore.getNodeStore());
                target1.get((IdSequence)neoStore.getNodeStore());
                target2.get((IdSequence)neoStore.getNodeStore());
                target3.get((IdSequence)neoStore.getNodeStore());
                target4.get((IdSequence)neoStore.getNodeStore());
                rel1Id.get((IdSequence)neoStore.getRelationshipStore());
                rel2Id.get((IdSequence)neoStore.getRelationshipStore());
                rel3Id.get((IdSequence)neoStore.getRelationshipStore());
                rel4Id.get((IdSequence)neoStore.getRelationshipStore());
                propId.get((IdSequence)neoStore.getPropertyStore());
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(denseNodeId.get()).asInUse().withNextRel(rel1Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target1.get()).asInUse().withNextRel(rel1Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(rel2Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target3.get()).asInUse().withNextRel(rel3Id.get()));
                transaction.create((NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(rel4Id.get()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel1Id.get(), denseNodeId.get(), target1.get(), (int)typeA.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), rel2Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel2Id.get(), denseNodeId.get(), target2.get(), (int)typeA.get()).asInUse().withStartPointers(rel1Id.get(), rel3Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).asFirstInFirstChain(false).asFirstInSecondChain(true));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel3Id.get(), denseNodeId.get(), target3.get(), (int)typeB.get()).asInUse().withStartPointers(rel2Id.get(), rel4Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).asFirstInFirstChain(false).asFirstInSecondChain(true).withNextProperty(propId.get()));
                transaction.create((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel4Id.get(), denseNodeId.get(), target4.get(), (int)typeC.get()).asInUse().withStartPointers(rel3Id.get(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).asFirstInFirstChain(false).asFirstInSecondChain(true));
                transaction.create((PropertyRecord)DenseNodeTransactionTranslatorTest.property(propId.get()).asInUse().withRelId(rel3Id.get()));
            }
        });
        List<LogEntry> translated = this.translate(existingStore, this.transaction(new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(rel2Id.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(rel4Id.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel1Id.get(), denseNodeId.get(), target1.get(), (int)typeA.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), rel3Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel3Id.get(), denseNodeId.get(), target3.get(), (int)typeB.get()).asInUse().withStartPointers(rel1Id.get(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).withNextProperty(Record.NO_NEXT_PROPERTY.intValue()).asFirstInFirstChain(false).asFirstInSecondChain(true));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel2Id.get(), denseNodeId.get(), target2.get(), (int)typeA.get()));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel4Id.get(), denseNodeId.get(), target4.get(), (int)typeC.get()));
                transaction.delete((PropertyRecord)DenseNodeTransactionTranslatorTest.property(propId.get()).asInUse().withRelId(rel3Id.get()), (PropertyRecord)DenseNodeTransactionTranslatorTest.property(propId.get()).withRelId(rel3Id.get()));
            }
        }));
        this.assertTranslatedTransaction(translated, new TransactionContents(){

            @Override
            public void fill(TransactionDataBuilder transaction) {
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(rel2Id.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(target2.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(rel4Id.get()), (NodeRecord)DenseNodeTransactionTranslatorTest.node(target4.get()).asInUse().withNextRel(Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel1Id.get(), denseNodeId.get(), target1.get(), (int)typeA.get()).asInUse().withStartPointers(Record.NO_PREV_RELATIONSHIP.intValue(), rel3Id.get()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()));
                transaction.update((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel3Id.get(), denseNodeId.get(), target3.get(), (int)typeB.get()).asInUse().withStartPointers(rel1Id.get(), Record.NO_NEXT_RELATIONSHIP.intValue()).withEndPointers(Record.NO_PREV_RELATIONSHIP.intValue(), Record.NO_NEXT_RELATIONSHIP.intValue()).withNextProperty(Record.NO_NEXT_PROPERTY.intValue()));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel2Id.get(), denseNodeId.get(), target2.get(), (int)typeA.get()));
                transaction.delete((RelationshipRecord)DenseNodeTransactionTranslatorTest.relationship(rel4Id.get(), denseNodeId.get(), target4.get(), (int)typeC.get()));
                transaction.delete((PropertyRecord)DenseNodeTransactionTranslatorTest.property(propId.get()).asInUse().withRelId(rel3Id.get()), (PropertyRecord)DenseNodeTransactionTranslatorTest.property(propId.get()).withRelId(rel3Id.get()));
            }
        });
    }

    private List<LogEntry> transaction(TransactionContents contents) throws IOException {
        LinkedList<LogEntry> entries = new LinkedList<LogEntry>();
        TransactionWriter writer = new TransactionWriter((TransactionWriter.Output)new TransactionWriter.CommandCollector(entries), 1, 1);
        TransactionDataBuilder builder = new TransactionDataBuilder(writer);
        writer.start(-1, 1, 1L);
        contents.fill(builder);
        writer.prepare();
        return entries;
    }

    private List<LogEntry> translate(NeoStore neoStore, List<LogEntry> transaction) {
        return new DenseNodeTransactionTranslator(neoStore).apply(transaction);
    }

    private NeoStore existingStore(ExistingContents contents) {
        StoreFactory storeFactory = new StoreFactory(new Config(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, (RemoteTxHook)new DefaultTxHook());
        File storeFile = new File("neostore");
        NeoStore neoStore = (NeoStore)this.cleanup.add((Object)storeFactory.createNeoStore(storeFile));
        TransactionWriter writer = new TransactionWriter((TransactionWriter.Output)new TransactionWriter.RecordOutput((CommandRecordVisitor)new TransactionWriter.NeoStoreCommandRecordVisitor(neoStore)), 0, 0);
        contents.fill(neoStore, new TransactionDataBuilder(writer));
        neoStore.updateIdGenerators();
        return neoStore;
    }

    private void assertTranslatedTransaction(List<LogEntry> translated, TransactionContents transactionContents) {
        LogEntryVerifyingOutput verifier = new LogEntryVerifyingOutput(translated);
        TransactionWriter writer = new TransactionWriter((TransactionWriter.Output)verifier, 0, 0);
        transactionContents.fill(new TransactionDataBuilder(writer));
        verifier.done();
    }

    private static Id id() {
        return new Id();
    }

    private static NodeRecordWithBenefits node(long id) {
        return new NodeRecordWithBenefits(id, false, -1L, -1L);
    }

    private static Command.SchemaRuleCommand schemaRule(Collection<DynamicRecord> recordsBefore, Collection<DynamicRecord> recordsAfter, SchemaRule schema) {
        Command.SchemaRuleCommand schemaRuleCommand = new Command.SchemaRuleCommand();
        schemaRuleCommand.init(recordsBefore, recordsAfter, schema, 100L);
        return schemaRuleCommand;
    }

    private static PropertyKeyTokenRecordWithBenefits propertyKeyToken(int id) {
        return new PropertyKeyTokenRecordWithBenefits(id);
    }

    private static NeoStoreRecordWithBenefits neoStore() {
        return new NeoStoreRecordWithBenefits();
    }

    private static RelationshipRecordWithBenefits relationship(long id, long startNode, long endNode, int type) {
        return new RelationshipRecordWithBenefits(id, startNode, endNode, type);
    }

    private static PropertyRecordWithBenefits property(long id) {
        return new PropertyRecordWithBenefits(id);
    }

    private static RelationshipGroupRecordWithBenefits group(long id, int type) {
        return new RelationshipGroupRecordWithBenefits(id, type);
    }

    private static class NeoStoreRecordWithBenefits
    extends NeoStoreRecord {
        private NeoStoreRecordWithBenefits() {
        }
    }

    private static class PropertyKeyTokenRecordWithBenefits
    extends PropertyKeyTokenRecord {
        public PropertyKeyTokenRecordWithBenefits(int id) {
            super(id);
        }
    }

    private static class RelationshipGroupRecordWithBenefits
    extends RelationshipGroupRecord {
        public RelationshipGroupRecordWithBenefits(long id, int type) {
            super(id, type);
        }

        public RelationshipGroupRecordWithBenefits asInUse() {
            this.setInUse(true);
            return this;
        }

        public RelationshipGroupRecordWithBenefits withNextGroup(long id) {
            this.setNext(id);
            return this;
        }

        public RelationshipGroupRecordWithBenefits withFirstOut(long id) {
            this.setFirstOut(id);
            return this;
        }

        public RelationshipGroupRecordWithBenefits withFirstIn(long id) {
            this.setFirstIn(id);
            return this;
        }

        public RelationshipGroupRecordWithBenefits withFirstLoop(long id) {
            this.setFirstLoop(id);
            return this;
        }
    }

    private static class PropertyRecordWithBenefits
    extends PropertyRecord {
        public PropertyRecordWithBenefits(long id) {
            super(id);
        }

        public PropertyRecordWithBenefits withNodeId(long id) {
            this.setNodeId(id);
            return this;
        }

        public PropertyRecordWithBenefits withRelId(long id) {
            this.setRelId(id);
            return this;
        }

        public PropertyRecordWithBenefits asInUse() {
            this.setInUse(true);
            return this;
        }
    }

    private static class RelationshipRecordWithBenefits
    extends RelationshipRecord {
        public RelationshipRecordWithBenefits(long id, long firstNode, long secondNode, int type) {
            super(id, firstNode, secondNode, type);
            this.setInUse(false);
        }

        public RelationshipRecordWithBenefits withEndPointers(long prev, long next) {
            this.setSecondPrevRel(prev);
            this.setSecondNextRel(next);
            return this;
        }

        public RelationshipRecordWithBenefits withStartPointers(long prev, long next) {
            this.setFirstPrevRel(prev);
            this.setFirstNextRel(next);
            return this;
        }

        public RelationshipRecordWithBenefits withNextProperty(long property) {
            this.setNextProp(property);
            return this;
        }

        public RelationshipRecordWithBenefits asInUse() {
            this.setInUse(true);
            return this;
        }

        public RelationshipRecordWithBenefits asFirstInFirstChain(boolean firstInFirstChain) {
            this.setFirstInFirstChain(firstInFirstChain);
            return this;
        }

        public RelationshipRecordWithBenefits asFirstInSecondChain(boolean firstInSecondChain) {
            this.setFirstInSecondChain(firstInSecondChain);
            return this;
        }
    }

    private static class NodeRecordWithBenefits
    extends NodeRecord {
        public NodeRecordWithBenefits(long id, boolean dense, long nextRel, long nextProp) {
            super(id, dense, nextRel, nextProp);
        }

        public NodeRecordWithBenefits asInUse() {
            this.setInUse(true);
            return this;
        }

        public NodeRecordWithBenefits asDense() {
            this.setDense(true);
            return this;
        }

        public NodeRecordWithBenefits withNextRel(long id) {
            this.setNextRel(id);
            return this;
        }

        public NodeRecordWithBenefits withNextProperty(long id) {
            this.setNextProp(id);
            return this;
        }

        public NodeRecordWithBenefits withLabelField(long labels, Collection<DynamicRecord> labelRecords) {
            this.setLabelField(labels, labelRecords);
            return this;
        }
    }

    private static class Id {
        private long id;
        private boolean captured;

        private Id() {
        }

        public long get(IdSequence sequence) {
            if (this.captured) {
                throw new IllegalStateException("Already captured");
            }
            this.id = sequence.nextId();
            this.captured = true;
            return this.id;
        }

        public long get() {
            if (!this.captured) {
                throw new IllegalStateException("Not captured");
            }
            return this.id;
        }
    }

    private static interface TransactionContents {
        public void fill(TransactionDataBuilder var1);
    }

    private static interface ExistingContents {
        public void fill(NeoStore var1, TransactionDataBuilder var2);
    }
}

