/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock.forseti;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.ha.lock.forseti.ExclusiveLock;
import org.neo4j.kernel.ha.lock.forseti.ForsetiLockManager;
import org.neo4j.kernel.ha.lock.forseti.SharedLock;
import org.neo4j.kernel.impl.locking.AcquireLockTimeoutException;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.util.FlyweightPool;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;
import org.neo4j.kernel.impl.util.concurrent.WaitStrategy;

public class ForsetiClient
implements Locks.Client {
    private final int myId;
    private final ConcurrentMap[] lockMaps;
    private final WaitStrategy<AcquireLockTimeoutException>[] waitStrategies;
    private final FlyweightPool<ForsetiClient> clientPool;
    private final Map<Long, Integer>[] sharedLockCounts;
    private final Map<Long, Integer>[] exclusiveLockCounts;
    private final SimpleBitSet waitList = new SimpleBitSet(64);
    private final ExclusiveLock myExclusiveLock = new ExclusiveLock(this);

    public ForsetiClient(int id, ConcurrentMap[] lockMaps, WaitStrategy[] waitStrategies, FlyweightPool<ForsetiClient> clientPool) {
        this.myId = id;
        this.lockMaps = lockMaps;
        this.waitStrategies = waitStrategies;
        this.clientPool = clientPool;
        this.sharedLockCounts = new HashMap[lockMaps.length];
        this.exclusiveLockCounts = new HashMap[lockMaps.length];
        for (int i = 0; i < this.sharedLockCounts.length; ++i) {
            this.sharedLockCounts[i] = new HashMap<Long, Integer>();
            this.exclusiveLockCounts[i] = new HashMap<Long, Integer>();
        }
    }

    public void acquireShared(Locks.ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        ConcurrentMap lockMap = this.lockMaps[resourceType.typeId()];
        Map<Long, Integer> heldShareLocks = this.sharedLockCounts[resourceType.typeId()];
        Map<Long, Integer> heldExclusiveLocks = this.exclusiveLockCounts[resourceType.typeId()];
        for (long resourceId : resourceIds) {
            Integer heldCount = heldShareLocks.get(resourceId);
            if (heldCount != null) {
                heldShareLocks.put(resourceId, heldCount + 1);
                continue;
            }
            if (heldExclusiveLocks.containsKey(resourceId)) {
                heldShareLocks.put(resourceId, 1);
                continue;
            }
            int tries = 0;
            SharedLock mySharedLock = null;
            while (true) {
                ForsetiLockManager.Lock existingLock;
                if ((existingLock = (ForsetiLockManager.Lock)lockMap.get(resourceId)) == null) {
                    if (mySharedLock == null) {
                        mySharedLock = new SharedLock(this);
                    }
                    if (lockMap.putIfAbsent(resourceId, mySharedLock) != null) continue;
                    break;
                }
                if (existingLock instanceof SharedLock) {
                    if (((SharedLock)existingLock).acquire(this)) {
                        break;
                    }
                } else if (!(existingLock instanceof ExclusiveLock)) {
                    throw new UnsupportedOperationException("Unknown lock type: " + existingLock);
                }
                this.waitStrategies[resourceType.typeId()].apply((long)tries++);
                this.markAsWaitingFor(existingLock, resourceType, resourceId);
            }
            this.clearWaitList();
            heldShareLocks.put(resourceId, 1);
        }
    }

    public void acquireExclusive(Locks.ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        ConcurrentMap lockMap = this.lockMaps[resourceType.typeId()];
        Map<Long, Integer> heldLocks = this.exclusiveLockCounts[resourceType.typeId()];
        for (long resourceId : resourceIds) {
            SharedLock sharedLock;
            ForsetiLockManager.Lock existingLock;
            Integer heldCount = heldLocks.get(resourceId);
            if (heldCount != null) {
                heldLocks.put(resourceId, heldCount + 1);
                continue;
            }
            int tries = 0;
            while (!((existingLock = (ForsetiLockManager.Lock)lockMap.putIfAbsent(resourceId, this.myExclusiveLock)) == null || tries > 50 && existingLock instanceof SharedLock && this.tryUpgradeSharedToExclusive(resourceType, lockMap, resourceId, sharedLock = (SharedLock)existingLock))) {
                this.waitStrategies[resourceType.typeId()].apply((long)tries++);
                this.markAsWaitingFor(existingLock, resourceType, resourceId);
            }
            this.clearWaitList();
            heldLocks.put(resourceId, 1);
        }
    }

    public boolean tryExclusiveLock(Locks.ResourceType resourceType, long ... resourceIds) {
        ConcurrentMap lockMap = this.lockMaps[resourceType.typeId()];
        Map<Long, Integer> heldLocks = this.exclusiveLockCounts[resourceType.typeId()];
        for (long resourceId : resourceIds) {
            Integer heldCount = heldLocks.get(resourceId);
            if (heldCount != null) {
                heldLocks.put(resourceId, heldCount + 1);
                continue;
            }
            ForsetiLockManager.Lock lock = lockMap.putIfAbsent(resourceId, this.myExclusiveLock);
            if (lock != null) {
                SharedLock sharedLock;
                if (lock instanceof SharedLock && this.sharedLockCounts[resourceType.typeId()].containsKey(resourceId) && (sharedLock = (SharedLock)lock).tryAcquireUpdateLock(this)) {
                    if (sharedLock.numberOfHolders() == 1) {
                        lockMap.put(resourceId, this.myExclusiveLock);
                        return true;
                    }
                    sharedLock.releaseUpdateLock(this);
                    return false;
                }
                return false;
            }
            heldLocks.put(resourceId, 1);
        }
        return true;
    }

    public boolean trySharedLock(Locks.ResourceType resourceType, long ... resourceIds) {
        ConcurrentMap lockMap = this.lockMaps[resourceType.typeId()];
        Map<Long, Integer> heldShareLocks = this.sharedLockCounts[resourceType.typeId()];
        Map<Long, Integer> heldExclusiveLocks = this.exclusiveLockCounts[resourceType.typeId()];
        for (long resourceId : resourceIds) {
            block8: {
                ForsetiLockManager.Lock existingLock;
                Integer heldCount = heldShareLocks.get(resourceId);
                if (heldCount != null) {
                    heldShareLocks.put(resourceId, heldCount + 1);
                    continue;
                }
                if (heldExclusiveLocks.containsKey(resourceId)) {
                    heldShareLocks.put(resourceId, 1);
                    continue;
                }
                while ((existingLock = (ForsetiLockManager.Lock)lockMap.get(resourceId)) == null) {
                    if (lockMap.putIfAbsent(resourceId, new SharedLock(this)) != null) continue;
                    break block8;
                }
                if (existingLock instanceof SharedLock) {
                    if (!((SharedLock)existingLock).acquire(this)) {
                        return false;
                    }
                } else {
                    if (existingLock instanceof ExclusiveLock) {
                        return false;
                    }
                    throw new UnsupportedOperationException("Unknown lock type: " + existingLock);
                }
            }
            heldShareLocks.put(resourceId, 1);
        }
        return true;
    }

    public void releaseShared(Locks.ResourceType resourceType, long ... resourceIds) {
        for (long resourceId : resourceIds) {
            if (this.releaseLocalLock(resourceType, resourceId, this.sharedLockCounts[resourceType.typeId()]) || this.exclusiveLockCounts[resourceType.typeId()].containsKey(resourceId)) continue;
            this.releaseGlobalLock(this.lockMaps[resourceType.typeId()], resourceId);
        }
    }

    public void releaseExclusive(Locks.ResourceType resourceType, long ... resourceIds) {
        for (long resourceId : resourceIds) {
            if (this.releaseLocalLock(resourceType, resourceId, this.exclusiveLockCounts[resourceType.typeId()])) continue;
            if (this.sharedLockCounts[resourceType.typeId()].containsKey(resourceId)) {
                this.lockMaps[resourceType.typeId()].put(resourceId, new SharedLock(this));
                continue;
            }
            this.releaseGlobalLock(this.lockMaps[resourceType.typeId()], resourceId);
        }
    }

    public void releaseAllShared() {
        for (int i = 0; i < this.sharedLockCounts.length; ++i) {
            Map<Long, Integer> localLocks = this.sharedLockCounts[i];
            if (localLocks == null) continue;
            ConcurrentMap lockMap = this.lockMaps[i];
            for (Long resourceId : localLocks.keySet()) {
                if (this.exclusiveLockCounts[i].containsKey(resourceId)) continue;
                this.releaseGlobalLock(lockMap, resourceId);
            }
            localLocks.clear();
        }
    }

    public void releaseAllExclusive() {
        for (int i = 0; i < this.exclusiveLockCounts.length; ++i) {
            Map<Long, Integer> localLocks = this.exclusiveLockCounts[i];
            if (localLocks == null) continue;
            ConcurrentMap lockMap = this.lockMaps[i];
            for (Long resourceId : localLocks.keySet()) {
                if (this.sharedLockCounts[i].containsKey(resourceId)) {
                    lockMap.put(resourceId, new SharedLock(this));
                    continue;
                }
                this.releaseGlobalLock(lockMap, resourceId);
            }
            localLocks.clear();
        }
    }

    public void releaseAll() {
        this.releaseAll(this.exclusiveLockCounts);
        this.releaseAll(this.sharedLockCounts);
    }

    private void releaseAll(Map<Long, Integer>[] lockCounts) {
        for (int i = 0; i < lockCounts.length; ++i) {
            Map<Long, Integer> localLocks = lockCounts[i];
            if (localLocks == null) continue;
            ConcurrentMap lockMap = this.lockMaps[i];
            for (Long resourceId : localLocks.keySet()) {
                this.releaseGlobalLock(lockMap, resourceId);
            }
            localLocks.clear();
        }
    }

    public void close() {
        this.releaseAll();
        this.clientPool.release((Object)this);
    }

    public int waitListSize() {
        return this.waitList.size();
    }

    public void copyWaitListTo(SimpleBitSet other) {
        other.put(this.waitList);
    }

    public boolean isWaitingFor(int clientId) {
        return clientId != this.myId && this.waitList.contains(clientId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForsetiClient that = (ForsetiClient)o;
        return this.myId == that.myId;
    }

    public int hashCode() {
        return this.myId;
    }

    public String toString() {
        return String.format("ForsetiClient[%d]", this.myId);
    }

    private void releaseGlobalLock(ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId) {
        ForsetiLockManager.Lock lock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
        if (lock instanceof ExclusiveLock) {
            lockMap.remove(resourceId);
        } else if (lock instanceof SharedLock && ((SharedLock)lock).release(this)) {
            lockMap.remove(resourceId);
        }
    }

    private boolean releaseLocalLock(Locks.ResourceType type, long resourceId, Map<Long, Integer> localLocks) {
        Integer lockCount = localLocks.remove(resourceId);
        if (lockCount == null) {
            throw new IllegalStateException(this + " cannot release lock that it does not hold: " + type + "[" + resourceId + "].");
        }
        if (lockCount > 1) {
            localLocks.put(resourceId, lockCount - 1);
            return true;
        }
        return false;
    }

    private boolean tryUpgradeSharedToExclusive(Locks.ResourceType resourceType, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId, SharedLock sharedLock) throws AcquireLockTimeoutException {
        int tries = 0;
        if (!this.sharedLockCounts[resourceType.typeId()].containsKey(resourceId)) {
            if (!sharedLock.acquire(this)) {
                return false;
            }
            try {
                if (this.tryUpgradeToExclusiveWithShareLockHeld(resourceType, lockMap, resourceId, sharedLock, tries)) {
                    return true;
                }
                this.releaseGlobalLock(lockMap, resourceId);
                return false;
            }
            catch (Throwable e) {
                this.releaseGlobalLock(lockMap, resourceId);
                throw e;
            }
        }
        return this.tryUpgradeToExclusiveWithShareLockHeld(resourceType, lockMap, resourceId, sharedLock, tries);
    }

    private boolean tryUpgradeToExclusiveWithShareLockHeld(Locks.ResourceType resourceType, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId, SharedLock sharedLock, int tries) throws AcquireLockTimeoutException {
        if (sharedLock.tryAcquireUpdateLock(this)) {
            try {
                while (sharedLock.numberOfHolders() > 1) {
                    this.waitStrategies[resourceType.typeId()].apply((long)tries++);
                    this.markAsWaitingFor(sharedLock, resourceType, resourceId);
                }
                lockMap.put(resourceId, this.myExclusiveLock);
                return true;
            }
            catch (DeadlockDetectedException e) {
                sharedLock.releaseUpdateLock(this);
                throw e;
            }
            catch (Throwable e) {
                sharedLock.releaseUpdateLock(this);
                this.clearWaitList();
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private void clearWaitList() {
        this.waitList.clear();
        this.waitList.put(this.myId);
    }

    private void markAsWaitingFor(ForsetiLockManager.Lock lock, Locks.ResourceType type, long resourceId) {
        this.clearWaitList();
        lock.copyHolderWaitListsInto(this.waitList);
        if (lock.anyHolderIsWaitingFor(this.myId) && lock.holderWaitListSize() >= this.waitListSize()) {
            this.waitList.clear();
            throw new DeadlockDetectedException(this + " can't acquire " + lock + " on " + type + "(" + resourceId + "), because holders of that lock " + "are waiting for " + this + ".\n Wait list:" + lock.describeWaitList());
        }
    }

    public String describeWaitList() {
        StringBuilder sb = new StringBuilder(this + " waits for [");
        PrimitiveIntIterator iter = this.waitList.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public int id() {
        return this.myId;
    }
}

