/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class CommitPusher
extends LifecycleAdapter {
    private final Map<Integer, BlockingQueue<PullUpdateFuture>> pullUpdateQueues = new HashMap<Integer, BlockingQueue<PullUpdateFuture>>();
    private final JobScheduler scheduler;

    public CommitPusher(JobScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void queuePush(XaDataSource dataSource, Slave slave, long txId) {
        PullUpdateFuture pullRequest = new PullUpdateFuture(slave, txId);
        BlockingQueue<PullUpdateFuture> queue = this.pullUpdateQueues.get(slave.getServerId());
        BlockingQueue<PullUpdateFuture> blockingQueue = queue = queue == null ? this.createNewQueue(dataSource, slave) : queue;
        while (!queue.offer(pullRequest)) {
            Thread.yield();
        }
        try {
            pullRequest.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private synchronized BlockingQueue<PullUpdateFuture> createNewQueue(final XaDataSource dataSource, Slave slave) {
        BlockingQueue<PullUpdateFuture> queue = this.pullUpdateQueues.get(slave.getServerId());
        if (queue == null) {
            queue = new ArrayBlockingQueue<PullUpdateFuture>(100);
            this.pullUpdateQueues.put(slave.getServerId(), queue);
            final BlockingQueue<PullUpdateFuture> finalQueue = queue;
            this.scheduler.schedule(JobScheduler.Group.masterTransactionPushing, new Runnable(){
                List<PullUpdateFuture> currentPulls = new ArrayList<PullUpdateFuture>();

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    try {
                        block4: while (true) {
                            this.currentPulls.clear();
                            this.currentPulls.add((PullUpdateFuture)finalQueue.take());
                            finalQueue.drainTo(this.currentPulls);
                            try {
                                pullUpdateFuture = this.currentPulls.get(0);
                                response = pullUpdateFuture.getSlave().pullUpdates(dataSource.getName(), PullUpdateFuture.access$000(pullUpdateFuture));
                                response.close();
                                i$ = this.currentPulls.iterator();
                                while (true) {
                                    if (!i$.hasNext()) continue block4;
                                    currentPull = i$.next();
                                    currentPull.done();
                                }
                            }
                            catch (Exception e) {
                                i$ = this.currentPulls.iterator();
                                while (true) {
                                    if (i$.hasNext()) ** break;
                                    continue block4;
                                    currentPull = i$.next();
                                    currentPull.setException(e);
                                }
                            }
                            break;
                        }
                    }
                    catch (InterruptedException var1_3) {
                        return;
                    }
                }
            });
        }
        return queue;
    }

    private static class PullUpdateFuture
    extends FutureTask<Object> {
        private Slave slave;
        private long txId;

        public PullUpdateFuture(Slave slave, long txId) {
            super(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return null;
                }
            });
            this.slave = slave;
            this.txId = txId;
        }

        @Override
        public void done() {
            super.set(null);
            super.done();
        }

        @Override
        public void setException(Throwable t) {
            super.setException(t);
        }

        public Slave getSlave() {
            return this.slave;
        }

        private long getTxId() {
            return this.txId;
        }

        static /* synthetic */ long access$000(PullUpdateFuture x0) {
            return x0.getTxId();
        }
    }
}

