/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.impl.locking.AcquireLockTimeoutException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.xa.PropertyDeleter;
import org.neo4j.kernel.impl.nioneo.xa.PropertyTraverser;
import org.neo4j.kernel.impl.nioneo.xa.RecordAccessSet;
import org.neo4j.kernel.impl.nioneo.xa.RecordChangeSet;
import org.neo4j.kernel.impl.nioneo.xa.RecordChanges;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipCreator;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipDeleter;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipGroupGetter;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipLocker;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.nioneo.xa.command.NeoCommandVisitor;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public class DenseNodeTransactionTranslator
implements Function<List<LogEntry>, List<LogEntry>> {
    private final NeoStore neoStore;
    private RecordChangeSet recordChangeSet;
    private final List<LogEntry.Command> commands = new LinkedList<LogEntry.Command>();
    private final RelationshipGroupGetter groupGetter;
    private final RelationshipCreator relationshipCreator;
    private final RelationshipDeleter deleter;
    private TranslatingNeoCommandVisitor commandVisitor = new TranslatingNeoCommandVisitor();

    public DenseNodeTransactionTranslator(NeoStore neoStore) {
        this.neoStore = neoStore;
        this.groupGetter = new RelationshipGroupGetter(neoStore.getRelationshipGroupStore());
        this.relationshipCreator = new RelationshipCreator(new RelationshipLocker(){

            public void getWriteLock(long relId) throws AcquireLockTimeoutException {
            }
        }, this.groupGetter, 1);
        this.deleter = new RelationshipDeleter(new RelationshipLocker(){

            public void getWriteLock(long relId) throws AcquireLockTimeoutException {
            }
        }, this.groupGetter, new PropertyDeleter(neoStore.getPropertyStore(), new PropertyTraverser()));
    }

    public synchronized List<LogEntry> apply(List<LogEntry> from) {
        this.recordChangeSet = new RecordChangeSet(this.neoStore);
        this.commands.clear();
        ArrayList<LogEntry> result = new ArrayList<LogEntry>(from.size());
        LogEntry commit = null;
        LogEntry prepare = null;
        LogEntry done = null;
        block9: for (LogEntry logEntry : from) {
            if (logEntry.getVersion() == -1) {
                throw new RuntimeException("crap");
            }
            switch (logEntry.getType()) {
                case 1: {
                    result.add(logEntry);
                    break;
                }
                case 5: 
                case 6: {
                    commit = logEntry;
                    break;
                }
                case 2: {
                    prepare = logEntry;
                    break;
                }
                case 4: {
                    done = logEntry;
                    break;
                }
                case 3: {
                    try {
                        if (this.handleCommand((LogEntry.Command)logEntry)) continue block9;
                        this.commands.add((LogEntry.Command)logEntry);
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    throw new IllegalStateException("Log Entry type " + logEntry.getType() + " is not recognizable");
                }
            }
        }
        this.translateRecordChangeSetToEntries(result, this.commands);
        if (commit != null) {
            result.add(commit);
        }
        if (prepare != null) {
            result.add(prepare);
        }
        if (done != null) {
            result.add(done);
        }
        return result;
    }

    private void translateRecordChangeSetToEntries(List<LogEntry> result, List<LogEntry.Command> commands) {
        Command.NodeCommand newCommand;
        for (RecordChanges.RecordChange nodeChange : this.recordChangeSet.getNodeRecords().changes()) {
            newCommand = new Command.NodeCommand();
            newCommand.init((NodeRecord)nodeChange.getBefore(), (NodeRecord)nodeChange.forChangingData());
            result.add((LogEntry)new LogEntry.Command(result.get(0).getIdentifier(), (XaCommand)newCommand));
        }
        for (RecordChanges.RecordChange relChange : this.recordChangeSet.getRelRecords().changes()) {
            newCommand = new Command.RelationshipCommand();
            newCommand.init((RelationshipRecord)relChange.forChangingData());
            result.add((LogEntry)new LogEntry.Command(result.get(0).getIdentifier(), (XaCommand)newCommand));
        }
        for (RecordChanges.RecordChange relGroupChange : this.recordChangeSet.getRelGroupRecords().changes()) {
            newCommand = new Command.RelationshipGroupCommand();
            newCommand.init((RelationshipGroupRecord)relGroupChange.forChangingData());
            result.add((LogEntry)new LogEntry.Command(result.get(0).getIdentifier(), (XaCommand)newCommand));
        }
        for (RecordChanges.RecordChange propChange : this.recordChangeSet.getPropertyRecords().changes()) {
            newCommand = new Command.PropertyCommand();
            newCommand.init((PropertyRecord)propChange.getBefore(), (PropertyRecord)propChange.forChangingData());
            result.add((LogEntry)new LogEntry.Command(result.get(0).getIdentifier(), (XaCommand)newCommand));
        }
        for (LogEntry.Command commandEntry : commands) {
            long id;
            Command command = (Command)commandEntry.getXaCommand();
            if (command instanceof Command.RelationshipCommand) {
                id = ((Command.RelationshipCommand)command).getRecord().getId();
                if (this.recordChangeSet.getRelRecords().getIfLoaded((Object)id) != null) continue;
                result.add((LogEntry)commandEntry);
                continue;
            }
            if (command instanceof Command.NodeCommand) {
                id = ((Command.NodeCommand)command).getAfter().getId();
                if (this.recordChangeSet.getNodeRecords().getIfLoaded((Object)id) != null) continue;
                result.add((LogEntry)commandEntry);
                continue;
            }
            result.add((LogEntry)commandEntry);
        }
    }

    private boolean handleCommand(LogEntry.Command commandEntry) throws IOException {
        Command command = (Command)commandEntry.getXaCommand();
        return command.accept((NeoCommandVisitor)this.commandVisitor);
    }

    private class TranslatingNeoCommandVisitor
    implements NeoCommandVisitor {
        private TranslatingNeoCommandVisitor() {
        }

        public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
            NodeRecord after = command.getAfter();
            NodeRecord before = DenseNodeTransactionTranslator.this.neoStore.getNodeStore().loadLightNode(after.getId());
            if (after.inUse() && (before == null || !before.inUse())) {
                this.translateNodeCreation(command);
            } else if (!after.inUse() && before.inUse()) {
                this.translateNodeDeletion(command);
            } else {
                if (after.getNextProp() != before.getNextProp()) {
                    this.translateNodePropertyChange(command);
                }
                if (after.getLabelField() != before.getLabelField()) {
                    this.translateNodeLabelChange(command);
                }
            }
            return true;
        }

        private void translateNodeDeletion(Command.NodeCommand command) {
            ((NodeRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getNodeRecords().getOrLoad((Object)command.getKey(), null).forChangingData()).setInUse(false);
        }

        private void translateNodeLabelChange(Command.NodeCommand command) {
            ((NodeRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getNodeRecords().getOrLoad((Object)command.getKey(), null).forChangingData()).setLabelField(command.getAfter().getLabelField(), command.getAfter().getDynamicLabelRecords());
        }

        private void translateNodePropertyChange(Command.NodeCommand command) {
            ((NodeRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getNodeRecords().getOrLoad((Object)command.getKey(), null).forChangingData()).setNextProp(command.getAfter().getNextProp());
        }

        private void translateNodeCreation(Command.NodeCommand command) {
            NodeRecord created = (NodeRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getNodeRecords().create((Object)command.getKey(), null).forChangingData();
            created.copyFrom(command.getAfter());
            created.setNextRel((long)Record.NO_NEXT_RELATIONSHIP.intValue());
            created.setInUse(true);
        }

        public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
            RelationshipRecord after = command.getRecord();
            RelationshipRecord before = DenseNodeTransactionTranslator.this.neoStore.getRelationshipStore().getLightRel(after.getId());
            if (after.inUse() && (before == null || !before.inUse())) {
                this.translateRelationshipCreation(command);
            } else if (!after.inUse() && before.inUse()) {
                this.translateRelationshipDeletion(command);
            } else if (after.getNextProp() != before.getNextProp()) {
                this.translateRelationshipPropertyChange(command);
            }
            return true;
        }

        private void translateRelationshipPropertyChange(Command.RelationshipCommand command) {
            ((RelationshipRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getRelRecords().getOrLoad((Object)command.getKey(), null).forChangingData()).setNextProp(command.getRecord().getNextProp());
        }

        public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
            PrimitiveRecord additionalData = command.getAfter().isNodeSet() ? (PrimitiveRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getNodeRecords().getOrLoad((Object)command.getAfter().getNodeId(), null).forReadingLinkage() : (PrimitiveRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getRelRecords().getOrLoad((Object)command.getAfter().getRelId(), null).forReadingLinkage();
            DenseNodeTransactionTranslator.this.recordChangeSet.getPropertyRecords().setTo((Object)command.getKey(), (Object)command.getAfter(), (Object)additionalData);
            return true;
        }

        public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) {
            return false;
        }

        public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) {
            return false;
        }

        public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
            return false;
        }

        public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) {
            return false;
        }

        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
            return false;
        }

        public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) {
            return false;
        }

        private void translateRelationshipCreation(Command.RelationshipCommand command) {
            RelationshipRecord record = command.getRecord();
            DenseNodeTransactionTranslator.this.relationshipCreator.relationshipCreate(record.getId(), record.getType(), record.getFirstNode(), record.getSecondNode(), (RecordAccessSet)DenseNodeTransactionTranslator.this.recordChangeSet);
            ((RelationshipRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getRelRecords().getOrLoad((Object)command.getKey(), null).forChangingData()).setNextProp(command.getRecord().getNextProp());
        }

        private void translateRelationshipDeletion(Command.RelationshipCommand command) {
            RelationshipRecord record = command.getRecord();
            DenseNodeTransactionTranslator.this.deleter.relDelete(record.getId(), (RecordAccessSet)DenseNodeTransactionTranslator.this.recordChangeSet);
        }
    }
}

