/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class HaKernelPanicHandler
implements KernelEventHandler,
AvailabilityGuard.AvailabilityRequirement {
    private final XaDataSourceManager dataSourceManager;
    private final TxManager txManager;
    private final AtomicInteger epoch = new AtomicInteger();
    private final AvailabilityGuard availabilityGuard;
    private final DelegateInvocationHandler<Master> masterDelegateInvocationHandler;
    private final StringLogger logger;

    public HaKernelPanicHandler(XaDataSourceManager dataSourceManager, TxManager txManager, AvailabilityGuard availabilityGuard, Logging logging, DelegateInvocationHandler<Master> masterDelegateInvocationHandler) {
        this.dataSourceManager = dataSourceManager;
        this.txManager = txManager;
        this.availabilityGuard = availabilityGuard;
        this.logger = logging.getMessagesLog(this.getClass());
        this.masterDelegateInvocationHandler = masterDelegateInvocationHandler;
        availabilityGuard.grant((AvailabilityGuard.AvailabilityRequirement)this);
    }

    public void beforeShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kernelPanic(ErrorState error) {
        block12: {
            if (error == ErrorState.TX_MANAGER_NOT_OK) {
                try {
                    int myEpoch = this.epoch.get();
                    XaDataSourceManager xaDataSourceManager = this.dataSourceManager;
                    synchronized (xaDataSourceManager) {
                        if (myEpoch != this.epoch.get()) {
                            return;
                        }
                        this.logger.info("Recovering from HA kernel panic");
                        this.epoch.incrementAndGet();
                        this.availabilityGuard.deny((AvailabilityGuard.AvailabilityRequirement)this);
                        try {
                            this.txManager.stop();
                            this.dataSourceManager.stop();
                            this.dataSourceManager.start();
                            this.txManager.start();
                            this.txManager.doRecovery();
                            this.masterDelegateInvocationHandler.harden();
                        }
                        finally {
                            this.availabilityGuard.grant((AvailabilityGuard.AvailabilityRequirement)this);
                            this.logger.info("Done recovering from HA kernel panic");
                        }
                        break block12;
                    }
                }
                catch (Throwable t) {
                    String msg = "Error while handling HA kernel panic";
                    this.logger.warn(msg, t);
                    throw new RuntimeException(msg, t);
                }
            }
            if (error == ErrorState.STORAGE_MEDIA_FULL) {
                this.availabilityGuard.shutdown();
            }
        }
    }

    public Object getResource() {
        return null;
    }

    public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
        return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
    }

    public String description() {
        return this.getClass().getSimpleName();
    }
}

