/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.Uris;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.impl.nioneo.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class HighAvailabilityModeSwitcher
implements HighAvailabilityMemberListener,
BindingListener,
Lifecycle {
    public static final String MASTER = "master";
    public static final String SLAVE = "slave";
    public static final String INADDR_ANY = "0.0.0.0";
    private volatile URI masterHaURI;
    private volatile URI slaveHaURI;
    private URI availableMasterId;
    private final SwitchToSlave switchToSlave;
    private final SwitchToMaster switchToMaster;
    private final Election election;
    private final ClusterMemberAvailability clusterMemberAvailability;
    private final StringLogger msgLog;
    private LifeSupport haCommunicationLife;
    private ScheduledExecutorService modeSwitcherExecutor;
    private volatile URI me;
    private volatile Future<?> modeSwitcherFuture;
    private volatile HighAvailabilityMemberState currentTargetState;

    public static InstanceId getServerId(URI haUri) {
        return (InstanceId)ClusterSettings.INSTANCE_ID.apply(Functions.withDefaults((Function)Functions.constant((Object)"-1"), (Function)Uris.parameter((String)"serverId")).apply((Object)haUri));
    }

    public HighAvailabilityModeSwitcher(SwitchToSlave switchToSlave, SwitchToMaster switchToMaster, Election election, ClusterMemberAvailability clusterMemberAvailability, StringLogger msgLog) {
        this.switchToSlave = switchToSlave;
        this.switchToMaster = switchToMaster;
        this.election = election;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.msgLog = msgLog;
        this.haCommunicationLife = new LifeSupport();
    }

    public void listeningAt(URI myUri) {
        this.me = myUri;
    }

    public synchronized void init() throws Throwable {
        this.modeSwitcherExecutor = Executors.newSingleThreadScheduledExecutor(NamedThreadFactory.named((String)"HA Mode switcher"));
        this.haCommunicationLife.init();
    }

    public synchronized void start() throws Throwable {
        this.haCommunicationLife.start();
    }

    public synchronized void stop() throws Throwable {
        this.haCommunicationLife.stop();
    }

    public synchronized void shutdown() throws Throwable {
        this.modeSwitcherExecutor.shutdown();
        this.modeSwitcherExecutor.awaitTermination(60L, TimeUnit.SECONDS);
        this.haCommunicationLife.shutdown();
    }

    @Override
    public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
        if (event.getNewState() == event.getOldState() && event.getOldState() == HighAvailabilityMemberState.MASTER) {
            this.clusterMemberAvailability.memberIsAvailable(MASTER, this.masterHaURI);
        } else {
            this.stateChanged(event);
        }
    }

    @Override
    public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
        if (event.getNewState() == event.getOldState() && event.getOldState() == HighAvailabilityMemberState.SLAVE) {
            this.clusterMemberAvailability.memberIsAvailable(SLAVE, this.slaveHaURI);
        } else {
            this.stateChanged(event);
        }
    }

    @Override
    public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
    }

    @Override
    public void instanceStops(HighAvailabilityMemberChangeEvent event) {
        this.stateChanged(event);
    }

    private void stateChanged(HighAvailabilityMemberChangeEvent event) {
        this.availableMasterId = event.getServerHaUri();
        if (event.getNewState() == event.getOldState()) {
            return;
        }
        this.currentTargetState = event.getNewState();
        switch (event.getNewState()) {
            case TO_MASTER: {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.clusterMemberAvailability.memberIsUnavailable(SLAVE);
                }
                this.switchToMaster();
                break;
            }
            case TO_SLAVE: {
                this.switchToSlave();
                break;
            }
            case PENDING: {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.clusterMemberAvailability.memberIsUnavailable(SLAVE);
                } else if (event.getOldState().equals((Object)HighAvailabilityMemberState.MASTER)) {
                    this.clusterMemberAvailability.memberIsUnavailable(MASTER);
                }
                this.startModeSwitching(new Runnable(){

                    @Override
                    public void run() {
                        HighAvailabilityModeSwitcher.this.haCommunicationLife.shutdown();
                        HighAvailabilityModeSwitcher.this.haCommunicationLife = new LifeSupport();
                    }
                });
                try {
                    this.modeSwitcherFuture.get(10L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    private void switchToMaster() {
        this.startModeSwitching(new Runnable(){

            @Override
            public void run() {
                if (HighAvailabilityModeSwitcher.this.currentTargetState != HighAvailabilityMemberState.TO_MASTER) {
                    return;
                }
                HighAvailabilityModeSwitcher.this.haCommunicationLife.shutdown();
                HighAvailabilityModeSwitcher.this.haCommunicationLife = new LifeSupport();
                try {
                    HighAvailabilityModeSwitcher.this.masterHaURI = HighAvailabilityModeSwitcher.this.switchToMaster.switchToMaster(HighAvailabilityModeSwitcher.this.haCommunicationLife, HighAvailabilityModeSwitcher.this.me);
                }
                catch (Throwable e) {
                    HighAvailabilityModeSwitcher.this.msgLog.logMessage("Failed to switch to master", e);
                    HighAvailabilityModeSwitcher.this.election.demote(HighAvailabilityModeSwitcher.getServerId(HighAvailabilityModeSwitcher.this.me));
                    return;
                }
            }
        });
    }

    private void switchToSlave() {
        final URI masterUri = this.availableMasterId;
        final AtomicLong wait = new AtomicLong();
        this.startModeSwitching(new Runnable(){

            @Override
            public void run() {
                if (HighAvailabilityModeSwitcher.this.currentTargetState != HighAvailabilityMemberState.TO_SLAVE) {
                    return;
                }
                try {
                    HighAvailabilityModeSwitcher.this.haCommunicationLife.shutdown();
                    HighAvailabilityModeSwitcher.this.haCommunicationLife = new LifeSupport();
                    HighAvailabilityModeSwitcher.this.slaveHaURI = HighAvailabilityModeSwitcher.this.switchToSlave.switchToSlave(HighAvailabilityModeSwitcher.this.haCommunicationLife, HighAvailabilityModeSwitcher.this.me, masterUri);
                }
                catch (MismatchingStoreIdException e) {
                    this.run();
                }
                catch (Throwable t) {
                    HighAvailabilityModeSwitcher.this.msgLog.logMessage("Error while trying to switch to slave", t);
                    wait.set(1L + wait.get() * 2L);
                    wait.set(Math.min(wait.get(), 300L));
                    HighAvailabilityModeSwitcher.this.modeSwitcherFuture = HighAvailabilityModeSwitcher.this.modeSwitcherExecutor.schedule(this, wait.get(), TimeUnit.SECONDS);
                    HighAvailabilityModeSwitcher.this.msgLog.logMessage("Attempting to switch to slave in " + wait.get() + "s");
                }
            }
        });
    }

    private void startModeSwitching(Runnable switcher) {
        if (this.modeSwitcherFuture != null) {
            this.modeSwitcherFuture.cancel(false);
        }
        this.modeSwitcherFuture = this.modeSwitcherExecutor.submit(switcher);
    }
}

