/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.cluster.InstanceId;
import org.neo4j.helpers.collection.MapUtil;

public class ClusterMember {
    private final InstanceId memberId;
    private final Map<String, URI> roles;
    private final boolean alive;

    public ClusterMember(InstanceId memberId) {
        this(memberId, Collections.emptyMap(), true);
    }

    ClusterMember(InstanceId memberId, Map<String, URI> roles, boolean alive) {
        this.memberId = memberId;
        this.roles = roles;
        this.alive = alive;
    }

    public InstanceId getMemberId() {
        return this.memberId;
    }

    public int getInstanceId() {
        return this.getMemberId().toIntegerIndex();
    }

    public URI getHAUri() {
        URI haURI = this.roles.get("master");
        if (haURI == null) {
            haURI = this.roles.get("slave");
        }
        return haURI;
    }

    public String getHARole() {
        if (this.roles.containsKey("master")) {
            return "master";
        }
        if (this.roles.containsKey("slave")) {
            return "slave";
        }
        return "UNKNOWN";
    }

    public boolean hasRole(String role) {
        return this.roles.containsKey(role);
    }

    public URI getRoleURI(String role) {
        return this.roles.get(role);
    }

    public Iterable<String> getRoles() {
        return this.roles.keySet();
    }

    public Iterable<URI> getRoleURIs() {
        return this.roles.values();
    }

    public boolean isAlive() {
        return this.alive;
    }

    ClusterMember availableAs(String role, URI roleUri) {
        HashMap<String, URI> copy = new HashMap<String, URI>(this.roles);
        if (role.equals("master")) {
            copy.remove("slave");
        } else if (role.equals("slave")) {
            copy.remove("master");
        }
        copy.put(role, roleUri);
        return new ClusterMember(this.memberId, copy, this.alive);
    }

    ClusterMember unavailableAs(String role) {
        return new ClusterMember(this.memberId, MapUtil.copyAndRemove(this.roles, (Object)role), this.alive);
    }

    ClusterMember alive() {
        return new ClusterMember(this.memberId, this.roles, true);
    }

    ClusterMember failed() {
        return new ClusterMember(this.memberId, this.roles, false);
    }

    public String toString() {
        return String.format("cluster URI=%s, alive=%s, roles=%s", this.memberId.toString(), this.alive, this.roles.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterMember that = (ClusterMember)o;
        return this.memberId.equals((Object)that.memberId);
    }

    public int hashCode() {
        return this.memberId.hashCode();
    }
}

