/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.HighPerformanceCache;
import org.neo4j.kernel.impl.cache.HighPerformanceCacheSettings;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;

public class HighPerformanceCacheProvider
extends CacheProvider {
    public static final String NAME = "hpc";

    public HighPerformanceCacheProvider() {
        super(NAME, "High-Performance Cache");
    }

    public Cache<NodeImpl> newNodeCache(StringLogger logger, Config config, Monitors monitors) {
        Long rel;
        Long node = (Long)config.get(HighPerformanceCacheSettings.node_cache_size);
        if (node == null) {
            node = Runtime.getRuntime().maxMemory() / 4L;
        }
        if ((rel = (Long)config.get(HighPerformanceCacheSettings.relationship_cache_size)) == null) {
            rel = Runtime.getRuntime().maxMemory() / 4L;
        }
        this.checkMemToUse(logger, node, rel, Runtime.getRuntime().maxMemory());
        return new HighPerformanceCache<NodeImpl>(node, ((Float)config.get(HighPerformanceCacheSettings.node_cache_array_fraction)).floatValue(), (Long)config.get(HighPerformanceCacheSettings.log_interval), "NodeCache", logger, (HighPerformanceCache.Monitor)monitors.newMonitor(HighPerformanceCache.Monitor.class, new String[0]));
    }

    public Cache<RelationshipImpl> newRelationshipCache(StringLogger logger, Config config, Monitors monitors) {
        Long rel;
        Long node = (Long)config.get(HighPerformanceCacheSettings.node_cache_size);
        if (node == null) {
            node = Runtime.getRuntime().maxMemory() / 4L;
        }
        if ((rel = (Long)config.get(HighPerformanceCacheSettings.relationship_cache_size)) == null) {
            rel = Runtime.getRuntime().maxMemory() / 4L;
        }
        this.checkMemToUse(logger, node, rel, Runtime.getRuntime().maxMemory());
        return new HighPerformanceCache<RelationshipImpl>(rel, ((Float)config.get(HighPerformanceCacheSettings.relationship_cache_array_fraction)).floatValue(), (Long)config.get(HighPerformanceCacheSettings.log_interval), "RelationshipCache", logger, (HighPerformanceCache.Monitor)monitors.newMonitor(HighPerformanceCache.Monitor.class, new String[0]));
    }

    private void checkMemToUse(StringLogger logger, long node, long rel, long available) {
        long advicedMax = available / 2L;
        long total = 0L;
        node = Math.max(1L, node);
        total += node;
        if ((total += (rel = Math.max(1L, rel))) > available) {
            throw new IllegalArgumentException(String.format("Configured cache memory limits (node=%s, relationship=%s, total=%s) exceeds available heap space (%s)", node, rel, total, available));
        }
        if (total > advicedMax) {
            logger.logMessage(String.format("Configured cache memory limits(node=%s, relationship=%s, total=%s) exceeds recommended limit (%s)", node, rel, total, advicedMax));
        }
    }

    public Class getSettingsClass() {
        return HighPerformanceCacheSettings.class;
    }
}

