/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.correctness;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import org.neo4j.cluster.DelayedDirectExecutor;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.MultiPaxosServerFactory;
import org.neo4j.cluster.ProtocolServer;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageProcessor;
import org.neo4j.cluster.com.message.MessageSender;
import org.neo4j.cluster.com.message.MessageSource;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorInstanceStore;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AtomicBroadcastMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InMemoryAcceptorInstanceStore;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.AtomicBroadcastContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.MultiPaxosContext;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.ElectionMessage;
import org.neo4j.cluster.protocol.election.ElectionRole;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatMessage;
import org.neo4j.cluster.protocol.snapshot.SnapshotContext;
import org.neo4j.cluster.protocol.snapshot.SnapshotMessage;
import org.neo4j.cluster.statemachine.StateMachine;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.ha.correctness.ClusterAction;
import org.neo4j.ha.correctness.ProverTimeouts;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.HighAvailabilityMemberInfoProvider;
import org.neo4j.kernel.ha.cluster.DefaultElectionCredentialsProvider;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.impl.core.LastTxIdGetter;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

class ClusterInstance {
    private final Executor stateMachineExecutor;
    private final Logging logging;
    private final MultiPaxosServerFactory factory;
    private final ProtocolServer server;
    private final MultiPaxosContext ctx;
    private final InMemoryAcceptorInstanceStore acceptorInstanceStore;
    private final ProverTimeouts timeouts;
    private final ClusterInstanceInput input;
    private final ClusterInstanceOutput output;
    private final URI uri;
    public static final Executor DIRECT_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };
    private boolean online = true;

    public static ClusterInstance newClusterInstance(InstanceId id, URI uri, Monitors monitors, ClusterConfiguration configuration, Logging logging) {
        MultiPaxosServerFactory factory = new MultiPaxosServerFactory(monitors, configuration, logging);
        ClusterInstanceInput input = new ClusterInstanceInput();
        ClusterInstanceOutput output = new ClusterInstanceOutput(uri);
        ObjectStreamFactory objStreamFactory = new ObjectStreamFactory();
        ProverTimeouts timeouts = new ProverTimeouts(uri);
        InMemoryAcceptorInstanceStore acceptorInstances = new InMemoryAcceptorInstanceStore();
        DelayedDirectExecutor executor = new DelayedDirectExecutor();
        MultiPaxosContext context = new MultiPaxosContext(id, Iterables.iterable((Object[])new ElectionRole[]{new ElectionRole("coordinator")}), new ClusterConfiguration(configuration.getName(), logging.getMessagesLog(ClusterConfiguration.class), (Collection)configuration.getMemberURIs()), (Executor)executor, logging, (ObjectInputStreamFactory)objStreamFactory, (ObjectOutputStreamFactory)objStreamFactory, (AcceptorInstanceStore)acceptorInstances, (Timeouts)timeouts, (ElectionCredentialsProvider)new DefaultElectionCredentialsProvider(id, (LastTxIdGetter)new StateVerifierLastTxIdGetter(), (HighAvailabilityMemberInfoProvider)new MemberInfoProvider()));
        context.getClusterContext().setBoundAt(uri);
        SnapshotContext snapshotContext = new SnapshotContext(context.getClusterContext(), context.getLearnerContext());
        ProtocolServer ps = factory.newProtocolServer(id, (MessageSource)input, (MessageSender)output, DIRECT_EXECUTOR, new DelayedDirectExecutor(), (Timeouts)timeouts, context, snapshotContext);
        return new ClusterInstance(DIRECT_EXECUTOR, logging, factory, ps, context, acceptorInstances, timeouts, input, output, uri);
    }

    public ClusterInstance(Executor stateMachineExecutor, Logging logging, MultiPaxosServerFactory factory, ProtocolServer server, MultiPaxosContext ctx, InMemoryAcceptorInstanceStore acceptorInstanceStore, ProverTimeouts timeouts, ClusterInstanceInput input, ClusterInstanceOutput output, URI uri) {
        this.stateMachineExecutor = stateMachineExecutor;
        this.logging = logging;
        this.factory = factory;
        this.server = server;
        this.ctx = ctx;
        this.acceptorInstanceStore = acceptorInstanceStore;
        this.timeouts = timeouts;
        this.input = input;
        this.output = output;
        this.uri = uri;
    }

    public InstanceId id() {
        return this.server.getServerId();
    }

    public Iterable<Message<? extends MessageType>> process(Message<? extends MessageType> message) {
        if (this.online) {
            this.input.process(message);
            return this.output.messages();
        }
        return Iterables.empty();
    }

    public String toString() {
        return "[" + this.id() + ":" + Iterables.toString(this.stateMachineStates(), (String)",") + "]";
    }

    private Iterable<String> stateMachineStates() {
        return Iterables.map((Function)new Function<StateMachine, String>(){

            public String apply(StateMachine stateMachine) {
                return stateMachine.getState().toString();
            }
        }, (Iterable)this.server.getStateMachines().getStateMachines());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterInstance that = (ClusterInstance)o;
        if (!this.toString().equals(that.toString())) {
            return false;
        }
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private StateMachine snapshotStateMachine(Logging logging, MultiPaxosContext snapshotCtx, StateMachine stateMachine) {
        AtomicBroadcastContextImpl ctx;
        Class msgType = stateMachine.getMessageType();
        if (msgType == AtomicBroadcastMessage.class) {
            ctx = snapshotCtx.getAtomicBroadcastContext();
        } else if (msgType == AcceptorMessage.class) {
            ctx = snapshotCtx.getAcceptorContext();
        } else if (msgType == ProposerMessage.class) {
            ctx = snapshotCtx.getProposerContext();
        } else if (msgType == LearnerMessage.class) {
            ctx = snapshotCtx.getLearnerContext();
        } else if (msgType == HeartbeatMessage.class) {
            ctx = snapshotCtx.getHeartbeatContext();
        } else if (msgType == ElectionMessage.class) {
            ctx = snapshotCtx.getElectionContext();
        } else if (msgType == SnapshotMessage.class) {
            ctx = new SnapshotContext(snapshotCtx.getClusterContext(), snapshotCtx.getLearnerContext());
        } else if (msgType == ClusterMessage.class) {
            ctx = snapshotCtx.getClusterContext();
        } else {
            throw new IllegalArgumentException("I don't know how to snapshot this state machine: " + stateMachine);
        }
        return new StateMachine((Object)ctx, stateMachine.getMessageType(), stateMachine.getState(), logging);
    }

    public ClusterInstance newCopy() {
        ProverTimeouts timeoutsSnapshot = this.timeouts.snapshot();
        InMemoryAcceptorInstanceStore snapshotAcceptorInstances = this.acceptorInstanceStore.snapshot();
        ClusterInstanceOutput output = new ClusterInstanceOutput(this.uri);
        ClusterInstanceInput input = new ClusterInstanceInput();
        DelayedDirectExecutor executor = new DelayedDirectExecutor();
        ObjectStreamFactory objectStreamFactory = new ObjectStreamFactory();
        MultiPaxosContext snapshotCtx = this.ctx.snapshot(this.logging, (Timeouts)timeoutsSnapshot, (Executor)executor, (AcceptorInstanceStore)snapshotAcceptorInstances, (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory, (ElectionCredentialsProvider)new DefaultElectionCredentialsProvider(this.server.getServerId(), (LastTxIdGetter)new StateVerifierLastTxIdGetter(), (HighAvailabilityMemberInfoProvider)new MemberInfoProvider()));
        ArrayList<StateMachine> snapshotMachines = new ArrayList<StateMachine>();
        for (StateMachine stateMachine : this.server.getStateMachines().getStateMachines()) {
            snapshotMachines.add(this.snapshotStateMachine(this.logging, snapshotCtx, stateMachine));
        }
        ProtocolServer snapshotProtocolServer = this.factory.constructSupportingInfrastructureFor(this.server.getServerId(), (MessageSource)input, (MessageSender)output, executor, (Timeouts)timeoutsSnapshot, this.stateMachineExecutor, snapshotCtx, snapshotMachines.toArray(new StateMachine[snapshotMachines.size()]));
        return new ClusterInstance(this.stateMachineExecutor, this.logging, this.factory, snapshotProtocolServer, snapshotCtx, snapshotAcceptorInstances, timeoutsSnapshot, input, output, this.uri);
    }

    public URI uri() {
        return this.uri;
    }

    public boolean hasPendingTimeouts() {
        return this.timeouts.hasTimeouts();
    }

    public ClusterAction popTimeout() {
        return this.timeouts.pop();
    }

    public void crash() {
        this.timeouts.cancelAllTimeouts();
        this.online = false;
    }

    static class StateVerifierLastTxIdGetter
    implements LastTxIdGetter {
        StateVerifierLastTxIdGetter() {
        }

        public long getLastTxId() {
            return 0L;
        }
    }

    static class MemberInfoProvider
    implements HighAvailabilityMemberInfoProvider {
        MemberInfoProvider() {
        }

        public HighAvailabilityMemberState getHighAvailabilityMemberState() {
            throw new UnsupportedOperationException("TODO");
        }
    }

    private static class ClusterInstanceOutput
    implements MessageSender {
        private final List<Message<? extends MessageType>> messages = new ArrayList<Message<? extends MessageType>>();
        private final URI uri;

        public ClusterInstanceOutput(URI uri) {
            this.uri = uri;
        }

        public boolean process(Message<? extends MessageType> message) {
            this.messages.add((Message<? extends MessageType>)message.setHeader("from", this.uri.toASCIIString()));
            return true;
        }

        public void process(List<Message<? extends MessageType>> msgList) {
            for (Message<? extends MessageType> msg : msgList) {
                this.process(msg);
            }
        }

        public Iterable<Message<? extends MessageType>> messages() {
            return this.messages;
        }
    }

    private static class ClusterInstanceInput
    implements MessageSource,
    MessageProcessor {
        private final List<MessageProcessor> processors = new ArrayList<MessageProcessor>();

        private ClusterInstanceInput() {
        }

        public boolean process(Message<? extends MessageType> message) {
            for (MessageProcessor processor : this.processors) {
                if (processor.process(message)) continue;
                return false;
            }
            return true;
        }

        public void addMessageProcessor(MessageProcessor messageProcessor) {
            this.processors.add(messageProcessor);
        }
    }
}

