/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.com.Response;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.LocalDeadlockDetectedException;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.SlaveLockManager;
import org.neo4j.kernel.impl.locking.AcquireLockTimeoutException;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;

class SlaveLocksClient
implements Locks.Client {
    private final Master master;
    private final Locks.Client client;
    private final Locks localLockManager;
    private final RequestContextFactory requestContextFactory;
    private final HaXaDataSourceManager xaDsm;
    private final AbstractTransactionManager txManager;
    private final RemoteTxHook txHook;
    private final AvailabilityGuard availabilityGuard;
    private final SlaveLockManager.Configuration config;
    private final Map<Locks.ResourceType, Map<Long, AtomicInteger>> sharedLocks;
    private final Map<Locks.ResourceType, Map<Long, AtomicInteger>> exclusiveLocks;

    public SlaveLocksClient(Master master, Locks.Client local, Locks localLockManager, RequestContextFactory requestContextFactory, HaXaDataSourceManager xaDsm, AbstractTransactionManager txManager, RemoteTxHook txHook, AvailabilityGuard availabilityGuard, SlaveLockManager.Configuration config) {
        this.master = master;
        this.client = local;
        this.localLockManager = localLockManager;
        this.requestContextFactory = requestContextFactory;
        this.xaDsm = xaDsm;
        this.txManager = txManager;
        this.txHook = txHook;
        this.availabilityGuard = availabilityGuard;
        this.config = config;
        this.sharedLocks = new HashMap<Locks.ResourceType, Map<Long, AtomicInteger>>();
        this.exclusiveLocks = new HashMap<Locks.ResourceType, Map<Long, AtomicInteger>>();
    }

    private Map<Long, AtomicInteger> getLockMap(Map<Locks.ResourceType, Map<Long, AtomicInteger>> resourceMap, Locks.ResourceType resourceType) {
        Map<Long, AtomicInteger> lockMap = resourceMap.get(resourceType);
        if (lockMap == null) {
            lockMap = new HashMap<Long, AtomicInteger>();
            resourceMap.put(resourceType, lockMap);
        }
        return lockMap;
    }

    public void acquireShared(Locks.ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        Map<Long, AtomicInteger> lockMap = this.getLockMap(this.sharedLocks, resourceType);
        long[] untakenIds = this.incrementAndRemoveAlreadyTakenLocks(lockMap, resourceIds);
        if (untakenIds.length > 0 && this.getReadLockOnMaster(resourceType, untakenIds)) {
            if (this.client.trySharedLock(resourceType, untakenIds)) {
                for (int i = 0; i < untakenIds.length; ++i) {
                    lockMap.put(untakenIds[i], new AtomicInteger(1));
                }
            } else {
                throw new LocalDeadlockDetectedException(this.client, this.localLockManager, resourceType, resourceIds, LockType.READ);
            }
        }
    }

    public void acquireExclusive(Locks.ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        Map<Long, AtomicInteger> lockMap = this.getLockMap(this.exclusiveLocks, resourceType);
        long[] untakenIds = this.incrementAndRemoveAlreadyTakenLocks(lockMap, resourceIds);
        if (untakenIds.length > 0 && this.acquireExclusiveOnMaster(resourceType, untakenIds)) {
            if (this.client.tryExclusiveLock(resourceType, untakenIds)) {
                for (int i = 0; i < untakenIds.length; ++i) {
                    lockMap.put(untakenIds[i], new AtomicInteger(1));
                }
            } else {
                throw new LocalDeadlockDetectedException(this.client, this.localLockManager, resourceType, resourceIds, LockType.WRITE);
            }
        }
    }

    private long[] incrementAndRemoveAlreadyTakenLocks(Map<Long, AtomicInteger> takenLocks, long[] resourceIds) {
        ArrayList<Long> untakenIds = new ArrayList<Long>();
        for (int i = 0; i < resourceIds.length; ++i) {
            long id = resourceIds[i];
            AtomicInteger counter = takenLocks.get(id);
            if (counter != null) {
                counter.incrementAndGet();
                continue;
            }
            untakenIds.add(id);
        }
        long[] untaken = new long[untakenIds.size()];
        for (int i = 0; i < untaken.length; ++i) {
            long id;
            untaken[i] = id = ((Long)untakenIds.get(i)).longValue();
        }
        return untaken;
    }

    public boolean tryExclusiveLock(Locks.ResourceType resourceType, long ... resourceIds) {
        throw this.newUnsupportedDirectTryLockUsageException();
    }

    public boolean trySharedLock(Locks.ResourceType resourceType, long ... resourceIds) {
        throw this.newUnsupportedDirectTryLockUsageException();
    }

    public void releaseShared(Locks.ResourceType resourceType, long ... resourceIds) {
        Map<Long, AtomicInteger> lockMap = this.getLockMap(this.sharedLocks, resourceType);
        for (long resourceId : resourceIds) {
            AtomicInteger counter = lockMap.get(resourceId);
            if (counter == null) {
                throw new IllegalStateException(this + " cannot release lock it does not hold: EXCLUSIVE " + resourceType + "[" + resourceId + "]");
            }
            if (counter.decrementAndGet() != 0) continue;
            lockMap.remove(resourceId);
            this.client.releaseShared(resourceType, new long[]{resourceId});
        }
    }

    public void releaseExclusive(Locks.ResourceType resourceType, long ... resourceIds) {
        Map<Long, AtomicInteger> lockMap = this.getLockMap(this.exclusiveLocks, resourceType);
        for (long resourceId : resourceIds) {
            AtomicInteger counter = lockMap.get(resourceId);
            if (counter == null) {
                throw new IllegalStateException(this + " cannot release lock it does not hold: EXCLUSIVE " + resourceType + "[" + resourceId + "]");
            }
            if (counter.decrementAndGet() != 0) continue;
            lockMap.remove(resourceId);
            this.client.releaseExclusive(resourceType, new long[]{resourceId});
        }
    }

    public void releaseAllShared() {
        this.sharedLocks.clear();
        this.client.releaseAllShared();
    }

    public void releaseAllExclusive() {
        this.exclusiveLocks.clear();
        this.client.releaseAllExclusive();
    }

    public void releaseAll() {
        this.sharedLocks.clear();
        this.exclusiveLocks.clear();
        this.client.releaseAll();
    }

    public void close() {
        this.sharedLocks.clear();
        this.exclusiveLocks.clear();
        this.client.close();
    }

    private boolean getReadLockOnMaster(Locks.ResourceType resourceType, long ... resourceId) {
        if (resourceType == ResourceTypes.NODE || resourceType == ResourceTypes.RELATIONSHIP || resourceType == ResourceTypes.GRAPH_PROPS || resourceType == ResourceTypes.LEGACY_INDEX) {
            this.makeSureTxHasBeenInitialized();
            return this.receiveLockResponse(this.master.acquireSharedLock(this.requestContextFactory.newRequestContext(), resourceType, resourceId));
        }
        return true;
    }

    private boolean acquireExclusiveOnMaster(Locks.ResourceType resourceType, long ... resourceId) {
        this.makeSureTxHasBeenInitialized();
        return this.receiveLockResponse(this.master.acquireExclusiveLock(this.requestContextFactory.newRequestContext(), resourceType, resourceId));
    }

    private boolean receiveLockResponse(Response<LockResult> response) {
        LockResult result = this.xaDsm.applyTransactions(response);
        switch (result.getStatus()) {
            case DEAD_LOCKED: {
                throw new DeadlockDetectedException(result.getDeadlockMessage());
            }
            case NOT_LOCKED: {
                throw new UnsupportedOperationException();
            }
            case OK_LOCKED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(result.toString());
            }
        }
        return true;
    }

    private void makeSureTxHasBeenInitialized() {
        if (!this.availabilityGuard.isAvailable(this.config.getAvailabilityTimeout())) {
            throw new RuntimeException("Timed out waiting for database to allow operations to proceed. " + this.availabilityGuard.describeWhoIsBlocking());
        }
        this.txHook.remotelyInitializeTransaction(this.txManager.getEventIdentifier(), this.txManager.getTransactionState());
    }

    private UnsupportedOperationException newUnsupportedDirectTryLockUsageException() {
        return new UnsupportedOperationException("At the time of adding \"try lock\" semantics there was no usage of " + this.getClass().getSimpleName() + " calling it directly. It was designed to be called on a local " + LockManager.class.getSimpleName() + " delegated to from within the waiting version");
    }
}

