/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import javax.transaction.xa.XAException;
import org.neo4j.com.ComException;
import org.neo4j.com.Response;
import org.neo4j.com.TxExtractor;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class SlaveTxIdGenerator
implements TxIdGenerator {
    private final int serverId;
    private final Master master;
    private final int masterId;
    private final RequestContextFactory requestContextFactory;
    private final HaXaDataSourceManager xaDsm;
    private final AbstractTransactionManager txManager;

    public SlaveTxIdGenerator(int serverId, Master master, int masterId, RequestContextFactory requestContextFactory, HaXaDataSourceManager xaDsm, AbstractTransactionManager txManager) {
        this.serverId = serverId;
        this.masterId = masterId;
        this.requestContextFactory = requestContextFactory;
        this.master = master;
        this.xaDsm = xaDsm;
        this.txManager = txManager;
    }

    public long generate(XaDataSource dataSource, int identifier) throws XAException {
        try {
            TransactionState txState = this.txManager.getTransactionState();
            txState.getTxHook().remotelyInitializeTransaction(this.txManager.getEventIdentifier(), txState);
            Response<Long> response = this.master.commitSingleResourceTransaction(this.requestContextFactory.newRequestContext(dataSource), dataSource.getName(), this.myPreparedTransactionToCommit(dataSource, identifier));
            this.xaDsm.applyTransactions(response);
            return (Long)response.response();
        }
        catch (ComException e) {
            throw (XAException)Exceptions.withCause((Throwable)new XAException(7), (Throwable)e);
        }
        catch (RuntimeException e) {
            for (Throwable currentException = e.getCause(); currentException != null; currentException = currentException.getCause()) {
                if (!(currentException instanceof XAException)) continue;
                throw (XAException)Exceptions.withCause((Throwable)new XAException(((XAException)currentException).errorCode), (Throwable)e);
            }
            throw e;
        }
    }

    public void committed(XaDataSource dataSource, int identifier, long txId, Integer externalAuthorServerId) {
        this.master.pushTransaction(this.requestContextFactory.newRequestContext(identifier), dataSource.getName(), txId).close();
    }

    public int getCurrentMasterId() {
        return this.masterId;
    }

    public int getMyId() {
        return this.serverId;
    }

    private TxExtractor myPreparedTransactionToCommit(final XaDataSource dataSource, final int identifier) {
        return new TxExtractor(){

            public ReadableByteChannel extract() {
                throw new UnsupportedOperationException();
            }

            public void extract(LogBuffer buffer) {
                try {
                    dataSource.getPreparedTransaction(identifier, buffer);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

