/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.upgrade;

import java.io.File;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.backup.OnlineBackup;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.ha.upgrade.LegacyDatabase;
import org.neo4j.ha.upgrade.LegacyDatabaseImpl;
import org.neo4j.ha.upgrade.Utils;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.TargetDirectory;

public class RollingUpgradeIT {
    private static final String OLD_VERSION = "2.0.1";
    public static final RelationshipType type1 = DynamicRelationshipType.withName((String)"type1");
    public static final RelationshipType type2 = DynamicRelationshipType.withName((String)"type2");
    private final TargetDirectory DIR = TargetDirectory.forTest(this.getClass());
    private final File DBS_DIR = this.DIR.cleanDirectory("dbs");
    private LegacyDatabase[] legacyDbs;
    private GraphDatabaseAPI[] newDbs;
    private long centralNode;

    @Test
    public void doRollingUpgradeFromPreviousVersionWithMasterLast() throws Throwable {
        try {
            this.startOldVersionCluster();
            this.rollOverToNewVersion();
            this.shutdownAndDoConsistencyChecks();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void shutdownAndDoConsistencyChecks() throws ConsistencyCheckIncompleteException {
        ArrayList<String> storeDirs = new ArrayList<String>(this.newDbs.length);
        for (GraphDatabaseAPI item : this.newDbs) {
            storeDirs.add(item.getStoreDir());
            item.shutdown();
        }
        ConsistencyCheckService service = new ConsistencyCheckService();
        for (String storeDir : storeDirs) {
            service.runFullConsistencyCheck(storeDir, new Config(), ProgressMonitorFactory.textual((OutputStream)System.out), StringLogger.SYSTEM);
        }
    }

    private void debug(String message) {
        this.debug(message, true);
    }

    private void debug(String message, boolean enter) {
        String string = "RUT " + message;
        if (enter) {
            System.out.println(string);
        } else {
            System.out.print(string);
        }
    }

    @After
    public void cleanUp() throws Exception {
        if (this.legacyDbs != null) {
            for (int i = 0; i < this.legacyDbs.length; ++i) {
                this.stop(i);
            }
        }
        if (this.newDbs != null) {
            for (GraphDatabaseAPI db : this.newDbs) {
                db.shutdown();
            }
        }
    }

    private void startOldVersionCluster() throws Exception {
        int i;
        this.debug("Downloading 2.0.1 package");
        File oldVersionPackage = Utils.downloadAndUnpack("http://download.neo4j.org/artifact?edition=enterprise&version=2.0.1&distribution=zip", this.DIR.cacheDirectory("download"), "2.0.1-enterprise");
        String classpath = Utils.assembleClassPathFromPackage(oldVersionPackage);
        this.debug("Starting 2.0.1 cluster in separate jvms");
        Future[] legacyDbFutures = new Future[3];
        for (i = 0; i < legacyDbFutures.length; ++i) {
            legacyDbFutures[i] = LegacyDatabaseImpl.start(classpath, this.storeDir(i), this.config(i));
            this.debug("  Started " + i);
        }
        this.legacyDbs = new LegacyDatabase[legacyDbFutures.length];
        for (i = 0; i < legacyDbFutures.length; ++i) {
            this.legacyDbs[i] = (LegacyDatabase)legacyDbFutures[i].get();
        }
        for (LegacyDatabase db : this.legacyDbs) {
            this.debug("  Awaiting " + db.getStoreDir() + " to start");
            db.awaitStarted(10L, TimeUnit.SECONDS);
            this.debug("  " + db.getStoreDir() + " fully started");
        }
        for (int i2 = 0; i2 < this.legacyDbs.length; ++i2) {
            long node = this.legacyDbs[i2].createNode();
            for (LegacyDatabase db : this.legacyDbs) {
                db.verifyNodeExists(node);
            }
        }
        this.debug("2.0.1 cluster fully operational");
        this.centralNode = this.legacyDbs[0].initialize();
    }

    private File storeDir(int serverId) {
        return new File(this.DBS_DIR, "" + serverId);
    }

    private Map<String, String> config(int serverId) throws UnknownHostException {
        String localhost = this.localhost();
        Map result = MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "" + serverId, ClusterSettings.cluster_server.name(), localhost + ":" + (5000 + serverId), HaSettings.ha_server.name(), localhost + ":" + (6000 + serverId), GraphDatabaseSettings.allow_store_upgrade.name(), "true", OnlineBackupSettings.online_backup_server.name(), localhost + ":" + this.backupPort(serverId), ClusterSettings.initial_hosts.name(), localhost + ":" + 5000 + "," + localhost + ":" + 5001 + "," + localhost + ":" + 5002});
        return result;
    }

    private String localhost() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    private int backupPort(int serverId) {
        return 6362 + serverId;
    }

    private void rollOverToNewVersion() throws Exception {
        this.debug("Starting to roll over to current version");
        Pair<LegacyDatabase, Integer> master = this.findOutWhoIsMaster();
        this.newDbs = new GraphDatabaseAPI[this.legacyDbs.length];
        int authorativeSlaveId = -1;
        for (int i = 0; i < this.legacyDbs.length; ++i) {
            LegacyDatabase legacyDb = this.legacyDbs[i];
            if (legacyDb == master.first()) {
                System.out.println("master is " + ((LegacyDatabase)master.first()).getStoreDir());
                continue;
            }
            this.rollOver(legacyDb, i, (Integer)master.other(), authorativeSlaveId);
            if (authorativeSlaveId != -1) continue;
            authorativeSlaveId = i;
        }
        this.rollOver((LegacyDatabase)master.first(), (Integer)master.other(), (Integer)master.other(), -2);
    }

    private void rollOver(LegacyDatabase legacyDb, int i, int masterServerId, int authorativeSlaveId) throws Exception {
        int j;
        String storeDir = legacyDb.getStoreDir();
        if (i == 0) {
            storeDir = storeDir + "new";
        }
        this.stop(i);
        Thread.sleep(30000L);
        File storeDirFile = new File(storeDir);
        this.debug("Starting " + i + " as current version");
        switch (authorativeSlaveId) {
            case -1: {
                break;
            }
            case -2: {
                this.debug("At last master starting, deleteing store so that it fetches from the new master");
                FileUtils.deleteRecursively((File)storeDirFile);
                break;
            }
            default: {
                this.debug("Consecutive slave starting, making it so that I will copy store from " + authorativeSlaveId);
                FileUtils.deleteRecursively((File)storeDirFile);
                storeDirFile.mkdirs();
                this.backup(authorativeSlaveId, storeDirFile);
            }
        }
        this.newDbs[i] = (GraphDatabaseAPI)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(storeDir).setConfig(this.config(i)).newGraphDatabase();
        this.debug("Started " + i + " as current version");
        this.legacyDbs[i] = null;
        if (i != masterServerId) {
            this.legacyDbs[masterServerId].doComplexLoad(this.centralNode);
            this.debug("Node created on " + i);
        } else {
            this.doComplexLoad(this.newDbs[1], this.centralNode);
        }
        for (j = 0; j < this.legacyDbs.length; ++j) {
            if (this.legacyDbs[j] == null) continue;
            this.legacyDbs[j].verifyComplexLoad(this.centralNode);
            this.debug("Verified on legacy db " + j);
        }
        for (j = 0; j < this.newDbs.length; ++j) {
            if (this.newDbs[j] == null) continue;
            this.verifyComplexLoad(this.newDbs[j], this.centralNode);
            this.debug("Verified on new db " + j);
        }
    }

    private void backup(int sourceServerId, File targetDir) throws UnknownHostException {
        OnlineBackup backup = OnlineBackup.from((String)this.localhost(), (int)this.backupPort(sourceServerId)).backup(targetDir.getPath());
        Assert.assertTrue((String)"Something wrong with the backup", (boolean)backup.isConsistent());
    }

    public void doComplexLoad(GraphDatabaseAPI db, long center) {
        try (Transaction tx = db.beginTx();){
            int i;
            Node central = db.getNodeById(center);
            long type1RelCount = central.getDegree(type1);
            long type2RelCount = central.getDegree(type2);
            long[] type1RelId = new long[(int)type1RelCount];
            long[] type2RelId = new long[(int)type2RelCount];
            int index = 0;
            for (Relationship relationship : central.getRelationships(new RelationshipType[]{type1})) {
                type1RelId[index++] = relationship.getId();
            }
            index = 0;
            for (Relationship relationship : central.getRelationships(new RelationshipType[]{type2})) {
                type2RelId[index++] = relationship.getId();
            }
            Arrays.sort(type1RelId);
            Arrays.sort(type2RelId);
            for (i = 0; i < type1RelId.length / 2; ++i) {
                db.getRelationshipById(type1RelId[i]).delete();
            }
            for (i = 0; i < type2RelId.length / 2; ++i) {
                db.getRelationshipById(type2RelId[i]).delete();
            }
            for (i = 0; i < type1RelId.length / 2; ++i) {
                central.createRelationshipTo(db.createNode(), type1);
            }
            long largestCreated = 0L;
            for (int i2 = 0; i2 < type2RelId.length / 2; ++i2) {
                long current = central.createRelationshipTo(db.createNode(), type2).getId();
                if (current <= largestCreated) continue;
                largestCreated = current;
            }
            for (Relationship relationship : central.getRelationships()) {
                relationship.setProperty("relProp", (Object)("relProp" + relationship.getId() + "-" + largestCreated));
                Node end = relationship.getEndNode();
                end.setProperty("nodeProp", (Object)("nodeProp" + end.getId() + "-" + largestCreated));
            }
            tx.success();
        }
    }

    public void verifyComplexLoad(GraphDatabaseAPI db, long centralNode) {
        ((UpdatePuller)db.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
        try (Transaction tx = db.beginTx();){
            Node other;
            Node center = db.getNodeById(centralNode);
            long maxRelId = -1L;
            for (Relationship relationship : center.getRelationships()) {
                if (relationship.getId() <= maxRelId) continue;
                maxRelId = relationship.getId();
            }
            int typeCount = 0;
            for (Relationship relationship : center.getRelationships(new RelationshipType[]{type1})) {
                ++typeCount;
                if (!relationship.getProperty("relProp").equals("relProp" + relationship.getId() + "-" + maxRelId)) {
                    Assert.fail((String)"damn");
                }
                if ((other = relationship.getEndNode()).getProperty("nodeProp").equals("nodeProp" + other.getId() + "-" + maxRelId)) continue;
                Assert.fail((String)"double damn");
            }
            if (typeCount != 100) {
                Assert.fail((String)"tripled damn");
            }
            typeCount = 0;
            for (Relationship relationship : center.getRelationships(new RelationshipType[]{type2})) {
                ++typeCount;
                if (!relationship.getProperty("relProp").equals("relProp" + relationship.getId() + "-" + maxRelId)) {
                    Assert.fail((String)"damn");
                }
                if ((other = relationship.getEndNode()).getProperty("nodeProp").equals("nodeProp" + other.getId() + "-" + maxRelId)) continue;
                Assert.fail((String)"double damn");
            }
            if (typeCount != 100) {
                Assert.fail((String)"tripled damn");
            }
            tx.success();
        }
    }

    private Pair<LegacyDatabase, Integer> findOutWhoIsMaster() {
        try {
            for (int i = 0; i < this.legacyDbs.length; ++i) {
                LegacyDatabase db = this.legacyDbs[i];
                if (!db.isMaster()) continue;
                return Pair.of((Object)db, (Object)i);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("No master");
    }

    private void stop(int i) {
        try {
            LegacyDatabase legacyDb = this.legacyDbs[i];
            if (legacyDb != null) {
                legacyDb.stop();
                this.legacyDbs[i] = null;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

