/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class LabelIT {
    private final File storeDir = TargetDirectory.forTest(this.getClass()).makeGraphDbDir();
    private ClusterManager clusterManager;

    @Test
    public void creatingIndexOnMasterShouldHaveSlavesBuildItAsWell() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.startCluster(ClusterManager.clusterOfSize(3));
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(slave1);
        Label label = DynamicLabel.label((String)"Person");
        TransactionContinuation txOnSlave1 = this.createNodeAndKeepTxOpen(slave1, label);
        TransactionContinuation txOnSlave2 = this.createNodeAndKeepTxOpen(slave2, label);
        this.commit(slave1, txOnSlave1);
        this.commit(slave2, txOnSlave2);
        Assert.assertEquals((long)this.getLabelId(slave1, label), (long)this.getLabelId(slave2, label));
    }

    private long getLabelId(HighlyAvailableGraphDatabase db, Label label) throws LabelNotFoundKernelException {
        try (org.neo4j.graphdb.Transaction ignore = db.beginTx();){
            ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            long l = bridge.instance().readOperations().labelGetForName(label.name());
            return l;
        }
    }

    private void commit(HighlyAvailableGraphDatabase db, TransactionContinuation txc) throws Exception {
        txc.resume();
        txc.commit();
    }

    private TransactionContinuation createNodeAndKeepTxOpen(HighlyAvailableGraphDatabase db, Label label) throws SystemException {
        TransactionContinuation txc = new TransactionContinuation(db);
        txc.begin();
        db.createNode(new Label[]{label});
        txc.suspend();
        return txc;
    }

    private ClusterManager.ManagedCluster startCluster(ClusterManager.Provider provider) throws Throwable {
        return this.startCluster(provider, new HighlyAvailableGraphDatabaseFactory());
    }

    private ClusterManager.ManagedCluster startCluster(ClusterManager.Provider provider, HighlyAvailableGraphDatabaseFactory dbFactory) throws Throwable {
        this.clusterManager = new ClusterManager(provider, this.storeDir, MapUtil.stringMap((String[])new String[]{ClusterSettings.default_timeout.name(), "1s", HaSettings.tx_push_factor.name(), "0"}), new HashMap<Integer, Map<String, String>>(), dbFactory);
        this.clusterManager.start();
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        return cluster;
    }

    @After
    public void after() throws Throwable {
        if (this.clusterManager != null) {
            this.clusterManager.stop();
        }
    }

    private static class TransactionContinuation {
        private final HighlyAvailableGraphDatabase db;
        private final TransactionManager txManager;
        private org.neo4j.graphdb.Transaction graphDbTx;
        private Transaction jtaTx;

        private TransactionContinuation(HighlyAvailableGraphDatabase db) {
            this.db = db;
            this.txManager = (TransactionManager)db.getDependencyResolver().resolveDependency(TransactionManager.class);
        }

        public void begin() {
            this.graphDbTx = this.db.beginTx();
        }

        public void suspend() throws SystemException {
            this.jtaTx = this.txManager.suspend();
        }

        public void resume() throws Exception {
            this.txManager.resume(this.jtaTx);
        }

        public void commit() {
            this.graphDbTx.close();
        }
    }
}

