/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class UpdatePullerTest {
    @Test
    public void shouldNotStartPullingUpdatesUntilStartIsCalled() throws Throwable {
        OnDemandCallScheduler scheduler = new OnDemandCallScheduler();
        Config config = (Config)Mockito.mock(Config.class);
        InstanceId myId = new InstanceId(1);
        Mockito.when((Object)config.get(HaSettings.pull_interval)).thenReturn((Object)1000L);
        Mockito.when((Object)config.get(ClusterSettings.server_id)).thenReturn((Object)myId);
        LastUpdateTime lastUpdateTime = (LastUpdateTime)Mockito.mock(LastUpdateTime.class);
        AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        Mockito.when((Object)availabilityGuard.isAvailable(Matchers.anyLong())).thenReturn((Object)true);
        HaXaDataSourceManager dataSourceManager = (HaXaDataSourceManager)Mockito.mock(HaXaDataSourceManager.class);
        Master master = (Master)Mockito.mock(Master.class);
        UpdatePuller puller = new UpdatePuller((HighAvailabilityMemberStateMachine)Mockito.mock(HighAvailabilityMemberStateMachine.class), dataSourceManager, master, (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (AbstractTransactionManager)Mockito.mock(AbstractTransactionManager.class), availabilityGuard, lastUpdateTime, config, (JobScheduler)scheduler, (StringLogger)Mockito.mock(StringLogger.class));
        puller.init();
        Assert.assertNotNull((Object)scheduler.getJob());
        scheduler.runJob();
        Mockito.verifyZeroInteractions((Object[])new Object[]{lastUpdateTime, availabilityGuard, dataSourceManager});
    }

    @Test
    public void shouldStartAndStopPullingUpdatesWhenStartAndStopIsCalled() throws Throwable {
        OnDemandCallScheduler scheduler = new OnDemandCallScheduler();
        Config config = (Config)Mockito.mock(Config.class);
        InstanceId myId = new InstanceId(1);
        Mockito.when((Object)config.get(HaSettings.pull_interval)).thenReturn((Object)1000L);
        Mockito.when((Object)config.get(ClusterSettings.server_id)).thenReturn((Object)myId);
        LastUpdateTime lastUpdateTime = (LastUpdateTime)Mockito.mock(LastUpdateTime.class);
        AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        Mockito.when((Object)availabilityGuard.isAvailable(Matchers.anyLong())).thenReturn((Object)true);
        HaXaDataSourceManager dataSourceManager = (HaXaDataSourceManager)Mockito.mock(HaXaDataSourceManager.class);
        Master master = (Master)Mockito.mock(Master.class);
        UpdatePuller puller = new UpdatePuller((HighAvailabilityMemberStateMachine)Mockito.mock(HighAvailabilityMemberStateMachine.class), dataSourceManager, master, (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (AbstractTransactionManager)Mockito.mock(AbstractTransactionManager.class), availabilityGuard, lastUpdateTime, config, (JobScheduler)scheduler, (StringLogger)Mockito.mock(StringLogger.class));
        puller.init();
        Assert.assertNotNull((Object)scheduler.getJob());
        puller.start();
        scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(Matchers.anyLong());
        ((HaXaDataSourceManager)Mockito.verify((Object)dataSourceManager, (VerificationMode)Mockito.times((int)1))).applyTransactions((Response)Matchers.any());
        ((Master)Mockito.verify((Object)master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)Matchers.any());
        puller.stop();
        scheduler.runJob();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{lastUpdateTime, availabilityGuard, dataSourceManager});
    }

    @Test
    public void shouldStopPullingUpdatesWhenThisInstanceBecomesTheMaster() throws Throwable {
        OnDemandCallScheduler scheduler = new OnDemandCallScheduler();
        Config config = (Config)Mockito.mock(Config.class);
        InstanceId myId = new InstanceId(1);
        Mockito.when((Object)config.get(HaSettings.pull_interval)).thenReturn((Object)1000L);
        Mockito.when((Object)config.get(ClusterSettings.server_id)).thenReturn((Object)myId);
        LastUpdateTime lastUpdateTime = (LastUpdateTime)Mockito.mock(LastUpdateTime.class);
        AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        Mockito.when((Object)availabilityGuard.isAvailable(Matchers.anyLong())).thenReturn((Object)true);
        HaXaDataSourceManager dataSourceManager = (HaXaDataSourceManager)Mockito.mock(HaXaDataSourceManager.class);
        Master master = (Master)Mockito.mock(Master.class);
        CapturingHighAvailabilityMemberStateMachine memberStateMachine = new CapturingHighAvailabilityMemberStateMachine(myId);
        UpdatePuller puller = new UpdatePuller((HighAvailabilityMemberStateMachine)memberStateMachine, dataSourceManager, master, (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (AbstractTransactionManager)Mockito.mock(AbstractTransactionManager.class), availabilityGuard, lastUpdateTime, config, (JobScheduler)scheduler, (StringLogger)Mockito.mock(StringLogger.class));
        puller.init();
        puller.start();
        scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(Matchers.anyLong());
        ((HaXaDataSourceManager)Mockito.verify((Object)dataSourceManager, (VerificationMode)Mockito.times((int)1))).applyTransactions((Response)Matchers.any());
        ((Master)Mockito.verify((Object)master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)Matchers.any());
        memberStateMachine.switchInstanceToMaster();
        scheduler.runJob();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{lastUpdateTime, availabilityGuard, dataSourceManager});
    }

    @Test
    public void shouldKeepPullingUpdatesWhenThisInstanceBecomesASlave() throws Throwable {
        OnDemandCallScheduler scheduler = new OnDemandCallScheduler();
        Config config = (Config)Mockito.mock(Config.class);
        InstanceId myId = new InstanceId(1);
        Mockito.when((Object)config.get(HaSettings.pull_interval)).thenReturn((Object)1000L);
        Mockito.when((Object)config.get(ClusterSettings.server_id)).thenReturn((Object)myId);
        LastUpdateTime lastUpdateTime = (LastUpdateTime)Mockito.mock(LastUpdateTime.class);
        AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        Mockito.when((Object)availabilityGuard.isAvailable(Matchers.anyLong())).thenReturn((Object)true);
        HaXaDataSourceManager dataSourceManager = (HaXaDataSourceManager)Mockito.mock(HaXaDataSourceManager.class);
        Master master = (Master)Mockito.mock(Master.class);
        CapturingHighAvailabilityMemberStateMachine memberStateMachine = new CapturingHighAvailabilityMemberStateMachine(myId);
        UpdatePuller puller = new UpdatePuller((HighAvailabilityMemberStateMachine)memberStateMachine, dataSourceManager, master, (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (AbstractTransactionManager)Mockito.mock(AbstractTransactionManager.class), availabilityGuard, lastUpdateTime, config, (JobScheduler)scheduler, (StringLogger)Mockito.mock(StringLogger.class));
        puller.init();
        puller.start();
        scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(Matchers.anyLong());
        ((HaXaDataSourceManager)Mockito.verify((Object)dataSourceManager, (VerificationMode)Mockito.times((int)1))).applyTransactions((Response)Matchers.any());
        ((Master)Mockito.verify((Object)master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)Matchers.any());
        memberStateMachine.switchInstanceToSlave();
        scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)lastUpdateTime, (VerificationMode)Mockito.times((int)2))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)availabilityGuard, (VerificationMode)Mockito.times((int)2))).isAvailable(Matchers.anyLong());
        ((HaXaDataSourceManager)Mockito.verify((Object)dataSourceManager, (VerificationMode)Mockito.times((int)2))).applyTransactions((Response)Matchers.any());
        ((Master)Mockito.verify((Object)master, (VerificationMode)Mockito.times((int)2))).pullUpdates((RequestContext)Matchers.any());
    }

    @Test
    public void shouldResumePullingUpdatesWhenThisInstanceSwitchesFromMasterToSlave() throws Throwable {
        OnDemandCallScheduler scheduler = new OnDemandCallScheduler();
        Config config = (Config)Mockito.mock(Config.class);
        InstanceId myId = new InstanceId(1);
        Mockito.when((Object)config.get(HaSettings.pull_interval)).thenReturn((Object)1000L);
        Mockito.when((Object)config.get(ClusterSettings.server_id)).thenReturn((Object)myId);
        LastUpdateTime lastUpdateTime = (LastUpdateTime)Mockito.mock(LastUpdateTime.class);
        AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        Mockito.when((Object)availabilityGuard.isAvailable(Matchers.anyLong())).thenReturn((Object)true);
        HaXaDataSourceManager dataSourceManager = (HaXaDataSourceManager)Mockito.mock(HaXaDataSourceManager.class);
        Master master = (Master)Mockito.mock(Master.class);
        CapturingHighAvailabilityMemberStateMachine memberStateMachine = new CapturingHighAvailabilityMemberStateMachine(myId);
        UpdatePuller puller = new UpdatePuller((HighAvailabilityMemberStateMachine)memberStateMachine, dataSourceManager, master, (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (AbstractTransactionManager)Mockito.mock(AbstractTransactionManager.class), availabilityGuard, lastUpdateTime, config, (JobScheduler)scheduler, (StringLogger)Mockito.mock(StringLogger.class));
        puller.init();
        puller.start();
        scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(Matchers.anyLong());
        ((HaXaDataSourceManager)Mockito.verify((Object)dataSourceManager, (VerificationMode)Mockito.times((int)1))).applyTransactions((Response)Matchers.any());
        ((Master)Mockito.verify((Object)master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)Matchers.any());
        memberStateMachine.switchInstanceToMaster();
        scheduler.runJob();
        memberStateMachine.switchInstanceToSlave();
        scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)lastUpdateTime, (VerificationMode)Mockito.times((int)2))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)availabilityGuard, (VerificationMode)Mockito.times((int)2))).isAvailable(Matchers.anyLong());
        ((HaXaDataSourceManager)Mockito.verify((Object)dataSourceManager, (VerificationMode)Mockito.times((int)2))).applyTransactions((Response)Matchers.any());
        ((Master)Mockito.verify((Object)master, (VerificationMode)Mockito.times((int)2))).pullUpdates((RequestContext)Matchers.any());
    }

    @Test
    public void shouldResumePullingUpdatesWhenThisInstanceSwitchesFromSlaveToMaster() throws Throwable {
        OnDemandCallScheduler scheduler = new OnDemandCallScheduler();
        Config config = (Config)Mockito.mock(Config.class);
        InstanceId myId = new InstanceId(1);
        Mockito.when((Object)config.get(HaSettings.pull_interval)).thenReturn((Object)1000L);
        Mockito.when((Object)config.get(ClusterSettings.server_id)).thenReturn((Object)myId);
        LastUpdateTime lastUpdateTime = (LastUpdateTime)Mockito.mock(LastUpdateTime.class);
        AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        Mockito.when((Object)availabilityGuard.isAvailable(Matchers.anyLong())).thenReturn((Object)true);
        HaXaDataSourceManager dataSourceManager = (HaXaDataSourceManager)Mockito.mock(HaXaDataSourceManager.class);
        Master master = (Master)Mockito.mock(Master.class);
        CapturingHighAvailabilityMemberStateMachine memberStateMachine = new CapturingHighAvailabilityMemberStateMachine(myId);
        UpdatePuller puller = new UpdatePuller((HighAvailabilityMemberStateMachine)memberStateMachine, dataSourceManager, master, (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (AbstractTransactionManager)Mockito.mock(AbstractTransactionManager.class), availabilityGuard, lastUpdateTime, config, (JobScheduler)scheduler, (StringLogger)Mockito.mock(StringLogger.class));
        puller.init();
        puller.start();
        scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(Matchers.anyLong());
        ((HaXaDataSourceManager)Mockito.verify((Object)dataSourceManager, (VerificationMode)Mockito.times((int)1))).applyTransactions((Response)Matchers.any());
        ((Master)Mockito.verify((Object)master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)Matchers.any());
        memberStateMachine.switchInstanceToSlave();
        scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)lastUpdateTime, (VerificationMode)Mockito.times((int)2))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)availabilityGuard, (VerificationMode)Mockito.times((int)2))).isAvailable(Matchers.anyLong());
        ((HaXaDataSourceManager)Mockito.verify((Object)dataSourceManager, (VerificationMode)Mockito.times((int)2))).applyTransactions((Response)Matchers.any());
        ((Master)Mockito.verify((Object)master, (VerificationMode)Mockito.times((int)2))).pullUpdates((RequestContext)Matchers.any());
        memberStateMachine.switchInstanceToMaster();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{lastUpdateTime, availabilityGuard, dataSourceManager});
    }

    private static class CapturingHighAvailabilityMemberStateMachine
    extends HighAvailabilityMemberStateMachine {
        private final InstanceId myId;
        private final URI uri;
        private HighAvailabilityMemberListener listener;

        public CapturingHighAvailabilityMemberStateMachine(InstanceId myId) {
            super((HighAvailabilityMemberContext)Mockito.mock(HighAvailabilityMemberContext.class), (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class), (ClusterMembers)Mockito.mock(ClusterMembers.class), (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class), (Election)Mockito.mock(Election.class), (StringLogger)Mockito.mock(StringLogger.class));
            this.myId = myId;
            this.uri = URI.create("ha://me");
        }

        public void addHighAvailabilityMemberListener(HighAvailabilityMemberListener toAdd) {
            this.listener = toAdd;
        }

        public void switchInstanceToSlave() {
            this.listener.slaveIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.TO_SLAVE, HighAvailabilityMemberState.SLAVE, this.myId, this.uri));
        }

        public void switchInstanceToMaster() {
            this.listener.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.TO_MASTER, HighAvailabilityMemberState.MASTER, this.myId, this.uri));
        }
    }

    private static class OnDemandCallScheduler
    extends LifecycleAdapter
    implements JobScheduler {
        private Runnable job;

        private OnDemandCallScheduler() {
        }

        public void schedule(JobScheduler.Group group, Runnable job) {
            this.job = job;
        }

        public void scheduleRecurring(JobScheduler.Group group, Runnable runnable, long period, TimeUnit timeUnit) {
            this.job = runnable;
        }

        public void scheduleRecurring(JobScheduler.Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
            this.job = runnable;
        }

        public void cancelRecurring(JobScheduler.Group group, Runnable runnable) {
            this.job = null;
        }

        public Runnable getJob() {
            return this.job;
        }

        public void runJob() {
            this.job.run();
        }
    }
}

