/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.HighPerformanceCacheSettings;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.test.TestGraphDatabaseFactory;

@Ignore(value="Impermanent graph database doesn't use High-Performance Cache")
public class TestCacheObjectReuse {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void highPerformanceCachesCanBeReusedBetweenSessions() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "hpc").newGraphDatabase();
        Cache firstCache = (Cache)IteratorUtil.first((Iterable)this.nodeManager(db).caches());
        db.shutdown();
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "hpc").newGraphDatabase();
        try {
            Cache secondCache = (Cache)IteratorUtil.first((Iterable)this.nodeManager(db).caches());
            Assert.assertEquals((Object)firstCache, (Object)secondCache);
        }
        finally {
            db.shutdown();
        }
    }

    private NodeManager nodeManager(GraphDatabaseAPI db) {
        return (NodeManager)db.getDependencyResolver().resolveDependency(NodeManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void highPerformanceCachesAreRecreatedBetweenSessionsIfConfigChanges() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "hpc").newGraphDatabase();
        Cache firstCache = (Cache)IteratorUtil.first((Iterable)this.nodeManager(db).caches());
        db.shutdown();
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "hpc").setConfig(HighPerformanceCacheSettings.node_cache_array_fraction, "10").newGraphDatabase();
        try {
            Cache secondCache = (Cache)IteratorUtil.first((Iterable)this.nodeManager(db).caches());
            Assert.assertFalse((boolean)firstCache.equals(secondCache));
        }
        finally {
            db.shutdown();
        }
    }
}

