/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.neo4j.cluster.InstanceId;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.impl.nioneo.store.StoreId;

public class ClusterMemberVersionCheck {
    private final ClusterMembers clusterMembers;
    private final InstanceId myId;
    private final Clock clock;

    public ClusterMemberVersionCheck(ClusterMembers clusterMembers, InstanceId myId, Clock clock) {
        this.clusterMembers = clusterMembers;
        this.myId = myId;
        this.clock = clock;
    }

    public Outcome doVersionCheck(StoreId storeId, long timeout, TimeUnit timeUnit) throws InterruptedException {
        Outcome outcome = new Outcome();
        this.waitForAllAliveToBeAvailable(timeout, timeUnit, outcome);
        this.noMismatches(storeId, outcome);
        return outcome;
    }

    private void waitForAllAliveToBeAvailable(long timeout, TimeUnit timeUnit, Outcome outcome) throws InterruptedException {
        long start = this.clock.currentTimeMillis();
        for (long timeoutMillis = timeUnit.toMillis(timeout); timeoutMillis > 0L; timeoutMillis -= this.clock.currentTimeMillis() - start) {
            this.allAliveAreAvailable(outcome);
            if (!outcome.hasUnavailable()) {
                return;
            }
            this.clusterMembers.waitForEvent(timeoutMillis);
        }
        this.allAliveAreAvailable(outcome);
    }

    private void allAliveAreAvailable(Outcome outcome) {
        outcome.clearUnavailable();
        for (ClusterMember member : this.clusterMembers.getMembers()) {
            if (this.myId.equals((Object)member.getInstanceId()) || !member.isInitiallyKnown() || !member.isAlive() || !"UNKNOWN".equals(member.getHARole())) continue;
            outcome.addUnavailable(member.getInstanceId());
        }
    }

    private void noMismatches(StoreId expectedStoreId, Outcome outcome) {
        for (ClusterMember member : this.clusterMembers.getMembers()) {
            if (!member.isAlive() || !member.isInitiallyKnown() || ClusterMemberVersionCheck.equal(expectedStoreId, member.getStoreId())) continue;
            outcome.addMismatched(member.getInstanceId(), member.getStoreId());
        }
    }

    private static boolean equal(StoreId first, StoreId second) {
        return first.getStoreVersion() != second.getStoreVersion() || first.equalsByUpgradeId(second);
    }

    public static class Outcome {
        private final Set<Integer> unavailable = new HashSet<Integer>();
        private final Map<Integer, StoreId> mismatched = new HashMap<Integer, StoreId>();

        public Set<Integer> getUnavailable() {
            return this.unavailable;
        }

        private void addUnavailable(InstanceId instanceId) {
            this.unavailable.add(instanceId.toIntegerIndex());
        }

        private void clearUnavailable() {
            this.unavailable.clear();
        }

        public boolean hasUnavailable() {
            return !this.unavailable.isEmpty();
        }

        public Map<Integer, StoreId> getMismatched() {
            return this.mismatched;
        }

        private void addMismatched(InstanceId instanceId, StoreId storeId) {
            this.mismatched.put(instanceId.toIntegerIndex(), storeId);
        }

        public boolean hasMismatched() {
            return !this.mismatched.isEmpty();
        }

        public String toString() {
            return "Outcome{unavailable=" + this.unavailable + ", mismatched=" + this.mismatched + '}';
        }
    }
}

