/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.net.URI;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.cluster.AbstractModeSwitcher;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.transaction.MasterTxHook;
import org.neo4j.kernel.ha.transaction.SlaveTxHook;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.util.StringLogger;

public class TxHookModeSwitcher
extends AbstractModeSwitcher<RemoteTxHook> {
    private final DelegateInvocationHandler<Master> master;
    private final RequestContextFactoryResolver requestContextFactory;
    private final StringLogger log;
    private final DependencyResolver resolver;

    public TxHookModeSwitcher(HighAvailabilityMemberStateMachine stateMachine, DelegateInvocationHandler<RemoteTxHook> delegate, DelegateInvocationHandler<Master> master, RequestContextFactoryResolver requestContextFactory, StringLogger log, DependencyResolver resolver) {
        super(stateMachine, delegate);
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.log = log;
        this.resolver = resolver;
    }

    @Override
    protected RemoteTxHook getMasterImpl() {
        return new MasterTxHook();
    }

    @Override
    protected RemoteTxHook getSlaveImpl(URI serverHaUri) {
        return new SlaveTxHook(this.master.cement(), (HaXaDataSourceManager)((Object)this.resolver.resolveDependency(HaXaDataSourceManager.class)), this.requestContextFactory, this.log);
    }

    public static interface RequestContextFactoryResolver {
        public RequestContextFactory get();
    }
}

