/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.BlockLogBuffer;
import org.neo4j.com.Client;
import org.neo4j.com.Deserializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.Protocol201;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TxExtractor;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.HaRequestType201;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.nioneo.store.IdRange;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.TransactionAlreadyActiveException;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;

public class MasterClient201
extends Client<Master>
implements MasterClient {
    public static final ProtocolVersion PROTOCOL_VERSION = new ProtocolVersion(6, 2);
    private final long lockReadTimeout;
    private final ByteCounterMonitor monitor;

    public MasterClient201(String hostNameOrIp, int port, Logging logging, Monitors monitors, StoreId storeId, long readTimeoutSeconds, long lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
        super(hostNameOrIp, port, logging, monitors, storeId, 0x1000000, PROTOCOL_VERSION, readTimeoutSeconds, maxConcurrentChannels, chunkSize);
        this.lockReadTimeout = lockReadTimeout;
        this.monitor = (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, this.getClass(), new String[0]);
    }

    protected Protocol createProtocol(int chunkSize, byte applicationProtocolVersion) {
        return new Protocol201(chunkSize, applicationProtocolVersion, this.getInternalProtocolVersion());
    }

    protected long getReadTimeout(RequestType<Master> type, long readTimeout) {
        HaRequestType201 specificType = (HaRequestType201)type;
        if (specificType.isLock()) {
            return this.lockReadTimeout;
        }
        if (specificType == HaRequestType201.COPY_STORE) {
            return readTimeout * 2L;
        }
        return readTimeout;
    }

    protected boolean shouldCheckStoreId(RequestType<Master> type) {
        return type != HaRequestType201.COPY_STORE;
    }

    @Override
    public Response<IdAllocation> allocateIds(RequestContext context, final IdType idType) {
        return this.sendRequest(HaRequestType201.ALLOCATE_IDS, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                buffer.writeByte(idType.ordinal());
            }
        }, (Deserializer)new Deserializer<IdAllocation>(){

            public IdAllocation read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) {
                return MasterClient201.readIdAllocation(buffer);
            }
        });
    }

    @Override
    public Response<Integer> createRelationshipType(RequestContext context, final String name) {
        return this.sendRequest(HaRequestType201.CREATE_RELATIONSHIP_TYPE, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)name);
            }
        }, (Deserializer)new Deserializer<Integer>(){

            public Integer read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readInt();
            }
        });
    }

    @Override
    public Response<Integer> createPropertyKey(RequestContext context, final String name) {
        return this.sendRequest(HaRequestType201.CREATE_PROPERTY_KEY, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)name);
            }
        }, (Deserializer)new Deserializer<Integer>(){

            public Integer read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readInt();
            }
        });
    }

    @Override
    public Response<Integer> createLabel(RequestContext context, final String name) {
        return this.sendRequest(HaRequestType201.CREATE_LABEL, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)name);
            }
        }, (Deserializer)new Deserializer<Integer>(){

            public Integer read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readInt();
            }
        });
    }

    @Override
    public Response<Void> initializeTx(RequestContext context) {
        return this.sendRequest(HaRequestType201.INITIALIZE_TX, context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireExclusiveLock(RequestContext context, Locks.ResourceType resourceType, long ... resourceIds) {
        if (resourceType == ResourceTypes.NODE) {
            return this.sendRequest(HaRequestType201.ACQUIRE_NODE_WRITE_LOCK, context, new AcquireLockSerializer(resourceIds), LOCK_RESULT_DESERIALIZER);
        }
        if (resourceType == ResourceTypes.RELATIONSHIP) {
            return this.sendRequest(HaRequestType201.ACQUIRE_RELATIONSHIP_WRITE_LOCK, context, new AcquireLockSerializer(resourceIds), LOCK_RESULT_DESERIALIZER);
        }
        if (resourceType == ResourceTypes.GRAPH_PROPS) {
            return this.sendRequest(HaRequestType201.ACQUIRE_GRAPH_WRITE_LOCK, context, Protocol.EMPTY_SERIALIZER, LOCK_RESULT_DESERIALIZER);
        }
        if (resourceType == ResourceTypes.SCHEMA) {
            return this.sendRequest(HaRequestType201.ACQUIRE_SCHEMA_WRITE_LOCK, context, Protocol.EMPTY_SERIALIZER, LOCK_RESULT_DESERIALIZER);
        }
        throw new IllegalArgumentException("Don't know how to take lock on resource: '" + resourceType + "'.");
    }

    @Override
    public Response<LockResult> acquireSharedLock(RequestContext context, Locks.ResourceType resourceType, long ... resourceIds) {
        if (resourceType == ResourceTypes.NODE) {
            return this.sendRequest(HaRequestType201.ACQUIRE_NODE_READ_LOCK, context, new AcquireLockSerializer(resourceIds), LOCK_RESULT_DESERIALIZER);
        }
        if (resourceType == ResourceTypes.RELATIONSHIP) {
            return this.sendRequest(HaRequestType201.ACQUIRE_RELATIONSHIP_READ_LOCK, context, new AcquireLockSerializer(resourceIds), LOCK_RESULT_DESERIALIZER);
        }
        if (resourceType == ResourceTypes.GRAPH_PROPS) {
            return this.sendRequest(HaRequestType201.ACQUIRE_GRAPH_READ_LOCK, context, Protocol.EMPTY_SERIALIZER, LOCK_RESULT_DESERIALIZER);
        }
        if (resourceType == ResourceTypes.SCHEMA) {
            return this.sendRequest(HaRequestType201.ACQUIRE_SCHEMA_READ_LOCK, context, Protocol.EMPTY_SERIALIZER, LOCK_RESULT_DESERIALIZER);
        }
        throw new IllegalArgumentException("Don't know how to take lock on resource: '" + resourceType + "'.");
    }

    @Override
    public Response<Long> commitSingleResourceTransaction(RequestContext context, final String resource, final TxExtractor txGetter) {
        return this.sendRequest(HaRequestType201.COMMIT, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)resource);
                BlockLogBuffer blockLogBuffer = new BlockLogBuffer(buffer, MasterClient201.this.monitor);
                txGetter.extract((LogBuffer)blockLogBuffer);
                blockLogBuffer.done();
            }
        }, (Deserializer)new Deserializer<Long>(){

            public Long read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readLong();
            }
        });
    }

    @Override
    public Response<Void> finishTransaction(RequestContext context, final boolean success) {
        try {
            return this.sendRequest(HaRequestType201.FINISH, context, new Serializer(){

                public void write(ChannelBuffer buffer) throws IOException {
                    buffer.writeByte(success ? 1 : 0);
                }
            }, Protocol.VOID_DESERIALIZER);
        }
        catch (TransactionAlreadyActiveException e) {
            if (!success) {
                return new Response(null, this.getStoreId(), TransactionStream.EMPTY, ResourceReleaser.NO_OP);
            }
            throw e;
        }
    }

    @Override
    public void rollbackOngoingTransactions(RequestContext context) {
        throw new UnsupportedOperationException("Should never be called from the client side");
    }

    @Override
    public Response<Void> pullUpdates(RequestContext context) {
        return this.sendRequest(HaRequestType201.PULL_UPDATES, context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<HandshakeResult> handshake(final long txId, StoreId storeId) {
        return this.sendRequest(HaRequestType201.HANDSHAKE, RequestContext.EMPTY, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                buffer.writeLong(txId);
            }
        }, (Deserializer)new Deserializer<HandshakeResult>(){

            public HandshakeResult read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return new HandshakeResult(buffer.readInt(), buffer.readLong(), buffer.readLong());
            }
        }, storeId);
    }

    @Override
    public Response<Void> copyStore(RequestContext context, StoreWriter writer) {
        context = this.stripFromTransactions(context);
        return this.sendRequest(HaRequestType201.COPY_STORE, context, Protocol.EMPTY_SERIALIZER, (Deserializer)new Protocol.FileStreamsDeserializer(writer));
    }

    private RequestContext stripFromTransactions(RequestContext context) {
        return new RequestContext(context.getEpoch(), context.machineId(), context.getEventIdentifier(), new RequestContext.Tx[0], context.getMasterId(), context.getChecksum());
    }

    @Override
    public Response<Void> copyTransactions(RequestContext context, final String ds, final long startTxId, final long endTxId) {
        context = this.stripFromTransactions(context);
        return this.sendRequest(HaRequestType201.COPY_TRANSACTIONS, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)ds);
                buffer.writeLong(startTxId);
                buffer.writeLong(endTxId);
            }
        }, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return PROTOCOL_VERSION;
    }

    @Override
    public Response<Void> pushTransaction(RequestContext context, final String resourceName, final long tx) {
        context = this.stripFromTransactions(context);
        return this.sendRequest(HaRequestType201.PUSH_TRANSACTION, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)resourceName);
                buffer.writeLong(tx);
            }
        }, Protocol.VOID_DESERIALIZER);
    }

    protected static IdAllocation readIdAllocation(ChannelBuffer buffer) {
        int numberOfDefragIds = buffer.readInt();
        long[] defragIds = new long[numberOfDefragIds];
        for (int i = 0; i < numberOfDefragIds; ++i) {
            defragIds[i] = buffer.readLong();
        }
        long rangeStart = buffer.readLong();
        int rangeLength = buffer.readInt();
        long highId = buffer.readLong();
        long defragCount = buffer.readLong();
        return new IdAllocation(new IdRange(defragIds, rangeStart, rangeLength), highId, defragCount);
    }

    protected static class AcquireLockSerializer
    implements Serializer {
        private final long[] entities;

        AcquireLockSerializer(long ... entities) {
            this.entities = entities;
        }

        public void write(ChannelBuffer buffer) throws IOException {
            buffer.writeInt(this.entities.length);
            for (long entity : this.entities) {
                buffer.writeLong(entity);
            }
        }
    }
}

