/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.Uris;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.impl.nioneo.store.InconsistentlyUpgradedClusterException;
import org.neo4j.kernel.impl.nioneo.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.store.UnableToCopyStoreFromOldMasterException;
import org.neo4j.kernel.impl.nioneo.store.UnavailableMembersException;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;

public class HighAvailabilityModeSwitcher
implements HighAvailabilityMemberListener,
BindingListener,
Lifecycle {
    public static final String MASTER = "master";
    public static final String SLAVE = "slave";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String INADDR_ANY = "0.0.0.0";
    private volatile URI masterHaURI;
    private volatile URI slaveHaURI;
    private CancellationHandle cancellationHandle;
    private URI availableMasterId;
    private final SwitchToSlave switchToSlave;
    private final SwitchToMaster switchToMaster;
    private final Election election;
    private final ClusterMemberAvailability clusterMemberAvailability;
    private final DependencyResolver dependencyResolver;
    private final StringLogger msgLog;
    private final ConsoleLogger consoleLog;
    private LifeSupport haCommunicationLife;
    private ScheduledExecutorService modeSwitcherExecutor;
    private volatile URI me;
    private volatile Future<?> modeSwitcherFuture;
    private volatile HighAvailabilityMemberState currentTargetState;

    public static InstanceId getServerId(URI haUri) {
        return (InstanceId)ClusterSettings.INSTANCE_ID.apply(Functions.withDefaults((Function)Functions.constant((Object)"-1"), (Function)Uris.parameter((String)"serverId")).apply((Object)haUri));
    }

    public HighAvailabilityModeSwitcher(SwitchToSlave switchToSlave, SwitchToMaster switchToMaster, Election election, ClusterMemberAvailability clusterMemberAvailability, DependencyResolver dependencyResolver, Logging logging) {
        this.switchToSlave = switchToSlave;
        this.switchToMaster = switchToMaster;
        this.election = election;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.msgLog = logging.getMessagesLog(this.getClass());
        this.consoleLog = logging.getConsoleLog(this.getClass());
        this.haCommunicationLife = new LifeSupport();
        this.dependencyResolver = dependencyResolver;
    }

    public void listeningAt(URI myUri) {
        this.me = myUri;
    }

    public synchronized void init() throws Throwable {
        this.modeSwitcherExecutor = Executors.newSingleThreadScheduledExecutor(NamedThreadFactory.named((String)"HA Mode switcher"));
        this.haCommunicationLife.init();
    }

    public synchronized void start() throws Throwable {
        this.haCommunicationLife.start();
    }

    public synchronized void stop() throws Throwable {
        this.haCommunicationLife.stop();
    }

    public synchronized void shutdown() throws Throwable {
        this.modeSwitcherExecutor.shutdown();
        this.modeSwitcherExecutor.awaitTermination(60L, TimeUnit.SECONDS);
        this.haCommunicationLife.shutdown();
    }

    @Override
    public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
        if (event.getNewState() == event.getOldState() && event.getOldState() == HighAvailabilityMemberState.MASTER) {
            this.clusterMemberAvailability.memberIsAvailable(MASTER, this.masterHaURI, this.resolveStoreId());
        } else {
            try {
                this.stateChanged(event);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
        if (event.getNewState() == event.getOldState() && event.getOldState() == HighAvailabilityMemberState.SLAVE) {
            this.clusterMemberAvailability.memberIsAvailable(SLAVE, this.slaveHaURI, this.resolveStoreId());
        } else {
            try {
                this.stateChanged(event);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
    }

    @Override
    public void instanceStops(HighAvailabilityMemberChangeEvent event) {
        try {
            this.stateChanged(event);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void stateChanged(HighAvailabilityMemberChangeEvent event) throws ExecutionException, InterruptedException {
        this.availableMasterId = event.getServerHaUri();
        if (event.getNewState() == event.getOldState()) {
            return;
        }
        this.currentTargetState = event.getNewState();
        switch (event.getNewState()) {
            case TO_MASTER: {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.clusterMemberAvailability.memberIsUnavailable(SLAVE);
                }
                this.switchToMaster();
                break;
            }
            case TO_SLAVE: {
                this.switchToSlave();
                break;
            }
            case PENDING: {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.clusterMemberAvailability.memberIsUnavailable(SLAVE);
                } else if (event.getOldState().equals((Object)HighAvailabilityMemberState.MASTER)) {
                    this.clusterMemberAvailability.memberIsUnavailable(MASTER);
                }
                this.startModeSwitching(new Runnable(){

                    @Override
                    public void run() {
                        HighAvailabilityModeSwitcher.this.haCommunicationLife.shutdown();
                        HighAvailabilityModeSwitcher.this.haCommunicationLife = new LifeSupport();
                    }
                }, new CancellationHandle());
                try {
                    this.modeSwitcherFuture.get(10L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    private void switchToMaster() throws ExecutionException, InterruptedException {
        final CancellationHandle cancellationHandle = new CancellationHandle();
        this.startModeSwitching(new Runnable(){

            @Override
            public void run() {
                if (cancellationHandle.cancellationRequested()) {
                    return;
                }
                if (HighAvailabilityModeSwitcher.this.currentTargetState != HighAvailabilityMemberState.TO_MASTER) {
                    return;
                }
                HighAvailabilityModeSwitcher.this.haCommunicationLife.shutdown();
                HighAvailabilityModeSwitcher.this.haCommunicationLife = new LifeSupport();
                try {
                    HighAvailabilityModeSwitcher.this.masterHaURI = HighAvailabilityModeSwitcher.this.switchToMaster.switchToMaster(HighAvailabilityModeSwitcher.this.haCommunicationLife, HighAvailabilityModeSwitcher.this.me);
                }
                catch (Throwable e) {
                    HighAvailabilityModeSwitcher.this.msgLog.logMessage("Failed to switch to master", e);
                    HighAvailabilityModeSwitcher.this.election.demote(HighAvailabilityModeSwitcher.getServerId(HighAvailabilityModeSwitcher.this.me));
                }
            }
        }, cancellationHandle);
    }

    private void switchToSlave() throws ExecutionException, InterruptedException {
        final URI masterUri = this.availableMasterId;
        if (HighAvailabilityModeSwitcher.getServerId(masterUri).equals((Object)HighAvailabilityModeSwitcher.getServerId(this.me))) {
            this.msgLog.error("I (" + this.me + ") tried to switch to slave for myself as master (" + masterUri + ")");
            return;
        }
        final AtomicLong wait = new AtomicLong();
        final CancellationHandle cancellationHandle = new CancellationHandle();
        this.startModeSwitching(new Runnable(){

            @Override
            public void run() {
                if (HighAvailabilityModeSwitcher.this.currentTargetState != HighAvailabilityMemberState.TO_SLAVE) {
                    return;
                }
                try {
                    HighAvailabilityModeSwitcher.this.haCommunicationLife.shutdown();
                    HighAvailabilityModeSwitcher.this.haCommunicationLife = new LifeSupport();
                    URI resultingSlaveHaURI = HighAvailabilityModeSwitcher.this.switchToSlave.switchToSlave(HighAvailabilityModeSwitcher.this.haCommunicationLife, HighAvailabilityModeSwitcher.this.me, masterUri, cancellationHandle);
                    if (resultingSlaveHaURI == null) {
                        HighAvailabilityModeSwitcher.this.msgLog.info("Switch to slave resulted in null URI - that means it was effectively cancelled");
                    } else {
                        HighAvailabilityModeSwitcher.this.slaveHaURI = resultingSlaveHaURI;
                    }
                }
                catch (InconsistentlyUpgradedClusterException | UnableToCopyStoreFromOldMasterException | UnavailableMembersException e) {
                    HighAvailabilityModeSwitcher.this.consoleLog.error("UNABLE TO START UP AS SLAVE: " + e.getMessage());
                    HighAvailabilityModeSwitcher.this.msgLog.error("Unable to start up as slave", e);
                    HighAvailabilityModeSwitcher.this.clusterMemberAvailability.memberIsUnavailable(HighAvailabilityModeSwitcher.SLAVE);
                    ClusterClient clusterClient = (ClusterClient)HighAvailabilityModeSwitcher.this.dependencyResolver.resolveDependency(ClusterClient.class);
                    try {
                        clusterClient.leave();
                        clusterClient.stop();
                        HighAvailabilityModeSwitcher.this.haCommunicationLife.shutdown();
                    }
                    catch (Throwable t) {
                        HighAvailabilityModeSwitcher.this.msgLog.error("Unable to stop cluster client", t);
                    }
                    HighAvailabilityModeSwitcher.this.modeSwitcherExecutor.schedule(this, 5L, TimeUnit.SECONDS);
                    throw e;
                }
                catch (MismatchingStoreIdException | NoSuchLogVersionException e) {
                    this.run();
                }
                catch (Throwable t) {
                    HighAvailabilityModeSwitcher.this.msgLog.logMessage("Error while trying to switch to slave", t);
                    wait.set(1L + wait.get() * 2L);
                    wait.set(Math.min(wait.get(), 300L));
                    HighAvailabilityModeSwitcher.this.modeSwitcherFuture = HighAvailabilityModeSwitcher.this.modeSwitcherExecutor.schedule(this, wait.get(), TimeUnit.SECONDS);
                    HighAvailabilityModeSwitcher.this.msgLog.logMessage("Attempting to switch to slave in " + wait.get() + "s");
                }
            }
        }, cancellationHandle);
    }

    private synchronized void startModeSwitching(Runnable switcher, CancellationHandle cancellationHandle) throws ExecutionException, InterruptedException {
        if (this.modeSwitcherFuture != null) {
            this.cancellationHandle.cancel();
            try {
                this.modeSwitcherFuture.get();
            }
            catch (InconsistentlyUpgradedClusterException | UnableToCopyStoreFromOldMasterException | UnavailableMembersException e) {
                throw e;
            }
            catch (Exception e) {
                this.msgLog.warn("Got exception from cancelled task", (Throwable)e);
            }
        }
        this.cancellationHandle = cancellationHandle;
        this.modeSwitcherFuture = this.modeSwitcherExecutor.submit(switcher);
    }

    private StoreId resolveStoreId() {
        return (StoreId)this.dependencyResolver.resolveDependency(StoreId.class);
    }

    private static class CancellationHandle
    implements CancellationRequest {
        private volatile boolean cancelled = false;

        private CancellationHandle() {
        }

        public boolean cancellationRequested() {
            return this.cancelled;
        }

        public void cancel() {
            assert (!this.cancelled) : "Should not cancel on the same request twice";
            this.cancelled = true;
        }
    }
}

