/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.net.URI;
import org.neo4j.helpers.Factory;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.cluster.AbstractModeSwitcher;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.SlaveLockManager;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;

public class LockManagerModeSwitcher
extends AbstractModeSwitcher<Locks> {
    private final HaXaDataSourceManager xaDsm;
    private final DelegateInvocationHandler<Master> master;
    private final RequestContextFactory requestContextFactory;
    private final AbstractTransactionManager txManager;
    private final RemoteTxHook remoteTxHook;
    private final AvailabilityGuard availabilityGuard;
    private final Config config;
    private final Factory<Locks> locksFactory;

    public LockManagerModeSwitcher(HighAvailabilityMemberStateMachine stateMachine, DelegateInvocationHandler<Locks> delegate, HaXaDataSourceManager xaDsm, DelegateInvocationHandler<Master> master, RequestContextFactory requestContextFactory, AbstractTransactionManager txManager, RemoteTxHook remoteTxHook, AvailabilityGuard availabilityGuard, Config config, Factory<Locks> locksFactory) {
        super(stateMachine, delegate);
        this.xaDsm = xaDsm;
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.txManager = txManager;
        this.remoteTxHook = remoteTxHook;
        this.availabilityGuard = availabilityGuard;
        this.config = config;
        this.locksFactory = locksFactory;
    }

    @Override
    protected Locks getMasterImpl() {
        return (Locks)this.locksFactory.newInstance();
    }

    @Override
    protected Locks getSlaveImpl(URI serverHaUri) {
        return new SlaveLockManager((Locks)this.locksFactory.newInstance(), this.requestContextFactory, this.master.cement(), this.xaDsm, this.txManager, this.remoteTxHook, this.availabilityGuard, new SlaveLockManager.Configuration(){

            @Override
            public long getAvailabilityTimeout() {
                return (Long)LockManagerModeSwitcher.this.config.get(HaSettings.lock_read_timeout);
            }
        });
    }
}

