/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.upgrade;

import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.com.Server;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.MasterClient214;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.impl.nioneo.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.CleanupRule;

public class MasterClientTest {
    private static final String MASTER_SERVER_HOST = "localhost";
    private static final int MASTER_SERVER_PORT = 9191;
    private static final int CHUNK_SIZE = 1024;
    private static final int TIMEOUT = 2000;
    @Rule
    public final CleanupRule cleanupRule = new CleanupRule();

    @Test(expected=MismatchingStoreIdException.class)
    public void newClientsShouldNotIgnoreStoreIdDifferences() throws Throwable {
        MasterImpl.SPI masterImplSPI = (MasterImpl.SPI)Mockito.mock(MasterImpl.SPI.class);
        Mockito.when((Object)masterImplSPI.storeId()).thenReturn((Object)new StoreId(1L, 2L, 3L, 4L));
        Mockito.when((Object)masterImplSPI.getMasterIdForCommittedTx(Matchers.anyLong())).thenReturn((Object)Pair.of((Object)1, (Object)5L));
        MasterServer masterServer = (MasterServer)this.cleanupRule.add((Object)MasterClientTest.newMasterServer(masterImplSPI));
        masterServer.init();
        masterServer.start();
        StoreId storeId = new StoreId(5L, 6L, 7L, 8L);
        MasterClient214 masterClient214 = (MasterClient214)this.cleanupRule.add((Object)MasterClientTest.newMasterClient214(storeId));
        masterClient214.init();
        masterClient214.start();
        masterClient214.handshake(1L, storeId);
    }

    private static MasterServer newMasterServer(MasterImpl.SPI masterImplSPI) {
        MasterImpl master = new MasterImpl(masterImplSPI, (MasterImpl.Monitor)Mockito.mock(MasterImpl.Monitor.class), (Logging)Mockito.mock(Logging.class), MasterClientTest.masterConfig());
        return new MasterServer((Master)master, (Logging)Mockito.mock(Logging.class, (Answer)Mockito.RETURNS_MOCKS), MasterClientTest.masterServerConfiguration(), (TxChecksumVerifier)Mockito.mock(TxChecksumVerifier.class), new Monitors());
    }

    private static MasterClient214 newMasterClient214(StoreId storeId) {
        return new MasterClient214(MASTER_SERVER_HOST, 9191, (Logging)Mockito.mock(Logging.class, (Answer)Mockito.RETURNS_MOCKS), new Monitors(), storeId, 2000L, 2000L, 1, 1024);
    }

    private static Config masterConfig() {
        return new Config(MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "1"}));
    }

    private static Server.Configuration masterServerConfiguration() {
        return new Server.Configuration(){

            public long getOldChannelThreshold() {
                return -1L;
            }

            public int getMaxConcurrentTransactions() {
                return 1;
            }

            public int getChunkSize() {
                return 1024;
            }

            public HostnamePort getServerAddress() {
                return new HostnamePort(MasterClientTest.MASTER_SERVER_HOST, 9191);
            }
        };
    }
}

