/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.metrics.ByteCounterMetrics;
import org.neo4j.metrics.CSVFile;

public class MetricsLogExtension
implements Lifecycle {
    private Monitors monitors;
    private Config config;
    private FileSystemAbstraction fileSystemAbstraction;
    private TxManager txManager;
    private ByteCounterMetrics networkCounterMetrics;
    private ByteCounterMetrics diskCounterMetrics;
    private ScheduledExecutorService executor;
    private CSVFile csv;

    public MetricsLogExtension(Monitors monitors, Config config, FileSystemAbstraction fileSystemAbstraction, TxManager txManager) {
        this.monitors = monitors;
        this.config = config;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.txManager = txManager;
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
        this.networkCounterMetrics = new ByteCounterMetrics();
        this.monitors.addMonitorListener((Object)this.networkCounterMetrics, new String[]{MasterServer.class.getName()});
        this.monitors.addMonitorListener((Object)this.networkCounterMetrics, new String[]{"logdeserializer"});
        this.diskCounterMetrics = new ByteCounterMetrics();
        this.monitors.addMonitorListener((Object)this.diskCounterMetrics, new String[]{XaLogicalLog.class.getName()});
        File path = new File((File)this.config.get(GraphDatabaseSettings.store_dir), "metrics.txt");
        System.out.println("CSV:" + path);
        OutputStream file = this.fileSystemAbstraction.openAsOutputStream(path, false);
        this.csv = new CSVFile(file, Iterables.iterable((Object[])new String[]{"timestamp", "diskWritten", "diskRead", "networkWritten", "networkRead", "committedTx"}));
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    MetricsLogExtension.this.csv.print(System.currentTimeMillis(), MetricsLogExtension.this.diskCounterMetrics.getBytesWritten(), MetricsLogExtension.this.diskCounterMetrics.getBytesRead(), MetricsLogExtension.this.networkCounterMetrics.getBytesWritten(), MetricsLogExtension.this.networkCounterMetrics.getBytesRead(), MetricsLogExtension.this.txManager.getCommittedTxCount());
                    System.out.println(MetricsLogExtension.this.config.get(ClusterSettings.server_id) + " bytes written:" + MetricsLogExtension.this.networkCounterMetrics.getBytesWritten());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void stop() throws Throwable {
        this.executor.shutdown();
        if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
            this.executor.shutdownNow();
        }
        this.csv.close();
        this.monitors.removeMonitorListener((Object)this.networkCounterMetrics);
    }

    public void shutdown() throws Throwable {
    }
}

