/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.TimeUnit;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.com.ComException;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.util.CappedOperation;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class UpdatePuller
implements Lifecycle {
    private final HighAvailabilityMemberStateMachine memberStateMachine;
    private final HaXaDataSourceManager xaDataSourceManager;
    private final Master master;
    private final RequestContextFactory requestContextFactory;
    private final AbstractTransactionManager txManager;
    private final AvailabilityGuard availabilityGuard;
    private final LastUpdateTime lastUpdateTime;
    private final Config config;
    private final JobScheduler scheduler;
    private final StringLogger logger;
    private final CappedOperation<Pair<String, ? extends Exception>> cappedLogger;
    private volatile boolean pullUpdates = false;
    private final UpdatePullerHighAvailabilityMemberListener listener;

    public UpdatePuller(HighAvailabilityMemberStateMachine memberStateMachine, HaXaDataSourceManager xaDataSourceManager, Master master, RequestContextFactory requestContextFactory, AbstractTransactionManager txManager, AvailabilityGuard availabilityGuard, LastUpdateTime lastUpdateTime, Config config, JobScheduler scheduler, final StringLogger logger) {
        this.memberStateMachine = memberStateMachine;
        this.xaDataSourceManager = xaDataSourceManager;
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.txManager = txManager;
        this.availabilityGuard = availabilityGuard;
        this.lastUpdateTime = lastUpdateTime;
        this.config = config;
        this.scheduler = scheduler;
        this.logger = logger;
        this.cappedLogger = new CappedOperation<Pair<String, ? extends Exception>>(new CappedOperation.Switch[]{CappedOperation.count((long)10L)}){

            protected void triggered(Pair<String, ? extends Exception> event) {
                logger.warn((String)event.first(), (Throwable)event.other());
            }
        };
        this.listener = new UpdatePullerHighAvailabilityMemberListener((InstanceId)config.get(ClusterSettings.server_id));
    }

    public void pullUpdates() {
        if (this.availabilityGuard.isAvailable(5000L)) {
            this.xaDataSourceManager.applyTransactions(this.master.pullUpdates(this.requestContextFactory.newRequestContext(this.txManager.getEventIdentifier())));
        }
        this.lastUpdateTime.setLastUpdateTime(System.currentTimeMillis());
    }

    public void init() throws Throwable {
        long pullInterval = (Long)this.config.get(HaSettings.pull_interval);
        if (pullInterval > 0L) {
            this.scheduler.scheduleRecurring(JobScheduler.Group.pullUpdates, new Runnable(){

                @Override
                public void run() {
                    if (!UpdatePuller.this.pullUpdates) {
                        return;
                    }
                    try {
                        UpdatePuller.this.pullUpdates();
                    }
                    catch (ComException e) {
                        UpdatePuller.this.cappedLogger.event((Object)Pair.of((Object)"Pull updates failed due to network error.", (Object)((Object)e)));
                    }
                    catch (Exception e) {
                        UpdatePuller.this.logger.logMessage("Pull updates failed", (Throwable)e);
                    }
                }
            }, pullInterval, pullInterval, TimeUnit.MILLISECONDS);
        }
        this.pullUpdates = false;
    }

    public void start() throws Throwable {
        this.pullUpdates = true;
        this.memberStateMachine.addHighAvailabilityMemberListener(this.listener);
    }

    public void stop() throws Throwable {
        this.pullUpdates = false;
        this.memberStateMachine.removeHighAvailabilityMemberListener(this.listener);
    }

    public void shutdown() throws Throwable {
    }

    private class UpdatePullerHighAvailabilityMemberListener
    extends HighAvailabilityMemberListener.Adapter {
        private final InstanceId myInstanceId;

        private UpdatePullerHighAvailabilityMemberListener(InstanceId myInstanceId) {
            this.myInstanceId = myInstanceId;
        }

        @Override
        public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
            if (event.getInstanceId().equals((Object)this.myInstanceId)) {
                UpdatePuller.this.pullUpdates = false;
            }
        }

        @Override
        public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
            if (event.getInstanceId().equals((Object)this.myInstanceId)) {
                UpdatePuller.this.pullUpdates = true;
            }
        }
    }
}

