/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.cluster.util.Quorums;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.cluster.HighAvailability;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class HighAvailabilityMemberStateMachine
extends LifecycleAdapter
implements HighAvailability,
AvailabilityGuard.AvailabilityRequirement {
    private final HighAvailabilityMemberContext context;
    private final AvailabilityGuard availabilityGuard;
    private final ClusterMemberEvents events;
    private StringLogger logger;
    private Iterable<HighAvailabilityMemberListener> memberListeners = Listeners.newListeners();
    private volatile HighAvailabilityMemberState state;
    private StateMachineClusterEventListener eventsListener;
    private final ClusterMembers members;
    private final Election election;

    public HighAvailabilityMemberStateMachine(HighAvailabilityMemberContext context, AvailabilityGuard availabilityGuard, ClusterMembers members, ClusterMemberEvents events, Election election, StringLogger logger) {
        this.context = context;
        this.availabilityGuard = availabilityGuard;
        this.members = members;
        this.events = events;
        this.election = election;
        this.logger = logger;
        this.state = HighAvailabilityMemberState.PENDING;
    }

    public void init() throws Throwable {
        this.eventsListener = new StateMachineClusterEventListener();
        this.events.addClusterMemberListener((ClusterMemberListener)this.eventsListener);
        this.availabilityGuard.deny((AvailabilityGuard.AvailabilityRequirement)this);
    }

    public void stop() throws Throwable {
        this.events.removeClusterMemberListener((ClusterMemberListener)this.eventsListener);
        HighAvailabilityMemberState oldState = this.state;
        this.state = HighAvailabilityMemberState.PENDING;
        final HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(oldState, this.state, null, null);
        Listeners.notifyListeners(this.memberListeners, (Listeners.Notification)new Listeners.Notification<HighAvailabilityMemberListener>(){

            public void notify(HighAvailabilityMemberListener listener) {
                listener.instanceStops(event);
            }
        });
        if (oldState.isAccessAllowed()) {
            this.availabilityGuard.deny((AvailabilityGuard.AvailabilityRequirement)this);
        }
        this.context.setAvailableHaMasterId(null);
    }

    @Override
    public void addHighAvailabilityMemberListener(HighAvailabilityMemberListener toAdd) {
        this.memberListeners = Listeners.addListener((Object)toAdd, this.memberListeners);
    }

    @Override
    public void removeHighAvailabilityMemberListener(HighAvailabilityMemberListener toRemove) {
        this.memberListeners = Listeners.removeListener((Object)toRemove, this.memberListeners);
    }

    public HighAvailabilityMemberState getCurrentState() {
        return this.state;
    }

    public String description() {
        return "Cluster state is '" + (Object)((Object)this.getCurrentState()) + "'";
    }

    private class StateMachineClusterEventListener
    extends ClusterMemberListener.Adapter {
        private StateMachineClusterEventListener() {
        }

        public synchronized void coordinatorIsElected(InstanceId coordinatorId) {
            try {
                HighAvailabilityMemberState oldState = HighAvailabilityMemberStateMachine.this.state;
                InstanceId previousElected = HighAvailabilityMemberStateMachine.this.context.getElectedMasterId();
                HighAvailabilityMemberStateMachine.this.state = HighAvailabilityMemberStateMachine.this.state.masterIsElected(HighAvailabilityMemberStateMachine.this.context, coordinatorId);
                HighAvailabilityMemberStateMachine.this.context.setElectedMasterId(coordinatorId);
                final HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(oldState, HighAvailabilityMemberStateMachine.this.state, coordinatorId, null);
                Listeners.notifyListeners((Iterable)HighAvailabilityMemberStateMachine.this.memberListeners, (Listeners.Notification)new Listeners.Notification<HighAvailabilityMemberListener>(){

                    public void notify(HighAvailabilityMemberListener listener) {
                        listener.masterIsElected(event);
                    }
                });
                HighAvailabilityMemberStateMachine.this.context.setAvailableHaMasterId(null);
                if (oldState.isAccessAllowed() && oldState != HighAvailabilityMemberStateMachine.this.state) {
                    HighAvailabilityMemberStateMachine.this.availabilityGuard.deny((AvailabilityGuard.AvailabilityRequirement)HighAvailabilityMemberStateMachine.this);
                }
                HighAvailabilityMemberStateMachine.this.logger.debug("Got masterIsElected(" + coordinatorId + "), changed " + (Object)((Object)oldState) + " -> " + (Object)((Object)HighAvailabilityMemberStateMachine.this.state) + ". Previous elected master is " + previousElected);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public synchronized void memberIsAvailable(String role, InstanceId instanceId, URI roleUri, StoreId storeId) {
            try {
                if (role.equals("master")) {
                    HighAvailabilityMemberState oldState = HighAvailabilityMemberStateMachine.this.state;
                    HighAvailabilityMemberStateMachine.this.context.setAvailableHaMasterId(roleUri);
                    HighAvailabilityMemberStateMachine.this.state = HighAvailabilityMemberStateMachine.this.state.masterIsAvailable(HighAvailabilityMemberStateMachine.this.context, instanceId, roleUri);
                    HighAvailabilityMemberStateMachine.this.logger.debug("Got masterIsAvailable(" + instanceId + "), moved to " + (Object)((Object)HighAvailabilityMemberStateMachine.this.state) + " from " + (Object)((Object)oldState));
                    final HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(oldState, HighAvailabilityMemberStateMachine.this.state, instanceId, roleUri);
                    Listeners.notifyListeners((Iterable)HighAvailabilityMemberStateMachine.this.memberListeners, (Listeners.Notification)new Listeners.Notification<HighAvailabilityMemberListener>(){

                        public void notify(HighAvailabilityMemberListener listener) {
                            listener.masterIsAvailable(event);
                        }
                    });
                    if (oldState == HighAvailabilityMemberState.TO_MASTER && HighAvailabilityMemberStateMachine.this.state == HighAvailabilityMemberState.MASTER) {
                        HighAvailabilityMemberStateMachine.this.availabilityGuard.grant((AvailabilityGuard.AvailabilityRequirement)HighAvailabilityMemberStateMachine.this);
                    }
                } else if (role.equals("slave")) {
                    HighAvailabilityMemberState oldState = HighAvailabilityMemberStateMachine.this.state;
                    HighAvailabilityMemberStateMachine.this.state = HighAvailabilityMemberStateMachine.this.state.slaveIsAvailable(HighAvailabilityMemberStateMachine.this.context, instanceId, roleUri);
                    HighAvailabilityMemberStateMachine.this.logger.debug("Got slaveIsAvailable(" + instanceId + "), " + "moved to " + (Object)((Object)HighAvailabilityMemberStateMachine.this.state) + " from " + (Object)((Object)oldState));
                    final HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(oldState, HighAvailabilityMemberStateMachine.this.state, instanceId, roleUri);
                    Listeners.notifyListeners((Iterable)HighAvailabilityMemberStateMachine.this.memberListeners, (Listeners.Notification)new Listeners.Notification<HighAvailabilityMemberListener>(){

                        public void notify(HighAvailabilityMemberListener listener) {
                            listener.slaveIsAvailable(event);
                        }
                    });
                    if (oldState == HighAvailabilityMemberState.TO_SLAVE && HighAvailabilityMemberStateMachine.this.state == HighAvailabilityMemberState.SLAVE) {
                        HighAvailabilityMemberStateMachine.this.availabilityGuard.grant((AvailabilityGuard.AvailabilityRequirement)HighAvailabilityMemberStateMachine.this);
                    }
                }
            }
            catch (Throwable throwable) {
                HighAvailabilityMemberStateMachine.this.logger.warn("Exception while receiving member availability notification", throwable);
            }
        }

        public void memberIsFailed(InstanceId instanceId) {
            if (!Quorums.isQuorum((long)this.getAliveCount(), (long)this.getTotalCount())) {
                try {
                    if (HighAvailabilityMemberStateMachine.this.state.isAccessAllowed()) {
                        HighAvailabilityMemberStateMachine.this.availabilityGuard.deny((AvailabilityGuard.AvailabilityRequirement)HighAvailabilityMemberStateMachine.this);
                    }
                    final HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberStateMachine.this.state, HighAvailabilityMemberState.PENDING, null, null);
                    HighAvailabilityMemberStateMachine.this.state = HighAvailabilityMemberState.PENDING;
                    Listeners.notifyListeners((Iterable)HighAvailabilityMemberStateMachine.this.memberListeners, (Listeners.Notification)new Listeners.Notification<HighAvailabilityMemberListener>(){

                        public void notify(HighAvailabilityMemberListener listener) {
                            listener.instanceStops(event);
                        }
                    });
                    HighAvailabilityMemberStateMachine.this.context.setAvailableHaMasterId(null);
                    HighAvailabilityMemberStateMachine.this.context.setElectedMasterId(null);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }

        public void memberIsAlive(InstanceId instanceId) {
            if (Quorums.isQuorum((long)this.getAliveCount(), (long)this.getTotalCount()) && HighAvailabilityMemberStateMachine.this.state.equals((Object)HighAvailabilityMemberState.PENDING)) {
                HighAvailabilityMemberStateMachine.this.election.performRoleElections();
            }
        }

        private long getAliveCount() {
            return Iterables.count((Iterable)Iterables.filter(ClusterMembers.ALIVE, HighAvailabilityMemberStateMachine.this.members.getMembers()));
        }

        private long getTotalCount() {
            return Iterables.count(HighAvailabilityMemberStateMachine.this.members.getMembers());
        }
    }
}

