/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;

public class ClusterMembers {
    public static final Predicate<ClusterMember> ALIVE = new Predicate<ClusterMember>(){

        public boolean accept(ClusterMember item) {
            return item.isAlive();
        }
    };
    private final InstanceId me;
    private final Map<InstanceId, ClusterMember> members = new CopyOnWriteHashMap();

    public static Predicate<ClusterMember> inRole(final String role) {
        return new Predicate<ClusterMember>(){

            public boolean accept(ClusterMember item) {
                return item.hasRole(role);
            }
        };
    }

    public ClusterMembers(Cluster cluster, Heartbeat heartbeat, ClusterMemberEvents events, InstanceId me) {
        this.me = me;
        cluster.addClusterListener((ClusterListener)new HAMClusterListener());
        heartbeat.addHeartbeatListener((HeartbeatListener)new HAMHeartbeatListener());
        events.addClusterMemberListener((ClusterMemberListener)new HAMClusterMemberListener());
    }

    public Iterable<ClusterMember> getMembers() {
        return this.members.values();
    }

    public ClusterMember getSelf() {
        for (ClusterMember clusterMember : this.getMembers()) {
            if (!clusterMember.getInstanceId().equals((Object)this.me)) continue;
            return clusterMember;
        }
        return null;
    }

    public synchronized void waitForEvent(long timeout) throws InterruptedException {
        this.wait(timeout);
    }

    private synchronized void eventOccurred() {
        this.notifyAll();
    }

    private ClusterMember getMember(InstanceId server) {
        ClusterMember clusterMember = this.members.get(server);
        if (clusterMember == null) {
            throw new IllegalStateException("Member " + server + " not found in " + new HashMap<InstanceId, ClusterMember>(this.members));
        }
        return clusterMember;
    }

    private class HAMHeartbeatListener
    extends HeartbeatListener.Adapter {
        private HAMHeartbeatListener() {
        }

        public void failed(InstanceId server) {
            if (ClusterMembers.this.members.containsKey(server)) {
                ClusterMembers.this.members.put(server, ClusterMembers.this.getMember(server).failed());
            }
        }

        public void alive(InstanceId server) {
            if (ClusterMembers.this.members.containsKey(server)) {
                ClusterMembers.this.members.put(server, ClusterMembers.this.getMember(server).alive());
            }
        }
    }

    private class HAMClusterMemberListener
    extends ClusterMemberListener.Adapter {
        private InstanceId masterId = null;

        private HAMClusterMemberListener() {
        }

        public void coordinatorIsElected(InstanceId coordinatorId) {
            if (coordinatorId.equals((Object)this.masterId)) {
                return;
            }
            this.masterId = coordinatorId;
            HashMap newMembers = new HashMap();
            for (Map.Entry memberEntry : ClusterMembers.this.members.entrySet()) {
                newMembers.put(memberEntry.getKey(), ((ClusterMember)memberEntry.getValue()).unavailableAs("master").unavailableAs("slave"));
            }
            ClusterMembers.this.members.clear();
            ClusterMembers.this.members.putAll(newMembers);
        }

        public void memberIsAvailable(String role, InstanceId instanceId, URI roleUri, StoreId storeId) {
            ClusterMembers.this.members.put(instanceId, ClusterMembers.this.getMember(instanceId).availableAs(role, roleUri, storeId));
            ClusterMembers.this.eventOccurred();
        }

        public void memberIsUnavailable(String role, InstanceId unavailableId) {
            try {
                ClusterMember member = ClusterMembers.this.getMember(unavailableId);
                ClusterMembers.this.members.put(unavailableId, member.unavailableAs(role));
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }

        public void memberIsFailed(InstanceId instanceId) {
            ClusterMember member = ClusterMembers.this.getMember(instanceId);
            for (String role : member.getRoles()) {
                member = member.unavailableAs(role);
            }
            ClusterMembers.this.members.put(instanceId, member);
        }
    }

    private class HAMClusterListener
    extends ClusterListener.Adapter {
        private HAMClusterListener() {
        }

        public void enteredCluster(ClusterConfiguration configuration) {
            HashMap<InstanceId, ClusterMember> newMembers = new HashMap<InstanceId, ClusterMember>();
            for (InstanceId memberClusterId : configuration.getMemberIds()) {
                newMembers.put(memberClusterId, new ClusterMember(memberClusterId, true));
            }
            ClusterMembers.this.members.clear();
            ClusterMembers.this.members.putAll(newMembers);
        }

        public void leftCluster() {
            ClusterMembers.this.members.clear();
        }

        public void joinedCluster(InstanceId member, URI memberUri) {
            ClusterMembers.this.members.put(member, new ClusterMember(member));
        }

        public void leftCluster(InstanceId instanceId, URI member) {
            ClusterMembers.this.members.remove(instanceId);
        }
    }
}

