/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.cluster.InstanceId;
import org.neo4j.com.Client;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.TargetCaller;
import org.neo4j.helpers.Functions;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class SlaveClient
extends Client<Slave>
implements Slave {
    private final InstanceId machineId;

    public SlaveClient(InstanceId machineId, String hostNameOrIp, int port, Logging logging, Monitors monitors, StoreId storeId, int maxConcurrentChannels, int chunkSize) {
        super(hostNameOrIp, port, logging, monitors, storeId, 0x1000000, new ProtocolVersion(1, 2), ((Long)HaSettings.read_timeout.apply((Object)Functions.nullFunction())).longValue(), maxConcurrentChannels, chunkSize);
        this.machineId = machineId;
    }

    @Override
    public Response<Void> pullUpdates(final String resource, final long upToAndIncludingTxId) {
        return this.sendRequest(SlaveRequestType.PULL_UPDATES, RequestContext.EMPTY, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)resource);
                buffer.writeLong(upToAndIncludingTxId);
            }
        }, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public int getServerId() {
        return this.machineId.toIntegerIndex();
    }

    public static enum SlaveRequestType implements RequestType<Slave>
    {
        PULL_UPDATES((TargetCaller)new TargetCaller<Slave, Void>(){

            public Response<Void> call(Slave master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.pullUpdates(Protocol.readString((ChannelBuffer)input), input.readLong());
            }
        }, Protocol.VOID_SERIALIZER);

        private final TargetCaller caller;
        private final ObjectSerializer serializer;

        private SlaveRequestType(TargetCaller caller, ObjectSerializer serializer) {
            this.caller = caller;
            this.serializer = serializer;
        }

        public TargetCaller getTargetCaller() {
            return this.caller;
        }

        public ObjectSerializer getObjectSerializer() {
            return this.serializer;
        }

        public byte id() {
            return (byte)this.ordinal();
        }
    }
}

