/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.slave;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.com.MismatchingVersionHandler;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.kernel.ha.MasterClient201;
import org.neo4j.kernel.ha.MasterClient210;
import org.neo4j.kernel.ha.MasterClient214;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class MasterClientResolver
implements MasterClientFactory,
MismatchingVersionHandler {
    private volatile MasterClientFactory currentFactory;
    private final Map<ProtocolVersion, MasterClientFactory> protocolToFactoryMapping = new HashMap<ProtocolVersion, MasterClientFactory>();

    @Override
    public MasterClient instantiate(String hostNameOrIp, int port, Monitors monitors, StoreId storeId) {
        if (this.currentFactory == null) {
            this.assignDefaultFactory();
        }
        MasterClient result = this.currentFactory.instantiate(hostNameOrIp, port, monitors, storeId);
        result.addMismatchingVersionHandler(this);
        return result;
    }

    public void versionMismatched(byte expected, byte received) {
        this.getFor(new ProtocolVersion(received, 2));
    }

    public MasterClientResolver(Logging logging, int readTimeout, int lockReadTimeout, int channels, int chunkSize) {
        this.protocolToFactoryMapping.put(MasterClient201.PROTOCOL_VERSION, new F201(logging, readTimeout, lockReadTimeout, channels, chunkSize));
        this.protocolToFactoryMapping.put(MasterClient210.PROTOCOL_VERSION, new F210(logging, readTimeout, lockReadTimeout, channels, chunkSize));
        this.protocolToFactoryMapping.put(MasterClient214.PROTOCOL_VERSION, new F214(logging, readTimeout, lockReadTimeout, channels, chunkSize));
    }

    private MasterClientFactory getFor(ProtocolVersion protocolVersion) {
        MasterClientFactory candidate = this.protocolToFactoryMapping.get(protocolVersion);
        if (candidate != null) {
            this.currentFactory = candidate;
        }
        return candidate;
    }

    private MasterClientFactory assignDefaultFactory() {
        return this.getFor(MasterClient214.PROTOCOL_VERSION);
    }

    private static final class F214
    extends StaticMasterClientFactory {
        public F214(Logging logging, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(logging, readTimeoutSeconds, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String hostNameOrIp, int port, Monitors monitors, StoreId storeId) {
            return new MasterClient214(hostNameOrIp, port, this.logging, monitors, storeId, this.readTimeoutSeconds, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize);
        }
    }

    private static final class F210
    extends StaticMasterClientFactory {
        public F210(Logging logging, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(logging, readTimeoutSeconds, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String hostNameOrIp, int port, Monitors monitors, StoreId storeId) {
            return new MasterClient210(hostNameOrIp, port, this.logging, monitors, storeId, this.readTimeoutSeconds, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize);
        }
    }

    private static final class F201
    extends StaticMasterClientFactory {
        public F201(Logging logging, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(logging, readTimeoutSeconds, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String hostNameOrIp, int port, Monitors monitors, StoreId storeId) {
            return new MasterClient201(hostNameOrIp, port, this.logging, monitors, storeId, this.readTimeoutSeconds, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize);
        }
    }

    private static abstract class StaticMasterClientFactory
    implements MasterClientFactory {
        protected final Logging logging;
        protected final int readTimeoutSeconds;
        protected final int lockReadTimeout;
        protected final int maxConcurrentChannels;
        protected final int chunkSize;

        StaticMasterClientFactory(Logging logging, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            this.logging = logging;
            this.readTimeoutSeconds = readTimeoutSeconds;
            this.lockReadTimeout = lockReadTimeout;
            this.maxConcurrentChannels = maxConcurrentChannels;
            this.chunkSize = chunkSize;
        }
    }
}

