/**
 * Copyright (c) 2002-2015 "Neo Technology,"
 * Network Engine for Objects in Lund AB [http://neotechnology.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.kernel.ha.lock.forseti;

import org.junit.Test;

import static junit.framework.Assert.assertTrue;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.mockito.Mockito.mock;

public class SharedLockTest
{
    @Test
    public void shouldUpgradeToUpdateLock() throws Exception
    {
        // Given
        ForsetiClient clientA = mock(ForsetiClient.class);
        ForsetiClient clientB = mock(ForsetiClient.class);

        SharedLock lock = new SharedLock( clientA );
        lock.acquire( clientB );

        // When
        assertTrue( lock.tryAcquireUpdateLock( clientA ) );

        // Then
        assertThat( lock.numberOfHolders(), equalTo(2));
        assertThat( lock.isUpdateLock(), equalTo(true));
    }

    @Test
    public void shouldReleaseSharedLock() throws Exception
    {
        // Given
        ForsetiClient clientA = mock(ForsetiClient.class);
        SharedLock lock = new SharedLock( clientA );

        // When
        assertTrue( lock.release( clientA ) );

        // Then
        assertThat( lock.numberOfHolders(), equalTo( 0 ) );
        assertThat( lock.isUpdateLock(), equalTo(false));
    }

}
