/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class HaCacheIT {
    private static final int DENSE_NODE = 10;
    @Rule
    public final TargetDirectory.TestDirectory root = TargetDirectory.forTest(this.getClass()).testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUpdateSlaveCacheWhenRemovingRelationshipGroupFromDenseNode() throws Throwable {
        ClusterManager manager = new ClusterManager(ClusterManager.clusterOfSize(3), this.root.directory(), MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2", GraphDatabaseSettings.cache_type.name(), "strong", GraphDatabaseSettings.dense_node_threshold.name(), "10"}));
        try {
            long nodeId;
            manager.start();
            ClusterManager.ManagedCluster cluster = manager.getDefaultCluster();
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            cluster.await(ClusterManager.masterSeesAllSlavesAsAvailable());
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            try (Transaction tx = master.beginTx();){
                Node node = master.createNode();
                for (int i = 0; i < 10; ++i) {
                    node.createRelationshipTo(master.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"FOO"));
                }
                master.createNode().createRelationshipTo(node, (RelationshipType)DynamicRelationshipType.withName((String)"BAR"));
                tx.success();
                nodeId = node.getId();
            }
            int count = 0;
            for (HighlyAvailableGraphDatabase highlyAvailableGraphDatabase : cluster.getAllMembers()) {
                Transaction tx = highlyAvailableGraphDatabase.beginTx();
                Throwable throwable = null;
                try {
                    int these = IteratorUtil.count((Iterable)highlyAvailableGraphDatabase.getNodeById(nodeId).getRelationships());
                    Assert.assertTrue((String)String.format("expected=%s, count here=%s", count, these), (these != 0 && (count == 0 || these == count) ? 1 : 0) != 0);
                    count = these;
                    tx.success();
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            Throwable throwable = null;
            try (Transaction tx = master.beginTx();){
                for (Relationship relationship : master.getNodeById(nodeId).getRelationships(new RelationshipType[]{DynamicRelationshipType.withName((String)"BAR")})) {
                    relationship.delete();
                }
                tx.success();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            try (Transaction transaction = slave.beginTx();){
                ArrayList<String> relationships = new ArrayList<String>();
                for (Relationship relationship : slave.getNodeById(nodeId).getRelationships()) {
                    relationships.add(String.format("(%d)-[%d:%s]->(%d)", relationship.getStartNode().getId(), relationship.getId(), relationship.getType().name(), relationship.getEndNode().getId()));
                }
                Assert.assertEquals((String)this.joinLines(relationships), (long)(count - 1), (long)relationships.size());
                Assert.assertEquals((long)(count - 1), (long)IteratorUtil.count((Iterable)slave.getNodeById(nodeId).getRelationships()));
                transaction.success();
            }
        }
        finally {
            manager.shutdown();
        }
    }

    private String joinLines(Iterable<String> lines) {
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            result.append("\n\t").append(line);
        }
        return result.toString();
    }
}

