/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.AbstractClusterTest;
import org.neo4j.test.ha.ClusterManager;
import org.neo4j.tooling.GlobalGraphOperations;

public class BiggerThanLogTxIT
extends AbstractClusterTest {
    private static final String ROTATION_THRESHOLD = "1M";

    @Test
    public void shouldHandleSlaveCommittingLargeTx() throws Exception {
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        int initialNodeCount = this.nodeCount((GraphDatabaseService)slave);
        int nodeCount = this.commitLargeTx((GraphDatabaseService)slave);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertAllMembersHasNodeCount(initialNodeCount + nodeCount);
        this.commitSmallTx((GraphDatabaseService)this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertAllMembersHasNodeCount(initialNodeCount + nodeCount + 1);
    }

    @Test
    public void shouldHandleMasterCommittingLargeTx() throws Exception {
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        int initialNodeCount = this.nodeCount((GraphDatabaseService)slave);
        int nodeCount = this.commitLargeTx((GraphDatabaseService)this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertAllMembersHasNodeCount(initialNodeCount + nodeCount);
        this.commitSmallTx((GraphDatabaseService)this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertAllMembersHasNodeCount(initialNodeCount + nodeCount + 1);
    }

    @Override
    protected void configureClusterMember(GraphDatabaseBuilder builder, String clusterName, InstanceId serverId) {
        builder.setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, ROTATION_THRESHOLD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitSmallTx(GraphDatabaseService db) {
        Transaction tx = db.beginTx();
        try {
            db.createNode();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private int nodeCount(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            int count = IteratorUtil.count((Iterable)GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes());
            tx.success();
            int n = count;
            return n;
        }
    }

    private void assertAllMembersHasNodeCount(int expectedNodeCount) {
        for (GraphDatabaseService graphDatabaseService : this.cluster.getAllMembers()) {
            Assert.assertEquals((long)expectedNodeCount, (long)this.nodeCount(graphDatabaseService));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int commitLargeTx(GraphDatabaseService db) {
        long rotationThreshold = Config.parseLongWithUnit((String)ROTATION_THRESHOLD);
        int nodeCount = 100;
        byte[] arrayProperty = new byte[(int)(rotationThreshold / (long)nodeCount)];
        Transaction tx = db.beginTx();
        try {
            for (int i = 0; i < nodeCount; ++i) {
                Node node = db.createNode();
                node.setProperty("name", (Object)("big" + i));
                node.setProperty("data", (Object)arrayProperty);
            }
            tx.success();
            int n = nodeCount;
            return n;
        }
        finally {
            tx.finish();
        }
    }
}

