/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.test.AbstractClusterTest;
import org.neo4j.test.ha.ClusterManager;

public class TestUniqueKeys
extends AbstractClusterTest {
    private ClusterManager.ManagedCluster cluster;

    @Test
    public void bruteForceCreateSameRelationshipTypeOnDifferentSlaveAtTheSameTimeShouldYieldSameId() throws Exception {
        int i;
        ArrayList<HighlyAvailableGraphDatabase> slaves = new ArrayList<HighlyAvailableGraphDatabase>();
        for (i = 0; i < this.cluster.size() - 1; ++i) {
            slaves.add(this.cluster.getAnySlave(slaves.toArray(new HighlyAvailableGraphDatabase[0])));
        }
        for (i = 0; i < 10; ++i) {
            DynamicRelationshipType relType = DynamicRelationshipType.withName((String)("Rel" + i));
            final CountDownLatch latch = new CountDownLatch(1);
            ArrayList<1> threads = new ArrayList<1>();
            Iterator i$ = slaves.iterator();
            while (i$.hasNext()) {
                HighlyAvailableGraphDatabase highlyAvailableGraphDatabase;
                HighlyAvailableGraphDatabase db = highlyAvailableGraphDatabase = (HighlyAvailableGraphDatabase)i$.next();
                Thread thread = new Thread((GraphDatabaseAPI)db, (RelationshipType)relType){
                    final /* synthetic */ GraphDatabaseAPI val$db;
                    final /* synthetic */ RelationshipType val$relType;
                    {
                        this.val$db = graphDatabaseAPI;
                        this.val$relType = relationshipType;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        Transaction tx = this.val$db.beginTx();
                        try {
                            this.val$db.createNode().createRelationshipTo(this.val$db.createNode(), this.val$relType);
                            tx.success();
                        }
                        finally {
                            tx.finish();
                        }
                    }
                };
                thread.start();
                threads.add(thread);
            }
            latch.countDown();
            for (Thread thread : threads) {
                thread.join();
            }
            int highestId = 0;
            for (HighlyAvailableGraphDatabase db : this.cluster.getAllMembers()) {
                RelationshipTypeTokenHolder holder = (RelationshipTypeTokenHolder)db.getDependencyResolver().resolveDependency(RelationshipTypeTokenHolder.class);
                highestId = this.highestIdOf((TokenHolder)holder, highestId);
                HashSet<String> types = new HashSet<String>();
                for (int j = 0; j <= highestId; ++j) {
                    RelationshipType type = (RelationshipType)holder.getTokenById(j);
                    if (type == null) continue;
                    Assert.assertTrue((String)(type.name() + " already existed for " + db), (boolean)types.add(type.name()));
                }
            }
        }
    }

    @Test
    public void bruteForceCreateSamePropertyKeyOnDifferentSlaveAtTheSameTimeShouldYieldSameId() throws Exception {
        int i;
        ArrayList<HighlyAvailableGraphDatabase> slaves = new ArrayList<HighlyAvailableGraphDatabase>();
        for (i = 0; i < this.cluster.size() - 1; ++i) {
            slaves.add(this.cluster.getAnySlave(slaves.toArray(new HighlyAvailableGraphDatabase[0])));
        }
        for (i = 0; i < 10; ++i) {
            String key = "Key" + i;
            final CountDownLatch latch = new CountDownLatch(1);
            ArrayList<2> threads = new ArrayList<2>();
            Iterator i$ = slaves.iterator();
            while (i$.hasNext()) {
                HighlyAvailableGraphDatabase highlyAvailableGraphDatabase;
                HighlyAvailableGraphDatabase db = highlyAvailableGraphDatabase = (HighlyAvailableGraphDatabase)i$.next();
                Thread thread = new Thread((GraphDatabaseAPI)db, key){
                    final /* synthetic */ GraphDatabaseAPI val$db;
                    final /* synthetic */ String val$key;
                    {
                        this.val$db = graphDatabaseAPI;
                        this.val$key = string;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        Transaction tx = this.val$db.beginTx();
                        try {
                            this.val$db.createNode().setProperty(this.val$key, (Object)"yes");
                            tx.success();
                        }
                        finally {
                            tx.finish();
                        }
                    }
                };
                thread.start();
                threads.add(thread);
            }
            latch.countDown();
            for (Thread thread : threads) {
                thread.join();
            }
            int highestId = 0;
            for (HighlyAvailableGraphDatabase db : this.cluster.getAllMembers()) {
                TokenHolder holder = (TokenHolder)db.getDependencyResolver().resolveDependency(PropertyKeyTokenHolder.class);
                highestId = this.highestIdOf(holder, highestId);
                HashSet<String> types = new HashSet<String>();
                for (int j = 0; j <= highestId; ++j) {
                    Token type = holder.getTokenById(j);
                    if (type == null) continue;
                    Assert.assertTrue((String)(type.name() + " already existed for " + db), (boolean)types.add(type.name()));
                }
            }
        }
    }

    @Before
    public void getCluster() throws Exception {
        this.cluster = this.clusterManager.getDefaultCluster();
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
    }

    private <KEY extends Token> int highestIdOf(TokenHolder<KEY> holder, int high) throws TokenNotFoundException {
        for (Token type : holder.getAllTokens()) {
            high = Math.max(type.id(), high);
        }
        return high;
    }
}

