/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMemberVersionCheck;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.impl.nioneo.store.StoreId;

public class ClusterMemberVersionCheckTest {
    private static final StoreId EXPECTED_STORE_ID = new StoreId(1L, 2L, 3L, 4L);
    private static final StoreId UNEXPECTED_STORE_ID = new StoreId(5L, 6L, 7L, 8L);
    private static final InstanceId ID_1 = new InstanceId(1);
    private static final InstanceId ID_2 = new InstanceId(2);
    private static final InstanceId ID_3 = new InstanceId(3);
    private static final InstanceId ID_4 = new InstanceId(4);
    private static final InstanceId ID_5 = new InstanceId(5);

    @Test
    public void shouldReturnTrueIfAllAreAvailableAndNoMismatchesFound() throws InterruptedException {
        ClusterMembers members = ClusterMemberVersionCheckTest.clusterMembersWith(ClusterMemberVersionCheckTest.member(ID_1, "master", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_3, "slave", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_4, "slave", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_5, "slave", true, EXPECTED_STORE_ID, true));
        ClusterMemberVersionCheck.Outcome outcome = new ClusterMemberVersionCheck(members, ID_2, (Clock)new FakeClock()).doVersionCheck(EXPECTED_STORE_ID, 1L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)outcome.hasMismatched());
        Assert.assertFalse((boolean)outcome.hasUnavailable());
        ((ClusterMembers)Mockito.verify((Object)members, (VerificationMode)Mockito.times((int)0))).waitForEvent(org.mockito.Matchers.anyLong());
    }

    @Test
    public void shouldReturnTrueIfAllAreAvailableAndNoMismatchesFoundWithOldVersion() throws InterruptedException {
        ClusterMembers members = ClusterMemberVersionCheckTest.clusterMembersWith(ClusterMemberVersionCheckTest.member(ID_1, "master", true, StoreId.DEFAULT, true), ClusterMemberVersionCheckTest.member(ID_3, "slave", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_4, "slave", true, StoreId.DEFAULT, true), ClusterMemberVersionCheckTest.member(ID_5, "slave", true, EXPECTED_STORE_ID, true));
        ClusterMemberVersionCheck.Outcome outcome = new ClusterMemberVersionCheck(members, ID_2, (Clock)new FakeClock()).doVersionCheck(EXPECTED_STORE_ID, 1L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)outcome.hasMismatched());
        Assert.assertFalse((boolean)outcome.hasUnavailable());
        ((ClusterMembers)Mockito.verify((Object)members, (VerificationMode)Mockito.times((int)0))).waitForEvent(org.mockito.Matchers.anyLong());
    }

    @Test
    public void shouldReturnTrueIfAllAreAvailableAndHaveOldVersions() throws InterruptedException {
        ClusterMembers members = ClusterMemberVersionCheckTest.clusterMembersWith(ClusterMemberVersionCheckTest.member(ID_1, "master", true, StoreId.DEFAULT, true), ClusterMemberVersionCheckTest.member(ID_2, "slave", true, StoreId.DEFAULT, true), ClusterMemberVersionCheckTest.member(ID_3, "slave", true, StoreId.DEFAULT, true), ClusterMemberVersionCheckTest.member(ID_4, "slave", true, StoreId.DEFAULT, true));
        ClusterMemberVersionCheck.Outcome outcome = new ClusterMemberVersionCheck(members, ID_5, (Clock)new FakeClock()).doVersionCheck(EXPECTED_STORE_ID, 1L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)outcome.hasMismatched());
        Assert.assertFalse((boolean)outcome.hasUnavailable());
        ((ClusterMembers)Mockito.verify((Object)members, (VerificationMode)Mockito.times((int)0))).waitForEvent(org.mockito.Matchers.anyLong());
    }

    @Test
    public void shouldReturnFalseIfAllAreAvailableAndMismatchesFound() throws InterruptedException {
        ClusterMembers members = ClusterMemberVersionCheckTest.clusterMembersWith(ClusterMemberVersionCheckTest.member(ID_1, "master", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_3, "slave", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_4, "slave", true, UNEXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_5, "slave", true, EXPECTED_STORE_ID, true));
        ClusterMemberVersionCheck.Outcome outcome = new ClusterMemberVersionCheck(members, ID_2, (Clock)new FakeClock()).doVersionCheck(EXPECTED_STORE_ID, 1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)outcome.hasMismatched());
        Assert.assertThat((Object)outcome.getMismatched(), (Matcher)Matchers.equalTo(Collections.singletonMap(ID_4.toIntegerIndex(), UNEXPECTED_STORE_ID)));
        Assert.assertFalse((boolean)outcome.hasUnavailable());
        ((ClusterMembers)Mockito.verify((Object)members, (VerificationMode)Mockito.times((int)0))).waitForEvent(org.mockito.Matchers.anyLong());
    }

    @Test
    public void shouldReturnFalseIfNotAllAreAvailableAndNoMismatchesFound() throws InterruptedException {
        ClusterMembers members = ClusterMemberVersionCheckTest.clusterMembersWith(ClusterMemberVersionCheckTest.member(ID_1, "master", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_3, "slave", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_4, "slave", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_5, "UNKNOWN", true, EXPECTED_STORE_ID, true));
        int timeoutMillis = 1;
        ClusterMemberVersionCheck.Outcome outcome = new ClusterMemberVersionCheck(members, ID_2, ClusterMemberVersionCheckTest.twoTickClock(timeoutMillis)).doVersionCheck(EXPECTED_STORE_ID, (long)timeoutMillis, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)outcome.hasMismatched());
        Assert.assertTrue((boolean)outcome.hasUnavailable());
        Assert.assertThat((Object)outcome.getUnavailable(), (Matcher)Matchers.equalTo(Collections.singleton(ID_5.toIntegerIndex())));
        ((ClusterMembers)Mockito.verify((Object)members, (VerificationMode)Mockito.times((int)1))).waitForEvent((long)timeoutMillis);
    }

    @Test
    public void shouldReturnTrueIfAllEventuallyBecomeAvailableAndNoMismatchesFound() throws InterruptedException {
        ClusterMembers members = ClusterMemberVersionCheckTest.changingClusterMembers(Arrays.asList(ClusterMemberVersionCheckTest.member(ID_1, "master", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_3, "slave", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_4, "slave", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_5, "UNKNOWN", true, EXPECTED_STORE_ID, true)), ClusterMemberVersionCheckTest.member(ID_5, "slave", true, EXPECTED_STORE_ID, true));
        int timeoutMillis = 1;
        ClusterMemberVersionCheck.Outcome outcome = new ClusterMemberVersionCheck(members, ID_2, ClusterMemberVersionCheckTest.twoTickClock(timeoutMillis)).doVersionCheck(EXPECTED_STORE_ID, (long)timeoutMillis, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)outcome.hasMismatched());
        Assert.assertFalse((boolean)outcome.hasUnavailable());
        ((ClusterMembers)Mockito.verify((Object)members, (VerificationMode)Mockito.times((int)1))).waitForEvent((long)timeoutMillis);
    }

    @Test
    public void shouldReturnFalseIfNotAllAreAvailableAndMismatchesFound() throws InterruptedException {
        ClusterMembers members = ClusterMemberVersionCheckTest.clusterMembersWith(ClusterMemberVersionCheckTest.member(ID_1, "master", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_3, "slave", true, EXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_4, "slave", true, UNEXPECTED_STORE_ID, true), ClusterMemberVersionCheckTest.member(ID_5, "UNKNOWN", true, EXPECTED_STORE_ID, true));
        int timeoutMillis = 1;
        ClusterMemberVersionCheck.Outcome outcome = new ClusterMemberVersionCheck(members, ID_2, ClusterMemberVersionCheckTest.twoTickClock(timeoutMillis)).doVersionCheck(EXPECTED_STORE_ID, (long)timeoutMillis, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)outcome.hasMismatched());
        Assert.assertThat((Object)outcome.getMismatched(), (Matcher)Matchers.equalTo(Collections.singletonMap(ID_4.toIntegerIndex(), UNEXPECTED_STORE_ID)));
        Assert.assertTrue((boolean)outcome.hasUnavailable());
        Assert.assertThat((Object)outcome.getUnavailable(), (Matcher)Matchers.equalTo(Collections.singleton(ID_5.toIntegerIndex())));
        ((ClusterMembers)Mockito.verify((Object)members, (VerificationMode)Mockito.times((int)1))).waitForEvent((long)timeoutMillis);
    }

    @Test(timeout=5000L)
    public void shouldBeNotifiedAboutAvailableMemberWithExpectedStoreIdByListener() throws Exception {
        this.testNotificationAboutSlave5BeingUpWith(EXPECTED_STORE_ID);
    }

    @Test(timeout=5000L)
    public void shouldBeNotifiedAboutAvailableMemberWithUnexpectedStoreIdByListener() throws Exception {
        this.testNotificationAboutSlave5BeingUpWith(UNEXPECTED_STORE_ID);
    }

    private void testNotificationAboutSlave5BeingUpWith(StoreId storeId) throws Exception {
        ClusterMemberListener[] memberListenerSlot = new ClusterMemberListener[1];
        ClusterMemberEvents clusterMemberEvents = ClusterMemberVersionCheckTest.clusterMemberEvents(memberListenerSlot);
        ClusterListener[] clusterListenerSlot = new ClusterListener[1];
        Cluster cluster = ClusterMemberVersionCheckTest.cluster(clusterListenerSlot);
        final ClusterMembers members = new ClusterMembers(cluster, (Heartbeat)Mockito.mock(Heartbeat.class), clusterMemberEvents, (InstanceId)Mockito.mock(InstanceId.class));
        ClusterMemberListener memberListener = memberListenerSlot[0];
        ClusterListener clusterListener = clusterListenerSlot[0];
        clusterListener.enteredCluster(ClusterMemberVersionCheckTest.clusterConfigurationWith(ID_1, ID_2, ID_3, ID_4, ID_5));
        memberListener.memberIsAvailable("master", ID_1, URI.create("cluster://master"), EXPECTED_STORE_ID);
        memberListener.memberIsAvailable("slave", ID_3, URI.create("cluster://slave3"), EXPECTED_STORE_ID);
        memberListener.memberIsAvailable("slave", ID_4, URI.create("cluster://slave4"), EXPECTED_STORE_ID);
        memberListener.memberIsUnavailable("slave", ID_5);
        int timeoutMillis = 30000;
        Future<ClusterMemberVersionCheck.Outcome> outcomeFuture = Executors.newSingleThreadExecutor().submit(new Callable<ClusterMemberVersionCheck.Outcome>(){

            @Override
            public ClusterMemberVersionCheck.Outcome call() throws Exception {
                return new ClusterMemberVersionCheck(members, ID_2, Clock.SYSTEM_CLOCK).doVersionCheck(EXPECTED_STORE_ID, 30000L, TimeUnit.MILLISECONDS);
            }
        });
        Thread.sleep(2000L);
        memberListener.memberIsAvailable("slave", ID_5, URI.create("cluster://slave5"), storeId);
        ClusterMemberVersionCheck.Outcome outcome = outcomeFuture.get();
        Assert.assertFalse((boolean)outcome.hasUnavailable());
        if (storeId == EXPECTED_STORE_ID) {
            Assert.assertFalse((boolean)outcome.hasMismatched());
        } else {
            Assert.assertTrue((boolean)outcome.hasMismatched());
            Assert.assertThat((Object)outcome.getMismatched(), (Matcher)Matchers.equalTo(Collections.singletonMap(ID_5.toIntegerIndex(), UNEXPECTED_STORE_ID)));
        }
    }

    private static ClusterMembers clusterMembersWith(ClusterMember ... members) {
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn(Arrays.asList(members));
        return clusterMembers;
    }

    private static ClusterMembers changingClusterMembers(List<ClusterMember> initialMembers, ClusterMember lastMember) {
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ArrayList<ClusterMember> finalMembers = new ArrayList<ClusterMember>(initialMembers);
        finalMembers.set(finalMembers.size() - 1, lastMember);
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn(initialMembers).thenReturn(finalMembers);
        return clusterMembers;
    }

    private static ClusterMember member(InstanceId id, String role, boolean alive, StoreId storeId, boolean isInitial) {
        Map<String, URI> haRoles = Collections.singletonMap(role, URI.create("cluster://test" + id));
        return new ClusterMember(id, haRoles, storeId, alive, isInitial);
    }

    private static Clock twoTickClock(long timeout) {
        return (Clock)Mockito.when((Object)((Clock)Mockito.mock(Clock.class)).currentTimeMillis()).thenReturn((Object)0L).thenReturn((Object)(timeout + 1L)).getMock();
    }

    private static ClusterMemberEvents clusterMemberEvents(final ClusterMemberListener[] listenerSlot) {
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                listenerSlot[0] = (ClusterMemberListener)invocation.getArguments()[0];
                return null;
            }
        }).when((Object)clusterMemberEvents)).addClusterMemberListener((ClusterMemberListener)org.mockito.Matchers.any(ClusterMemberListener.class));
        return clusterMemberEvents;
    }

    private static Cluster cluster(final ClusterListener[] listenerSlot) {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        ((Cluster)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                listenerSlot[0] = (ClusterListener)invocation.getArguments()[0];
                return null;
            }
        }).when((Object)cluster)).addClusterListener((ClusterListener)org.mockito.Matchers.any(ClusterListener.class));
        return cluster;
    }

    private static ClusterConfiguration clusterConfigurationWith(InstanceId ... memberIds) {
        ClusterConfiguration clusterConfiguration = (ClusterConfiguration)Mockito.mock(ClusterConfiguration.class);
        Mockito.when((Object)clusterConfiguration.getMemberIds()).thenReturn(Arrays.asList(memberIds));
        return clusterConfiguration;
    }
}

