/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.slave;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.ComException;
import org.neo4j.com.ComExceptionHandler;
import org.neo4j.com.IllegalProtocolVersionException;
import org.neo4j.kernel.ha.MasterClient210;
import org.neo4j.kernel.ha.MasterClient214;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class MasterClientResolverTest {
    @Test
    public void shouldResolveMasterClientFactory() throws Exception {
        ArrayList<ComExceptionHandler> handlers = new ArrayList<ComExceptionHandler>(2);
        MasterClientResolver resolver = MasterClientResolverTest.newMasterClientResolver(handlers);
        MasterClient masterClient1 = resolver.instantiate("cluster://localhost", 44, new Monitors(), StoreId.DEFAULT);
        Assert.assertThat((Object)masterClient1, (Matcher)Matchers.instanceOf(MasterClient214.class));
        IllegalProtocolVersionException illegalProtocolVersionException = new IllegalProtocolVersionException(MasterClient210.PROTOCOL_VERSION.getApplicationProtocol(), MasterClient214.PROTOCOL_VERSION.getApplicationProtocol(), "Protocol is too modern");
        for (ComExceptionHandler handler : handlers) {
            handler.handle((ComException)illegalProtocolVersionException);
        }
        MasterClient masterClient2 = resolver.instantiate("cluster://localhost", 55, new Monitors(), StoreId.DEFAULT);
        Assert.assertThat((Object)masterClient2, (Matcher)Matchers.instanceOf(MasterClient210.class));
    }

    private static MasterClientResolver newMasterClientResolver(final List<ComExceptionHandler> comExceptionHandlers) {
        MasterClientResolver resolver = new MasterClientResolver((Logging)new DevNullLoggingService(), StringLogger.DEV_NULL, (ClusterClient)Mockito.mock(ClusterClient.class), (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class), 1, 1, 1, 1024);
        MasterClientResolver resolverSpy = (MasterClientResolver)Mockito.spy((Object)resolver);
        ((MasterClientResolver)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ComExceptionHandler handler = (ComExceptionHandler)invocation.getArguments()[1];
                comExceptionHandlers.add(handler);
                return null;
            }
        }).when((Object)resolverSpy)).addComExceptionHandler((MasterClient)org.mockito.Matchers.any(MasterClient.class), (ComExceptionHandler)org.mockito.Matchers.any(ComExceptionHandler.class));
        return resolverSpy;
    }
}

