/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.Server;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.storecopy.RemoteStoreCopier;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.MasterClient210;
import org.neo4j.kernel.ha.StoreOutOfDateException;
import org.neo4j.kernel.ha.StoreUnableToParticipateInClusterException;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMemberVersionCheck;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveImpl;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.transaction.DenseNodeTransactionTranslator;
import org.neo4j.kernel.impl.api.NonTransactionalTokenNameLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InconsistentlyUpgradedClusterException;
import org.neo4j.kernel.impl.nioneo.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.store.UnableToCopyStoreFromOldMasterException;
import org.neo4j.kernel.impl.nioneo.store.UnavailableMembersException;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.MissingLogDataException;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class SwitchToSlave {
    private static final Class<? extends Lifecycle>[] SERVICES_TO_RESTART_FOR_STORE_COPY = new Class[]{StoreLockerLifecycleAdapter.class, XaDataSourceManager.class, TransactionManager.class, NodeManager.class, IndexStore.class};
    private static final int VERSION_CHECK_TIMEOUT = 10;
    private final Logging logging;
    private final StringLogger msgLog;
    private final ConsoleLogger console;
    private final Config config;
    private final DependencyResolver resolver;
    private final HaIdGeneratorFactory idGeneratorFactory;
    private final DelegateInvocationHandler<Master> masterDelegateHandler;
    private final ClusterMemberAvailability clusterMemberAvailability;
    private final RequestContextFactory requestContextFactory;
    private final UpdateableSchemaState updateableSchemaState;
    private final Monitors monitors;
    private final Iterable<KernelExtensionFactory<?>> kernelExtensions;
    private final MasterClientResolver masterClientResolver;

    public SwitchToSlave(ConsoleLogger console, Config config, DependencyResolver resolver, HaIdGeneratorFactory idGeneratorFactory, Logging logging, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, ClusterClient clusterClient, RequestContextFactory requestContextFactory, UpdateableSchemaState updateableSchemaState, Monitors monitors, Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        this.console = console;
        this.config = config;
        this.resolver = resolver;
        this.idGeneratorFactory = idGeneratorFactory;
        this.logging = logging;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.requestContextFactory = requestContextFactory;
        this.updateableSchemaState = updateableSchemaState;
        this.monitors = monitors;
        this.kernelExtensions = kernelExtensions;
        this.msgLog = logging.getMessagesLog(this.getClass());
        this.masterDelegateHandler = masterDelegateHandler;
        this.masterClientResolver = new MasterClientResolver(logging, this.msgLog, clusterClient, clusterMemberAvailability, ((Long)config.get(HaSettings.read_timeout)).intValue(), ((Long)config.get(HaSettings.lock_read_timeout)).intValue(), (Integer)config.get(HaSettings.max_concurrent_channels_per_slave), ((Long)config.get(HaSettings.com_chunk_size)).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI switchToSlave(LifeSupport haCommunicationLife, URI me, URI masterUri, CancellationRequest cancellationRequest) throws Throwable {
        StoreId myStoreId;
        NeoStoreXaDataSource nioneoDataSource;
        InstanceId myId = (InstanceId)this.config.get(ClusterSettings.server_id);
        this.console.log("ServerId " + myId + ", moving to slave for master " + masterUri);
        assert (masterUri != null);
        HaXaDataSourceManager xaDataSourceManager = (HaXaDataSourceManager)((Object)this.resolver.resolveDependency(HaXaDataSourceManager.class));
        this.idGeneratorFactory.switchToSlave();
        HaXaDataSourceManager haXaDataSourceManager = xaDataSourceManager;
        synchronized (haXaDataSourceManager) {
            this.copyStoreFromMasterIfNeeded(masterUri, cancellationRequest);
            if (cancellationRequest.cancellationRequested()) {
                this.msgLog.info("Switch to slave cancelled during store copy if no local store is present.");
                return null;
            }
            nioneoDataSource = this.ensureDataSourceStarted(xaDataSourceManager, this.resolver);
            myStoreId = nioneoDataSource.getStoreId();
            boolean consistencyChecksExecutedSuccessfully = this.executeConsistencyChecks(myId, masterUri, xaDataSourceManager, nioneoDataSource, cancellationRequest);
            if (!consistencyChecksExecutedSuccessfully) {
                this.msgLog.info("Switch to slave cancelled due to consistency check failure.");
                return null;
            }
        }
        if (cancellationRequest.cancellationRequested()) {
            this.msgLog.info("Switch to slave cancelled after consistency checks.");
            return null;
        }
        URI slaveUri = this.startHaCommunication(haCommunicationLife, xaDataSourceManager, nioneoDataSource, me, masterUri, myStoreId);
        this.console.log("ServerId " + myId + ", successfully moved to slave for master " + masterUri);
        return slaveUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStoreFromMasterIfNeeded(URI masterUri, CancellationRequest cancellationRequest) throws Throwable {
        if (!NeoStore.isStorePresent((FileSystemAbstraction)((FileSystemAbstraction)this.resolver.resolveDependency(FileSystemAbstraction.class)), (Config)this.config)) {
            LifeSupport copyLife = new LifeSupport();
            try {
                boolean masterIsOld;
                MasterClient masterClient = (MasterClient)copyLife.add((Object)this.newMasterClient(masterUri, null));
                copyLife.start();
                boolean bl = masterIsOld = MasterClient.CURRENT.compareTo(masterClient.getProtocolVersion()) > 0;
                if (masterIsOld) {
                    throw new UnableToCopyStoreFromOldMasterException(MasterClient.CURRENT.getApplicationProtocol(), masterClient.getProtocolVersion().getApplicationProtocol());
                }
                this.copyStoreFromMaster(masterClient, cancellationRequest);
            }
            finally {
                copyLife.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeConsistencyChecks(InstanceId myId, URI masterUri, HaXaDataSourceManager xaDataSourceManager, NeoStoreXaDataSource nioneoDataSource, CancellationRequest cancellationRequest) throws Throwable {
        LifeSupport consistencyCheckLife = new LifeSupport();
        try {
            boolean masterIsOld;
            StoreId myStoreId = nioneoDataSource.getStoreId();
            MasterClient masterClient = (MasterClient)consistencyCheckLife.add((Object)this.newMasterClient(masterUri, myStoreId));
            consistencyCheckLife.start();
            boolean bl = masterIsOld = MasterClient.CURRENT.compareTo(masterClient.getProtocolVersion()) > 0;
            if (masterIsOld) {
                ClusterMembers members = (ClusterMembers)this.resolver.resolveDependency(ClusterMembers.class);
                ClusterMemberVersionCheck checker = new ClusterMemberVersionCheck(members, myId, Clock.SYSTEM_CLOCK);
                ClusterMemberVersionCheck.Outcome outcome = checker.doVersionCheck(myStoreId, 10L, TimeUnit.SECONDS);
                this.msgLog.info("Cluster members version  checked: " + outcome);
                if (outcome.hasUnavailable()) {
                    throw new UnavailableMembersException(outcome.getUnavailable());
                }
                if (outcome.hasMismatched()) {
                    throw new InconsistentlyUpgradedClusterException(myStoreId, outcome.getMismatched());
                }
            }
            if (cancellationRequest.cancellationRequested()) {
                boolean bl2 = false;
                return bl2;
            }
            this.checkDataConsistency(xaDataSourceManager, masterClient, (RequestContextFactory)this.resolver.resolveDependency(RequestContextFactory.class), nioneoDataSource, masterUri, masterIsOld);
        }
        finally {
            consistencyCheckLife.shutdown();
        }
        return true;
    }

    private void checkDataConsistency(HaXaDataSourceManager xaDataSourceManager, MasterClient masterClient, RequestContextFactory requestContextFactory, NeoStoreXaDataSource nioneoDataSource, URI masterUri, boolean masterIsOld) throws Throwable {
        try {
            this.console.log("Checking store consistency with master");
            this.checkMyStoreIdAndMastersStoreId(nioneoDataSource, masterIsOld);
            this.checkDataConsistencyWithMaster(masterUri, masterClient, nioneoDataSource);
            this.console.log("Store is consistent");
            this.console.log("Catching up with master");
            RequestContext context = requestContextFactory.newRequestContext(-1);
            xaDataSourceManager.applyTransactions(masterClient.pullUpdates(context));
            this.console.log("Now consistent with master");
        }
        catch (NoSuchLogVersionException e) {
            this.msgLog.logMessage("Cannot catch up to master by pulling updates, because I cannot find the archived logical log file that has the transaction I would start from. I'm going to copy the whole store from the master instead.");
            try {
                this.stopServicesAndHandleBranchedStore((BranchedDataPolicy)((Object)this.config.get(HaSettings.branched_data_policy)));
            }
            catch (Throwable throwable) {
                this.msgLog.warn("Failed preparing for copying the store from the master instance", throwable);
            }
            throw e;
        }
        catch (StoreUnableToParticipateInClusterException upe) {
            this.console.log("The store is inconsistent. Will treat it as branched and fetch a new one from the master");
            this.msgLog.warn("Current store is unable to participate in the cluster; fetching new store from master", (Throwable)upe);
            try {
                xaDataSourceManager.unregisterDataSource("nioneodb");
                this.stopServicesAndHandleBranchedStore((BranchedDataPolicy)((Object)this.config.get(HaSettings.branched_data_policy)));
            }
            catch (IOException e) {
                this.msgLog.warn("Failed while trying to handle branched data", (Throwable)e);
            }
            throw upe;
        }
        catch (MismatchingStoreIdException e) {
            this.console.log("The store does not represent the same database as master. Will remove and fetch a new one from master");
            if (nioneoDataSource.getNeoStore().getLastCommittedTx() == 1L) {
                this.msgLog.warn("Found and deleting empty store with mismatching store id " + e.getMessage());
                this.stopServicesAndHandleBranchedStore(BranchedDataPolicy.keep_none);
            } else {
                this.msgLog.error("Store cannot participate in cluster due to mismatching store IDs");
            }
            throw e;
        }
    }

    private void checkMyStoreIdAndMastersStoreId(NeoStoreXaDataSource nioneoDataSource, boolean masterIsOld) {
        if (!masterIsOld) {
            StoreId myStoreId = nioneoDataSource.getStoreId();
            ClusterMembers clusterMembers = (ClusterMembers)this.resolver.resolveDependency(ClusterMembers.class);
            ClusterMember master = (ClusterMember)Iterables.first((Iterable)Iterables.filter(ClusterMembers.inRole("master"), clusterMembers.getMembers()));
            StoreId masterStoreId = master.getStoreId();
            if (!myStoreId.equals((Object)masterStoreId)) {
                throw new MismatchingStoreIdException(myStoreId, master.getStoreId());
            }
            if (!myStoreId.equalsByUpgradeId(master.getStoreId())) {
                throw new BranchedDataException("My store with " + myStoreId + " was updated independently from " + "master's store " + masterStoreId);
            }
        }
    }

    private URI startHaCommunication(LifeSupport haCommunicationLife, HaXaDataSourceManager xaDataSourceManager, NeoStoreXaDataSource nioneoDataSource, URI me, URI masterUri, StoreId storeId) {
        MasterClient master = (MasterClient)haCommunicationLife.add((Object)this.newMasterClient(masterUri, nioneoDataSource.getStoreId()));
        SlaveImpl slaveImpl = new SlaveImpl(nioneoDataSource.getStoreId(), master, new RequestContextFactory(HighAvailabilityModeSwitcher.getServerId(masterUri).toIntegerIndex(), xaDataSourceManager, this.resolver), xaDataSourceManager);
        SlaveServer server = new SlaveServer(slaveImpl, this.serverConfig(), this.logging, (Monitors)this.resolver.resolveDependency(Monitors.class));
        this.masterDelegateHandler.setDelegate(master);
        haCommunicationLife.add((Object)slaveImpl);
        haCommunicationLife.add((Object)server);
        haCommunicationLife.start();
        URI slaveHaURI = this.createHaURI(me, server);
        this.clusterMemberAvailability.memberIsAvailable("slave", slaveHaURI, storeId);
        return slaveHaURI;
    }

    private Server.Configuration serverConfig() {
        Server.Configuration serverConfig = new Server.Configuration(){

            public long getOldChannelThreshold() {
                return (Long)SwitchToSlave.this.config.get(HaSettings.lock_read_timeout);
            }

            public int getMaxConcurrentTransactions() {
                return (Integer)SwitchToSlave.this.config.get(HaSettings.max_concurrent_channels_per_slave);
            }

            public int getChunkSize() {
                return ((Long)SwitchToSlave.this.config.get(HaSettings.com_chunk_size)).intValue();
            }

            public HostnamePort getServerAddress() {
                return (HostnamePort)SwitchToSlave.this.config.get(HaSettings.ha_server);
            }
        };
        return serverConfig;
    }

    private URI createHaURI(URI me, Server<?, ?> server) {
        String hostString = ServerUtil.getHostString((InetSocketAddress)server.getSocketAddress());
        int port = server.getSocketAddress().getPort();
        InstanceId serverId = (InstanceId)this.config.get(ClusterSettings.server_id);
        String host = hostString.contains("0.0.0.0") ? me.getHost() : hostString;
        return URI.create("ha://" + host + ":" + port + "?serverId=" + serverId);
    }

    private void copyStoreFromMaster(final MasterClient masterClient, CancellationRequest cancellationRequest) throws Throwable {
        FileSystemAbstraction fs = (FileSystemAbstraction)this.resolver.resolveDependency(FileSystemAbstraction.class);
        this.stopServicesAndHandleBranchedStore(BranchedDataPolicy.keep_none);
        this.console.log("Copying store from master");
        RemoteStoreCopier storeCopier = new RemoteStoreCopier(this.config, this.kernelExtensions, this.console, this.logging, fs);
        storeCopier.copyStore(new RemoteStoreCopier.StoreCopyRequester(){

            public Response<?> copyStore(StoreWriter writer) {
                return masterClient.copyStore(new RequestContext(0L, ((InstanceId)SwitchToSlave.this.config.get(ClusterSettings.server_id)).toIntegerIndex(), 0, new RequestContext.Tx[0], 0, 0L), writer);
            }

            public void done() {
            }
        }, cancellationRequest);
        this.startServicesAgain();
        this.console.log("Finished copying store from master");
    }

    MasterClient newMasterClient(URI masterUri, StoreId storeId) {
        MasterClient masterClient = this.masterClientResolver.instantiate(masterUri.getHost(), masterUri.getPort(), (Monitors)this.resolver.resolveDependency(Monitors.class), storeId);
        if (masterClient.getProtocolVersion().compareTo(MasterClient210.PROTOCOL_VERSION) < 0) {
            this.idGeneratorFactory.enableCompatibilityMode();
        }
        return masterClient;
    }

    private void startServicesAgain() throws Throwable {
        for (Class<? extends Lifecycle> serviceClass : SERVICES_TO_RESTART_FOR_STORE_COPY) {
            ((Lifecycle)this.resolver.resolveDependency(serviceClass)).start();
        }
    }

    private void stopServicesAndHandleBranchedStore(BranchedDataPolicy branchPolicy) throws Throwable {
        for (int i = SERVICES_TO_RESTART_FOR_STORE_COPY.length - 1; i >= 0; --i) {
            Class<? extends Lifecycle> serviceClass = SERVICES_TO_RESTART_FOR_STORE_COPY[i];
            ((Lifecycle)this.resolver.resolveDependency(serviceClass)).stop();
        }
        branchPolicy.handle((File)this.config.get(InternalAbstractGraphDatabase.Configuration.store_dir));
    }

    private void checkDataConsistencyWithMaster(URI masterUri, Master master, NeoStoreXaDataSource nioneoDataSource) throws NoSuchLogVersionException {
        HandshakeResult handshake;
        Pair myMaster;
        long myLastCommittedTx = nioneoDataSource.getLastCommittedTxId();
        try {
            myMaster = nioneoDataSource.getMasterForCommittedTx(myLastCommittedTx);
        }
        catch (IOException e) {
            this.msgLog.logMessage("Failed to get master ID for txId " + myLastCommittedTx + ".", (Throwable)e);
            return;
        }
        catch (Exception e) {
            throw new BranchedDataException("Unable to gather data for mandatory sanity check. Details: Exception while getting master ID for txId " + myLastCommittedTx + ".", e);
        }
        try (Response<HandshakeResult> response = master.handshake(myLastCommittedTx, nioneoDataSource.getStoreId());){
            handshake = (HandshakeResult)response.response();
            this.requestContextFactory.setEpoch(handshake.epoch());
        }
        catch (BranchedDataException e) {
            throw new BranchedDataException("The database stored on this machine has diverged from that of the master. This will be automatically resolved.", e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MissingLogDataException) {
                throw new StoreOutOfDateException("The master is missing the log required to complete the consistency check", e.getCause());
            }
            throw e;
        }
        if ((Integer)myMaster.first() != -1 && (((Integer)myMaster.first()).intValue() != handshake.txAuthor() || ((Long)myMaster.other()).longValue() != handshake.txChecksum())) {
            String msg = "The cluster contains two logically different versions of the database.. This will be automatically resolved. Details: I (machineId:" + this.config.get(ClusterSettings.server_id) + ") think machineId for txId (" + myLastCommittedTx + ") is " + myMaster + ", but master (machineId:" + HighAvailabilityModeSwitcher.getServerId(masterUri) + ") says that it's " + handshake;
            throw new BranchedDataException(msg);
        }
        this.msgLog.logMessage("Master id for last committed tx ok with highestTxId=" + myLastCommittedTx + " with masterId=" + myMaster, true);
    }

    private NeoStoreXaDataSource ensureDataSourceStarted(XaDataSourceManager xaDataSourceManager, DependencyResolver resolver) throws IOException {
        NeoStoreXaDataSource nioneoDataSource = (NeoStoreXaDataSource)xaDataSourceManager.getXaDataSource("nioneodb");
        if (nioneoDataSource == null) {
            Function<NeoStore, Function<List<LogEntry>, List<LogEntry>>> thing = new Function<NeoStore, Function<List<LogEntry>, List<LogEntry>>>(){

                public Function<List<LogEntry>, List<LogEntry>> apply(NeoStore neoStore) {
                    return new DenseNodeTransactionTranslator(neoStore);
                }
            };
            nioneoDataSource = new NeoStoreXaDataSource(this.config, (LockService)resolver.resolveDependency(LockService.class), (StoreFactory)resolver.resolveDependency(StoreFactory.class), (StringLogger)resolver.resolveDependency(StringLogger.class), (XaFactory)resolver.resolveDependency(XaFactory.class), (TransactionStateFactory)resolver.resolveDependency(TransactionStateFactory.class), (TransactionInterceptorProviders)resolver.resolveDependency(TransactionInterceptorProviders.class), (JobScheduler)resolver.resolveDependency(JobScheduler.class), this.logging, this.updateableSchemaState, (TokenNameLookup)new NonTransactionalTokenNameLookup((LabelTokenHolder)resolver.resolveDependency(LabelTokenHolder.class), (PropertyKeyTokenHolder)resolver.resolveDependency(PropertyKeyTokenHolder.class)), resolver, (AbstractTransactionManager)resolver.resolveDependency(AbstractTransactionManager.class), (PropertyKeyTokenHolder)resolver.resolveDependency(PropertyKeyTokenHolder.class), (LabelTokenHolder)resolver.resolveDependency(LabelTokenHolder.class), (RelationshipTypeTokenHolder)resolver.resolveDependency(RelationshipTypeTokenHolder.class), (PersistenceManager)resolver.resolveDependency(PersistenceManager.class), (SchemaWriteGuard)resolver.resolveDependency(SchemaWriteGuard.class), (TransactionEventHandlers)resolver.resolveDependency(TransactionEventHandlers.class), (IndexingService.Monitor)this.monitors.newMonitor(IndexingService.Monitor.class, new String[0]), (FileSystemAbstraction)resolver.resolveDependency(FileSystemAbstraction.class), (Function)thing, (StoreUpgrader)resolver.resolveDependency(StoreUpgrader.class));
            xaDataSourceManager.registerDataSource((XaDataSource)nioneoDataSource);
            ((NodeManager)resolver.resolveDependency(NodeManager.class)).start();
        }
        return nioneoDataSource;
    }
}

