/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.slave;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.ComException;
import org.neo4j.com.ComExceptionHandler;
import org.neo4j.com.IllegalProtocolVersionException;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.kernel.ha.MasterClient201;
import org.neo4j.kernel.ha.MasterClient210;
import org.neo4j.kernel.ha.MasterClient214;
import org.neo4j.kernel.ha.com.master.InvalidEpochException;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class MasterClientResolver
implements MasterClientFactory {
    private volatile MasterClientFactory currentFactory;
    private final Map<ProtocolVersion, MasterClientFactory> protocolToFactoryMapping;
    private final StringLogger log;
    private final ClusterClient clusterClient;
    private final ClusterMemberAvailability clusterMemberAvailability;

    @Override
    public MasterClient instantiate(String hostNameOrIp, int port, Monitors monitors, StoreId storeId) {
        if (this.currentFactory == null) {
            this.assignDefaultFactory();
        }
        MasterClient result = this.currentFactory.instantiate(hostNameOrIp, port, monitors, storeId);
        this.addComExceptionHandler(result, new MismatchingProtocolVersionHandler());
        this.addComExceptionHandler(result, new InvalidEpochHandler());
        return result;
    }

    public MasterClientResolver(Logging logging, StringLogger msgLog, ClusterClient clusterClient, ClusterMemberAvailability clusterMemberAvailability, int readTimeout, int lockReadTimeout, int channels, int chunkSize) {
        this.log = msgLog;
        this.clusterClient = clusterClient;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.protocolToFactoryMapping = new HashMap<ProtocolVersion, MasterClientFactory>();
        this.protocolToFactoryMapping.put(MasterClient201.PROTOCOL_VERSION, new F201(logging, readTimeout, lockReadTimeout, channels, chunkSize));
        this.protocolToFactoryMapping.put(MasterClient210.PROTOCOL_VERSION, new F210(logging, readTimeout, lockReadTimeout, channels, chunkSize));
        this.protocolToFactoryMapping.put(MasterClient214.PROTOCOL_VERSION, new F214(logging, readTimeout, lockReadTimeout, channels, chunkSize));
    }

    void addComExceptionHandler(MasterClient masterClient, ComExceptionHandler handler) {
        masterClient.addComExceptionHandler(handler);
    }

    private MasterClientFactory getFor(ProtocolVersion protocolVersion) {
        MasterClientFactory candidate = this.protocolToFactoryMapping.get(protocolVersion);
        if (candidate != null) {
            this.currentFactory = candidate;
        }
        return candidate;
    }

    private MasterClientFactory assignDefaultFactory() {
        return this.getFor(MasterClient214.PROTOCOL_VERSION);
    }

    private class InvalidEpochHandler
    implements ComExceptionHandler {
        private InvalidEpochHandler() {
        }

        public void handle(ComException exception) {
            if (exception instanceof InvalidEpochException) {
                MasterClientResolver.this.log.info("Handling " + (Object)((Object)exception) + ", will go to PENDING and ask for election");
                MasterClientResolver.this.clusterMemberAvailability.memberIsUnavailable("slave");
                MasterClientResolver.this.clusterClient.performRoleElections();
            }
        }
    }

    private class MismatchingProtocolVersionHandler
    implements ComExceptionHandler {
        private MismatchingProtocolVersionHandler() {
        }

        public void handle(ComException exception) {
            if (exception instanceof IllegalProtocolVersionException) {
                MasterClientResolver.this.log.info("Handling " + (Object)((Object)exception) + ", will pick new master client");
                byte receivedVersion = ((IllegalProtocolVersionException)exception).getReceived();
                MasterClientResolver.this.getFor(new ProtocolVersion(receivedVersion, 2));
            }
        }
    }

    private static final class F214
    extends StaticMasterClientFactory {
        public F214(Logging logging, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(logging, readTimeoutSeconds, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String hostNameOrIp, int port, Monitors monitors, StoreId storeId) {
            return new MasterClient214(hostNameOrIp, port, this.logging, monitors, storeId, this.readTimeoutSeconds, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize);
        }
    }

    private static final class F210
    extends StaticMasterClientFactory {
        public F210(Logging logging, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(logging, readTimeoutSeconds, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String hostNameOrIp, int port, Monitors monitors, StoreId storeId) {
            return new MasterClient210(hostNameOrIp, port, this.logging, monitors, storeId, this.readTimeoutSeconds, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize);
        }
    }

    private static final class F201
    extends StaticMasterClientFactory {
        public F201(Logging logging, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(logging, readTimeoutSeconds, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String hostNameOrIp, int port, Monitors monitors, StoreId storeId) {
            return new MasterClient201(hostNameOrIp, port, this.logging, monitors, storeId, this.readTimeoutSeconds, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize);
        }
    }

    private static abstract class StaticMasterClientFactory
    implements MasterClientFactory {
        protected final Logging logging;
        protected final int readTimeoutSeconds;
        protected final int lockReadTimeout;
        protected final int maxConcurrentChannels;
        protected final int chunkSize;

        StaticMasterClientFactory(Logging logging, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            this.logging = logging;
            this.readTimeoutSeconds = readTimeoutSeconds;
            this.lockReadTimeout = lockReadTimeout;
            this.maxConcurrentChannels = maxConcurrentChannels;
            this.chunkSize = chunkSize;
        }
    }
}

