/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.Settings;
import org.neo4j.kernel.impl.cache.HPCMemoryConfig;
import org.neo4j.kernel.impl.cache.HPCSettingFunctions;

public class HighPerformanceCacheSettings {
    public static final Setting<Long> node_cache_size = Settings.setting((String)"node_cache_size", (Function)Settings.BYTES, (String)Settings.NO_DEFAULT);
    public static final Setting<Long> relationship_cache_size = Settings.setting((String)"relationship_cache_size", (Function)Settings.BYTES, (String)Settings.NO_DEFAULT);
    public static final Setting<Float> node_cache_array_fraction = Settings.setting((String)"node_cache_array_fraction", (Function)Settings.FLOAT, (String)"1.0", (Function2[])new Function2[]{Settings.range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(10.0f))});
    public static final Setting<Float> relationship_cache_array_fraction = Settings.setting((String)"relationship_cache_array_fraction", (Function)Settings.FLOAT, (String)"1.0", (Function2[])new Function2[]{Settings.range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(10.0f))});
    @Description(value="Set the amount of usable memory to allocate to the high-level object cache, a value between 0 and 100. It is recommended to not have this value exceed 70. This cannot be used in conjunction with other object cache size settings.")
    public static final Setting<HPCMemoryConfig> cache_memory = Settings.setting((String)"cache.memory_ratio", HPCSettingFunctions.CACHE_MEMORY_RATIO, (String)HPCSettingFunctions.DEFAULT, (Function2[])new Function2[]{HPCSettingFunctions.OTHER_CACHE_SETTINGS_OVERRIDE, HPCSettingFunctions.TOTAL_NOT_ALLOWED_ABOVE_HEAP});
    public static final Setting<Long> log_interval = Settings.setting((String)"high_performance_cache_min_log_interval", (Function)Settings.DURATION, (String)"60s");
}

