/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.logging.NettyLoggerFactory;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.member.paxos.MemberIsAvailable;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberAvailability;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberEvents;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcast;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.snapshot.Snapshot;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.Factory;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.BranchedDataMigrator;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaCaches;
import org.neo4j.kernel.ha.HaKernelPanicHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.HighAvailabilityConsoleLogger;
import org.neo4j.kernel.ha.HighAvailabilityDiagnostics;
import org.neo4j.kernel.ha.HighAvailabilityMemberInfoProvider;
import org.neo4j.kernel.ha.LabelTokenCreatorModeSwitcher;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.PropertyKeyCreatorModeSwitcher;
import org.neo4j.kernel.ha.RelationshipTypeCreatorModeSwitcher;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.DefaultElectionCredentialsProvider;
import org.neo4j.kernel.ha.cluster.HANewSnapshotFunction;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.SimpleHighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.HighAvailabilitySlaves;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.DefaultSlaveFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.lock.LockManagerModeSwitcher;
import org.neo4j.kernel.ha.management.ClusterDatabaseInfoProvider;
import org.neo4j.kernel.ha.management.HighlyAvailableKernelData;
import org.neo4j.kernel.ha.transaction.DenseNodeTransactionTranslator;
import org.neo4j.kernel.ha.transaction.OnDiskLastTxIdGetter;
import org.neo4j.kernel.ha.transaction.TxHookModeSwitcher;
import org.neo4j.kernel.ha.transaction.TxIdGeneratorModeSwitcher;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByDatabaseModeException;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.LogbackWeakDependency;
import org.neo4j.kernel.logging.Logging;

public class HighlyAvailableGraphDatabase
extends InternalAbstractGraphDatabase {
    private RequestContextFactory requestContextFactory;
    private Slaves slaves;
    private ClusterMembers members;
    private DelegateInvocationHandler<Master> masterDelegateInvocationHandler;
    private HighAvailabilityMemberStateMachine memberStateMachine;
    private UpdatePuller updatePuller;
    private LastUpdateTime lastUpdateTime;
    private ClusterClient clusterClient;
    private ClusterMemberEvents clusterEvents;
    private ClusterMemberAvailability clusterMemberAvailability;
    private HighAvailabilityModeSwitcher highAvailabilityModeSwitcher;
    private long stateSwitchTimeoutMillis;
    private final LifeSupport paxosLife = new LifeSupport();

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> params, Iterable<KernelExtensionFactory<?>> kernelExtensions, Iterable<CacheProvider> cacheProviders, Iterable<TransactionInterceptorProvider> txInterceptorProviders) {
        this(storeDir, params, (InternalAbstractGraphDatabase.Dependencies)new GraphDatabaseDependencies(null, null, Arrays.asList(GraphDatabaseSettings.class, ClusterSettings.class, HaSettings.class), kernelExtensions, cacheProviders, txInterceptorProviders));
    }

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> params, InternalAbstractGraphDatabase.Dependencies dependencies) {
        super(storeDir, params, dependencies);
        this.run();
    }

    protected void create() {
        this.life.add((Object)new BranchedDataMigrator(this.storeDir));
        this.masterDelegateInvocationHandler = new DelegateInvocationHandler<Master>(Master.class);
        Master master = (Master)Proxy.newProxyInstance(Master.class.getClassLoader(), new Class[]{Master.class}, this.masterDelegateInvocationHandler);
        super.create();
        this.kernelEventHandlers.registerKernelEventHandler((KernelEventHandler)new HaKernelPanicHandler(this.xaDataSourceManager, (TxManager)this.txManager, this.availabilityGuard, this.logging, this.masterDelegateInvocationHandler));
        this.updatePuller = new UpdatePuller(this.memberStateMachine, (HaXaDataSourceManager)this.xaDataSourceManager, master, this.requestContextFactory, this.txManager, this.availabilityGuard, this.lastUpdateTime, this.config, this.jobScheduler, this.msgLog);
        this.life.add((Object)this.updatePuller);
        this.stateSwitchTimeoutMillis = (Long)this.config.get(HaSettings.state_switch_timeout);
        this.life.add((Object)this.paxosLife);
        this.life.add((Object)new DatabaseAvailability((TransactionManager)this.txManager, this.availabilityGuard));
        this.life.add((Object)new StartupWaiter());
        this.diagnosticsManager.appendProvider((DiagnosticsProvider)new HighAvailabilityDiagnostics(this.memberStateMachine, this.clusterClient));
    }

    protected UpgradeConfiguration createUpgradeConfiguration() {
        return new HAUpgradeConfiguration();
    }

    protected void createDatabaseAvailability() {
    }

    protected Function<NeoStore, Function<List<LogEntry>, List<LogEntry>>> createTranslationFactory() {
        return new Function<NeoStore, Function<List<LogEntry>, List<LogEntry>>>(){

            public Function<List<LogEntry>, List<LogEntry>> apply(NeoStore neoStore) {
                return new DenseNodeTransactionTranslator(neoStore);
            }
        };
    }

    public void start() {
        this.life.start();
    }

    public void stop() {
        this.life.stop();
    }

    protected org.neo4j.graphdb.Transaction beginTx(ForceMode forceMode) {
        if (!this.availabilityGuard.isAvailable(this.stateSwitchTimeoutMillis)) {
            throw new TransactionFailureException("Timeout waiting for database to allow new transactions. " + this.availabilityGuard.describeWhoIsBlocking());
        }
        return super.beginTx(forceMode);
    }

    public IndexManager index() {
        if (!this.availabilityGuard.isAvailable(this.stateSwitchTimeoutMillis)) {
            throw new TransactionFailureException("Timeout waiting for database to allow new transactions. " + this.availabilityGuard.describeWhoIsBlocking());
        }
        return super.index();
    }

    protected Logging createLogging() {
        Logging loggingService = (Logging)this.life.add((Object)LogbackWeakDependency.tryLoadLogbackService((Config)this.config, (Function)LogbackWeakDependency.NEW_LOGGER_CONTEXT, (Function)LogbackWeakDependency.DEFAULT_TO_CLASSIC));
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new NettyLoggerFactory(loggingService));
        return loggingService;
    }

    protected TransactionStateFactory createTransactionStateFactory() {
        return new TransactionStateFactory(this.logging){

            public TransactionState create(Transaction tx) {
                return new WritableTransactionState(this.newLockClient(), this.nodeManager, DelegateInvocationHandler.snapshot(this.txHook), DelegateInvocationHandler.snapshot(this.txIdGenerator));
            }

            private Locks.Client newLockClient() {
                try {
                    return this.locks.newClient();
                }
                catch (TransactionFailureException e) {
                    return new NoOpClient();
                }
            }
        };
    }

    protected XaDataSourceManager createXaDataSourceManager() {
        HaXaDataSourceManager toReturn = new HaXaDataSourceManager(this.logging.getMessagesLog(HaXaDataSourceManager.class));
        this.requestContextFactory = new RequestContextFactory(((InstanceId)this.config.get(ClusterSettings.server_id)).toIntegerIndex(), toReturn, this.dependencyResolver);
        return toReturn;
    }

    protected RemoteTxHook createTxHook() {
        DelegateInvocationHandler<ClusterMemberEvents> clusterEventsDelegateInvocationHandler = new DelegateInvocationHandler<ClusterMemberEvents>(ClusterMemberEvents.class);
        DelegateInvocationHandler<HighAvailabilityMemberContext> memberContextDelegateInvocationHandler = new DelegateInvocationHandler<HighAvailabilityMemberContext>(HighAvailabilityMemberContext.class);
        DelegateInvocationHandler<ClusterMemberAvailability> clusterMemberAvailabilityDelegateInvocationHandler = new DelegateInvocationHandler<ClusterMemberAvailability>(ClusterMemberAvailability.class);
        this.clusterEvents = (ClusterMemberEvents)Proxy.newProxyInstance(ClusterMemberEvents.class.getClassLoader(), new Class[]{ClusterMemberEvents.class, Lifecycle.class}, clusterEventsDelegateInvocationHandler);
        HighAvailabilityMemberContext memberContext = (HighAvailabilityMemberContext)Proxy.newProxyInstance(HighAvailabilityMemberContext.class.getClassLoader(), new Class[]{HighAvailabilityMemberContext.class}, memberContextDelegateInvocationHandler);
        this.clusterMemberAvailability = (ClusterMemberAvailability)Proxy.newProxyInstance(ClusterMemberAvailability.class.getClassLoader(), new Class[]{ClusterMemberAvailability.class}, clusterMemberAvailabilityDelegateInvocationHandler);
        Object electionCredentialsProvider = (Boolean)this.config.get(HaSettings.slave_only) != false ? new NotElectableElectionCredentialsProvider() : new DefaultElectionCredentialsProvider((InstanceId)this.config.get(ClusterSettings.server_id), new OnDiskLastTxIdGetter(new File(this.getStoreDir())), new HighAvailabilityMemberInfoProvider(){

            @Override
            public HighAvailabilityMemberState getHighAvailabilityMemberState() {
                return HighlyAvailableGraphDatabase.this.memberStateMachine.getCurrentState();
            }
        });
        ObjectStreamFactory objectStreamFactory = new ObjectStreamFactory();
        this.clusterClient = new ClusterClient(this.monitors, ClusterClient.adapt((Config)this.config), this.logging, (ElectionCredentialsProvider)electionCredentialsProvider, (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory);
        PaxosClusterMemberEvents localClusterEvents = new PaxosClusterMemberEvents((Snapshot)this.clusterClient, (Cluster)this.clusterClient, (Heartbeat)this.clusterClient, (AtomicBroadcast)this.clusterClient, this.logging, (Predicate)new Predicate<PaxosClusterMemberEvents.ClusterMembersSnapshot>(){

            public boolean accept(PaxosClusterMemberEvents.ClusterMembersSnapshot item) {
                for (MemberIsAvailable member : item.getCurrentAvailableMembers()) {
                    if (!member.getRoleUri().getScheme().equals("ha") || !HighAvailabilityModeSwitcher.getServerId(member.getRoleUri()).equals(HighlyAvailableGraphDatabase.this.config.get(ClusterSettings.server_id))) continue;
                    HighlyAvailableGraphDatabase.this.msgLog.error(String.format("Instance %s has the same serverId as ours (%d) - will not join this cluster", member.getRoleUri(), ((InstanceId)HighlyAvailableGraphDatabase.this.config.get(ClusterSettings.server_id)).toIntegerIndex()));
                    return true;
                }
                return true;
            }
        }, (Function2)new HANewSnapshotFunction(), (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory);
        this.clusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){
            boolean hasRequestedElection = true;

            public void enteredCluster(ClusterConfiguration clusterConfiguration) {
                HighlyAvailableGraphDatabase.this.clusterClient.performRoleElections();
            }

            public void elected(String role, InstanceId instanceId, URI electedMember) {
                if (this.hasRequestedElection && role.equals("coordinator")) {
                    HighlyAvailableGraphDatabase.this.clusterClient.removeClusterListener((ClusterListener)this);
                }
            }
        });
        SimpleHighAvailabilityMemberContext localMemberContext = new SimpleHighAvailabilityMemberContext(this.clusterClient.getServerId(), (Boolean)this.config.get(HaSettings.slave_only));
        PaxosClusterMemberAvailability localClusterMemberAvailability = new PaxosClusterMemberAvailability(this.clusterClient.getServerId(), (BindingNotifier)this.clusterClient, (AtomicBroadcast)this.clusterClient, this.logging, (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory);
        memberContextDelegateInvocationHandler.setDelegate(localMemberContext);
        clusterEventsDelegateInvocationHandler.setDelegate((ClusterMemberEvents)localClusterEvents);
        clusterMemberAvailabilityDelegateInvocationHandler.setDelegate((ClusterMemberAvailability)localClusterMemberAvailability);
        this.members = new ClusterMembers((Cluster)this.clusterClient, (Heartbeat)this.clusterClient, this.clusterEvents, (InstanceId)this.config.get(ClusterSettings.server_id));
        this.memberStateMachine = new HighAvailabilityMemberStateMachine(memberContext, this.availabilityGuard, this.members, this.clusterEvents, (Election)this.clusterClient, this.logging.getMessagesLog(HighAvailabilityMemberStateMachine.class));
        HighAvailabilityConsoleLogger highAvailabilityConsoleLogger = new HighAvailabilityConsoleLogger(this.logging.getConsoleLog(HighAvailabilityConsoleLogger.class), (InstanceId)this.config.get(ClusterSettings.server_id));
        this.availabilityGuard.addListener((AvailabilityGuard.AvailabilityListener)highAvailabilityConsoleLogger);
        this.clusterEvents.addClusterMemberListener((ClusterMemberListener)highAvailabilityConsoleLogger);
        this.clusterClient.addClusterListener((ClusterListener)highAvailabilityConsoleLogger);
        this.paxosLife.add((Object)this.clusterClient);
        this.paxosLife.add((Object)this.memberStateMachine);
        this.paxosLife.add((Object)this.clusterEvents);
        this.paxosLife.add((Object)localClusterMemberAvailability);
        DelegateInvocationHandler<RemoteTxHook> txHookDelegate = new DelegateInvocationHandler<RemoteTxHook>(RemoteTxHook.class);
        RemoteTxHook txHook = (RemoteTxHook)Proxy.newProxyInstance(RemoteTxHook.class.getClassLoader(), new Class[]{RemoteTxHook.class}, txHookDelegate);
        new TxHookModeSwitcher(this.memberStateMachine, txHookDelegate, this.masterDelegateInvocationHandler, new TxHookModeSwitcher.RequestContextFactoryResolver(){

            @Override
            public RequestContextFactory get() {
                return HighlyAvailableGraphDatabase.this.requestContextFactory;
            }
        }, this.logging.getMessagesLog(TxHookModeSwitcher.class), this.dependencyResolver);
        return txHook;
    }

    public void assertSchemaWritesAllowed() throws InvalidTransactionTypeKernelException {
        if (!this.isMaster()) {
            throw new InvalidTransactionTypeKernelException("Modifying the database schema can only be done on the master server, this server is a slave. Please issue schema modification commands directly to the master.");
        }
    }

    protected TxIdGenerator createTxIdGenerator() {
        DelegateInvocationHandler<TxIdGenerator> txIdGeneratorDelegate = new DelegateInvocationHandler<TxIdGenerator>(TxIdGenerator.class);
        TxIdGenerator txIdGenerator = (TxIdGenerator)Proxy.newProxyInstance(TxIdGenerator.class.getClassLoader(), new Class[]{TxIdGenerator.class}, txIdGeneratorDelegate);
        this.slaves = (Slaves)this.life.add((Object)new HighAvailabilitySlaves(this.members, (Cluster)this.clusterClient, new DefaultSlaveFactory(this.xaDataSourceManager, this.logging, this.monitors, ((Long)this.config.get(HaSettings.com_chunk_size)).intValue())));
        new TxIdGeneratorModeSwitcher(this.memberStateMachine, txIdGeneratorDelegate, (HaXaDataSourceManager)this.xaDataSourceManager, this.masterDelegateInvocationHandler, this.requestContextFactory, this.msgLog, this.config, this.slaves, this.txManager, this.jobScheduler);
        return txIdGenerator;
    }

    protected IdGeneratorFactory createIdGeneratorFactory() {
        this.idGeneratorFactory = new HaIdGeneratorFactory(this.masterDelegateInvocationHandler, this.logging, this.requestContextFactory);
        InvalidEpochExceptionHandler invalidEpochHandler = new InvalidEpochExceptionHandler(){

            @Override
            public void handle() {
                HighlyAvailableGraphDatabase.this.highAvailabilityModeSwitcher.forceElections();
            }
        };
        MasterClientResolver masterClientResolver = new MasterClientResolver(this.logging, invalidEpochHandler, ((Long)this.config.get(HaSettings.read_timeout)).intValue(), ((Long)this.config.get(HaSettings.lock_read_timeout)).intValue(), (Integer)this.config.get(HaSettings.max_concurrent_channels_per_slave), ((Long)this.config.get(HaSettings.com_chunk_size)).intValue());
        SwitchToSlave switchToSlave = new SwitchToSlave(this.logging.getConsoleLog(HighAvailabilityModeSwitcher.class), this.config, this.getDependencyResolver(), (HaIdGeneratorFactory)this.idGeneratorFactory, this.logging, this.masterDelegateInvocationHandler, this.clusterMemberAvailability, this.requestContextFactory, this.updateableSchemaState, masterClientResolver, this.monitors, this.kernelExtensions.listFactories());
        SwitchToMaster switchToMaster = new SwitchToMaster(this.logging, this.msgLog, (GraphDatabaseAPI)this, (HaIdGeneratorFactory)this.idGeneratorFactory, this.config, this.getDependencyResolver(), this.masterDelegateInvocationHandler, this.clusterMemberAvailability, this.monitors);
        this.highAvailabilityModeSwitcher = new HighAvailabilityModeSwitcher(switchToSlave, switchToMaster, (Election)this.clusterClient, this.clusterMemberAvailability, this.getDependencyResolver(), this.logging);
        this.clusterClient.addBindingListener((BindingListener)this.highAvailabilityModeSwitcher);
        this.memberStateMachine.addHighAvailabilityMemberListener(this.highAvailabilityModeSwitcher);
        this.paxosLife.add((Object)this.highAvailabilityModeSwitcher);
        ((HaIdGeneratorFactory)this.idGeneratorFactory).switchToMaster();
        return this.idGeneratorFactory;
    }

    protected Locks createLockManager() {
        DelegateInvocationHandler<Locks> lockManagerDelegate = new DelegateInvocationHandler<Locks>(Locks.class);
        Locks lockManager = (Locks)Proxy.newProxyInstance(Locks.class.getClassLoader(), new Class[]{Locks.class}, lockManagerDelegate);
        new LockManagerModeSwitcher(this.memberStateMachine, lockManagerDelegate, (HaXaDataSourceManager)this.xaDataSourceManager, this.masterDelegateInvocationHandler, this.requestContextFactory, this.txManager, this.txHook, this.availabilityGuard, this.config, new Factory<Locks>(){

            public Locks newInstance() {
                return HighlyAvailableGraphDatabase.super.createLockManager();
            }
        });
        return lockManager;
    }

    protected TokenCreator createRelationshipTypeCreator() {
        DelegateInvocationHandler<TokenCreator> relationshipTypeCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator relationshipTypeCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, relationshipTypeCreatorDelegate);
        new RelationshipTypeCreatorModeSwitcher(this.memberStateMachine, relationshipTypeCreatorDelegate, (HaXaDataSourceManager)this.xaDataSourceManager, this.masterDelegateInvocationHandler, this.requestContextFactory, this.logging);
        return relationshipTypeCreator;
    }

    protected TokenCreator createPropertyKeyCreator() {
        DelegateInvocationHandler<TokenCreator> propertyKeyCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator propertyTokenCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, propertyKeyCreatorDelegate);
        new PropertyKeyCreatorModeSwitcher(this.memberStateMachine, propertyKeyCreatorDelegate, (HaXaDataSourceManager)this.xaDataSourceManager, this.masterDelegateInvocationHandler, this.requestContextFactory, this.logging);
        return propertyTokenCreator;
    }

    protected TokenCreator createLabelIdCreator() {
        DelegateInvocationHandler<TokenCreator> labelIdCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator labelIdCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, labelIdCreatorDelegate);
        new LabelTokenCreatorModeSwitcher(this.memberStateMachine, labelIdCreatorDelegate, (HaXaDataSourceManager)this.xaDataSourceManager, this.masterDelegateInvocationHandler, this.requestContextFactory, this.logging);
        return labelIdCreator;
    }

    protected Caches createCaches() {
        return new HaCaches(this.logging.getMessagesLog(Caches.class), this.monitors);
    }

    protected KernelData createKernelData() {
        this.lastUpdateTime = new LastUpdateTime();
        return new HighlyAvailableKernelData(this, this.members, new ClusterDatabaseInfoProvider(this.members, new OnDiskLastTxIdGetter(new File(this.getStoreDir())), this.lastUpdateTime));
    }

    protected Factory<byte[]> createXidGlobalIdFactory() {
        final int serverId = ((InstanceId)this.config.get(ClusterSettings.server_id)).toIntegerIndex();
        return new Factory<byte[]>(){

            public byte[] newInstance() {
                return XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)serverId);
            }
        };
    }

    protected void registerRecovery() {
        this.memberStateMachine.addHighAvailabilityMemberListener(new HighAvailabilityMemberListener(){

            @Override
            public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
            }

            @Override
            public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.TO_MASTER) && event.getNewState().equals((Object)HighAvailabilityMemberState.MASTER)) {
                    this.doAfterRecoveryAndStartup(true);
                }
            }

            @Override
            public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.TO_SLAVE) && event.getNewState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.doAfterRecoveryAndStartup(false);
                }
            }

            @Override
            public void instanceStops(HighAvailabilityMemberChangeEvent event) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doAfterRecoveryAndStartup(boolean isMaster) {
                try {
                    XaDataSourceManager xaDataSourceManager = HighlyAvailableGraphDatabase.this.xaDataSourceManager;
                    synchronized (xaDataSourceManager) {
                        HighlyAvailableGraphDatabase.this.doAfterRecoveryAndStartup(isMaster);
                    }
                }
                catch (Throwable throwable) {
                    HighlyAvailableGraphDatabase.this.msgLog.error("Post recovery error", throwable);
                    try {
                        HighlyAvailableGraphDatabase.this.memberStateMachine.stop();
                    }
                    catch (Throwable throwable1) {
                        HighlyAvailableGraphDatabase.this.msgLog.warn("Could not stop", throwable1);
                    }
                    try {
                        HighlyAvailableGraphDatabase.this.memberStateMachine.start();
                    }
                    catch (Throwable throwable1) {
                        HighlyAvailableGraphDatabase.this.msgLog.warn("Could not start", throwable1);
                    }
                }
            }
        });
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.storeDir + "]";
    }

    public String getInstanceState() {
        return this.memberStateMachine.getCurrentState().name();
    }

    public String role() {
        return this.members.getSelf().getHARole();
    }

    public boolean isMaster() {
        return this.memberStateMachine.getCurrentState() == HighAvailabilityMemberState.MASTER;
    }

    public DependencyResolver getDependencyResolver() {
        return new DependencyResolver.Adapter(){

            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
                Object result;
                try {
                    result = HighlyAvailableGraphDatabase.this.dependencyResolver.resolveDependency(type, selector);
                }
                catch (IllegalArgumentException e) {
                    if (ClusterMemberEvents.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.clusterEvents);
                    }
                    if (ClusterMemberAvailability.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.clusterMemberAvailability);
                    }
                    if (UpdatePuller.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.updatePuller);
                    }
                    if (Slaves.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.slaves);
                    }
                    if (ClusterClient.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.clusterClient);
                    }
                    if (BindingNotifier.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.clusterClient);
                    }
                    if (ClusterMembers.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.members);
                    }
                    if (RequestContextFactory.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.requestContextFactory);
                    }
                    throw e;
                }
                return (T)selector.select(type, Iterables.option((Object)result));
            }
        };
    }

    private static final class HAUpgradeConfiguration
    implements UpgradeConfiguration {
        private HAUpgradeConfiguration() {
        }

        public void checkConfigurationAllowsAutomaticUpgrade() {
            throw new UpgradeNotAllowedByDatabaseModeException();
        }
    }

    private class StartupWaiter
    extends LifecycleAdapter {
        private StartupWaiter() {
        }

        public void start() throws Throwable {
            HighlyAvailableGraphDatabase.this.availabilityGuard.isAvailable(HighlyAvailableGraphDatabase.this.stateSwitchTimeoutMillis);
        }
    }
}

