/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.HPCMemoryConfig;
import org.neo4j.kernel.impl.cache.HighPerformanceCache;
import org.neo4j.kernel.impl.cache.HighPerformanceCacheSettings;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;

public class HighPerformanceCacheProvider
extends CacheProvider {
    public static final String NAME = "hpc";

    public HighPerformanceCacheProvider() {
        super(NAME, "High-Performance Cache");
    }

    public Cache<NodeImpl> newNodeCache(StringLogger logger, Config config, Monitors monitors) {
        HPCMemoryConfig mem = (HPCMemoryConfig)config.get(HighPerformanceCacheSettings.cache_memory);
        if (mem.source() == HPCMemoryConfig.Source.SPECIFIC_OVERRIDING_RATIO) {
            logger.warn("Explicit cache memory ratio configuration is ignored, because advanced cache memory configuration has been specified. Please specify either only the ratio configuration, or only the advanced configuration.");
        }
        return new HighPerformanceCache<NodeImpl>(mem.nodeCacheSize(), mem.nodeLookupTableFraction(), (Long)config.get(HighPerformanceCacheSettings.log_interval), "NodeCache", logger, (HighPerformanceCache.Monitor)monitors.newMonitor(HighPerformanceCache.Monitor.class, new String[0]));
    }

    public Cache<RelationshipImpl> newRelationshipCache(StringLogger logger, Config config, Monitors monitors) {
        HPCMemoryConfig mem = (HPCMemoryConfig)config.get(HighPerformanceCacheSettings.cache_memory);
        return new HighPerformanceCache<RelationshipImpl>(mem.relCacheSize(), mem.relLookupTableFraction(), (Long)config.get(HighPerformanceCacheSettings.log_interval), "RelationshipCache", logger, (HighPerformanceCache.Monitor)monitors.newMonitor(HighPerformanceCache.Monitor.class, new String[0]));
    }

    public Class getSettingsClass() {
        return HighPerformanceCacheSettings.class;
    }
}

