/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.SillyUtils;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class TestBranchedData {
    private final File dir = TargetDirectory.forTest(this.getClass()).makeGraphDbDir();
    private final LifeSupport life = new LifeSupport();

    @Test
    public void migrationOfBranchedDataDirectories() throws Exception {
        long[] timestamps = new long[3];
        for (int i = 0; i < timestamps.length; ++i) {
            this.startDbAndCreateNode();
            timestamps[i] = this.moveAwayToLookLikeOldBranchedDirectory();
            Thread.sleep(1L);
        }
        new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.dir.getAbsolutePath()).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.initial_hosts, ":5001").newGraphDatabase().shutdown();
        for (long timestamp : timestamps) {
            Assert.assertFalse((String)("directory branched-" + timestamp + " still exists."), (boolean)new File(this.dir, "branched-" + timestamp).exists());
            Assert.assertTrue((String)("directory " + timestamp + " is not there"), (boolean)BranchedDataPolicy.getBranchedDataDirectory((File)this.dir, (long)timestamp).exists());
        }
    }

    @Test
    public void shouldCopyStoreFromMasterIfBranched() throws Throwable {
        ClusterManager clusterManager = (ClusterManager)((Object)this.life.add((Object)new ClusterManager(ClusterManager.clusterOfSize(2), this.dir, MapUtil.stringMap((String[])new String[0]))));
        this.life.start();
        ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        this.createNode((GraphDatabaseService)cluster.getMaster(), "A");
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        String storeDir = slave.getStoreDir();
        ClusterManager.RepairKit starter = cluster.shutdown(slave);
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        this.createNode((GraphDatabaseService)master, "B1");
        this.createNode((GraphDatabaseService)master, "C");
        this.createTransaction(storeDir, "B2");
        slave = starter.repair();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        slave.beginTx().finish();
    }

    @After
    public void after() {
        this.life.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTransaction(String storeDir, String name) {
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        try {
            this.createNode(db, name);
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNode(GraphDatabaseService db, String name) {
        Transaction tx = db.beginTx();
        try {
            db.createNode();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private long moveAwayToLookLikeOldBranchedDirectory() throws IOException {
        long timestamp = System.currentTimeMillis();
        File branchDir = new File(this.dir, "branched-" + timestamp);
        Assert.assertTrue((String)("create directory: " + branchDir), (boolean)branchDir.mkdirs());
        for (File file : (File[])SillyUtils.nonNull((Object)this.dir.listFiles())) {
            String fileName = file.getName();
            if (fileName.equals("messages.log") || file.getName().startsWith("branched-")) continue;
            Assert.assertTrue((boolean)FileUtils.renameFile((File)file, (File)new File(branchDir, file.getName())));
        }
        return timestamp;
    }

    private void startDbAndCreateNode() {
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(this.dir.getAbsolutePath());
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        tx.finish();
        db.shutdown();
    }
}

