/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.com.NetworkReceiver;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.AbstractClusterTest;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.ReflectionUtil;
import org.neo4j.test.ha.ClusterManager;
import org.neo4j.tooling.GlobalGraphOperations;

public class ClusterTopologyChangesIT
extends AbstractClusterTest {
    private static final int TEST_NODE_COUNT = 100;
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Before
    public void setUp() {
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
    }

    @Test
    public void masterRejoinsAfterFailureAndReelection() throws Throwable {
        HighlyAvailableGraphDatabase initialMaster = this.cluster.getMaster();
        ClusterManager.RepairKit kit = this.cluster.fail(initialMaster);
        this.cluster.await(ClusterManager.masterAvailable(initialMaster));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        ClusterTopologyChangesIT.repairUsing(kit);
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        Assert.assertEquals((long)3L, (long)this.cluster.size());
    }

    @Test
    public void slaveShouldCatchUpTransactionLogsOnFirstLockRequestAfterFailure() throws Throwable {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        Node theNode = ClusterTopologyChangesIT.createNodeOn(master);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        ClusterManager.RepairKit repairKit = this.cluster.fail(slave);
        try (Transaction tx = master.beginTx();){
            for (int i = 0; i < 100; ++i) {
                master.createNode(new Label[]{DynamicLabel.label((String)("Node" + i))});
            }
            tx.success();
        }
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        repairKit.repair();
        tx = slave.beginTx();
        var6_6 = null;
        try {
            slave.getNodeById(theNode.getId()).addLabel(DynamicLabel.label((String)"42"));
            tx.success();
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var6_6.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertEquals((long)101L, (long)ClusterTopologyChangesIT.nodeCountOn(slave));
    }

    @Test
    public void slaveShouldServeTxsAfterMasterLostQuorumWentToPendingAndThenQuorumWasRestored() throws Throwable {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        final HighlyAvailableGraphDatabase slave1 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        final HighlyAvailableGraphDatabase slave2 = this.cluster.getAnySlave(slave1);
        final CountDownLatch slave1Left = new CountDownLatch(1);
        final CountDownLatch slave2Left = new CountDownLatch(1);
        ClusterTopologyChangesIT.clusterClientOf(master).addHeartbeatListener((HeartbeatListener)new HeartbeatListener.Adapter(){

            public void failed(InstanceId server) {
                if (ClusterTopologyChangesIT.instanceIdOf(slave1).equals((Object)server)) {
                    slave1Left.countDown();
                } else if (ClusterTopologyChangesIT.instanceIdOf(slave2).equals((Object)server)) {
                    slave2Left.countDown();
                }
            }
        });
        ClusterManager.RepairKit slave1RepairKit = this.cluster.fail(slave1);
        slave1Left.await();
        ClusterManager.RepairKit slave2RepairKit = this.cluster.fail(slave2);
        slave2Left.await();
        this.cluster.await((Predicate<ClusterManager.ManagedCluster>)Predicates.not(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0])));
        Assert.assertEquals((Object)HighAvailabilityMemberState.PENDING.toString(), (Object)master.getInstanceState());
        slave1RepairKit.repair();
        slave2RepairKit.repair();
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        Assert.assertNotNull((Object)ClusterTopologyChangesIT.createNodeOn(master));
        Assert.assertNotNull((Object)ClusterTopologyChangesIT.createNodeOn(slave1));
        Assert.assertNotNull((Object)ClusterTopologyChangesIT.createNodeOn(slave2));
    }

    @Test
    public void failedInstanceShouldReceiveCorrectCoordinatorIdUponRejoiningCluster() throws Throwable {
        HighlyAvailableGraphDatabase initialMaster = this.cluster.getMaster();
        this.cluster.shutdown(initialMaster);
        this.cluster.await(ClusterManager.masterAvailable(initialMaster));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        ClusterTopologyChangesIT.createNodeOn(this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        ClusterClient clusterClient = (ClusterClient)this.cleanup.add((Object)this.newClusterClient(new InstanceId(1)));
        final AtomicReference coordinatorIdWhenReJoined = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        clusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){

            public void enteredCluster(ClusterConfiguration clusterConfiguration) {
                coordinatorIdWhenReJoined.set(clusterConfiguration.getElected("coordinator"));
                latch.countDown();
            }
        });
        clusterClient.init();
        clusterClient.start();
        latch.await(2L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)new InstanceId(2), coordinatorIdWhenReJoined.get());
    }

    @Override
    protected void configureClusterMember(GraphDatabaseBuilder builder, String clusterName, InstanceId serverId) {
        super.configureClusterMember(builder, clusterName, serverId);
        builder.setConfig(HaSettings.read_timeout, "1s");
        builder.setConfig(HaSettings.state_switch_timeout, "2s");
        builder.setConfig(HaSettings.com_chunk_size, "1024");
    }

    private static void repairUsing(ClusterManager.RepairKit kit) throws Throwable {
        Iterable stoppedServices = (Iterable)ReflectionUtil.getPrivateField((Object)kit, (String)"stoppedServices", Iterable.class);
        for (Lifecycle service : stoppedServices) {
            if (service instanceof NetworkReceiver) continue;
            service.start();
        }
        Thread.sleep(2000L);
        for (Lifecycle service : stoppedServices) {
            if (!(service instanceof NetworkReceiver)) continue;
            service.start();
        }
    }

    private static long nodeCountOn(HighlyAvailableGraphDatabase db) {
        try (Transaction ignored = db.beginTx();){
            long l = Iterables.count((Iterable)GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes());
            return l;
        }
    }

    private static ClusterClient clusterClientOf(HighlyAvailableGraphDatabase db) {
        return (ClusterClient)db.getDependencyResolver().resolveDependency(ClusterClient.class);
    }

    private static InstanceId instanceIdOf(HighlyAvailableGraphDatabase db) {
        return ClusterTopologyChangesIT.clusterClientOf(db).getServerId();
    }

    private static Node createNodeOn(HighlyAvailableGraphDatabase db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty("key", (Object)String.valueOf(System.currentTimeMillis()));
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private ClusterClient newClusterClient(InstanceId id) {
        Map configMap = MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), this.cluster.getInitialHostsConfigString(), ClusterSettings.server_id.name(), String.valueOf(id.toIntegerIndex()), ClusterSettings.cluster_server.name(), "0.0.0.0:8888"});
        Config config = new Config(configMap, new Class[]{InternalAbstractGraphDatabase.Configuration.class, GraphDatabaseSettings.class});
        return new ClusterClient(new Monitors(), ClusterClient.adapt((Config)config), (Logging)new DevNullLoggingService(), (ElectionCredentialsProvider)new NotElectableElectionCredentialsProvider(), (ObjectInputStreamFactory)new ObjectStreamFactory(), (ObjectOutputStreamFactory)new ObjectStreamFactory());
    }
}

