/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.com.ComException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.AbstractClusterTest;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.OtherThreadRule;
import org.neo4j.test.RepeatRule;
import org.neo4j.test.ha.ClusterManager;

public class UniqueConstraintStressIT
extends AbstractClusterTest {
    private final int REPETITIONS = 1;
    @Rule
    public final RepeatRule repeater = new RepeatRule();
    @Rule
    public OtherThreadRule<Object> slaveWork = new OtherThreadRule();
    @Rule
    public OtherThreadRule<Object> masterWork = new OtherThreadRule();
    private static long runtime = Long.getLong("neo4j.UniqueConstraintStressIT.runtime", TimeUnit.SECONDS.toMillis(10L));
    private volatile Label label = DynamicLabel.label((String)"User");
    private volatile String property;
    private final AtomicInteger roundNo = new AtomicInteger(0);

    @Before
    public void setUp() {
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
    }

    @RepeatRule.Repeat(times=1)
    @Test
    public void shouldNotAllowUniquenessViolationsUnderStress_A() throws Exception {
        this.shouldNotAllowUniquenessViolationsUnderStress(new Operation(){

            @Override
            void perform() {
                this.constraintCreation = UniqueConstraintStressIT.this.masterWork.execute(UniqueConstraintStressIT.this.createConstraint(this.master));
                this.constraintViolation = UniqueConstraintStressIT.this.slaveWork.execute(UniqueConstraintStressIT.this.performInsert(this.slave));
            }
        });
    }

    @RepeatRule.Repeat(times=1)
    @Test
    public void shouldNotAllowUniquenessViolationsUnderStress_B() throws Exception {
        this.shouldNotAllowUniquenessViolationsUnderStress(new Operation(){

            @Override
            void perform() {
                this.constraintViolation = UniqueConstraintStressIT.this.slaveWork.execute(UniqueConstraintStressIT.this.performInsert(this.slave));
                this.constraintCreation = UniqueConstraintStressIT.this.masterWork.execute(UniqueConstraintStressIT.this.createConstraint(this.master));
            }
        });
    }

    @RepeatRule.Repeat(times=1)
    @Test
    public void shouldNotAllowUniquenessViolationsUnderStress_C() throws Exception {
        this.shouldNotAllowUniquenessViolationsUnderStress(new Operation(){

            @Override
            void perform() {
                this.constraintCreation = UniqueConstraintStressIT.this.masterWork.execute(UniqueConstraintStressIT.this.createConstraint(this.master));
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.constraintViolation = UniqueConstraintStressIT.this.slaveWork.execute(UniqueConstraintStressIT.this.performInsert(this.slave));
            }
        });
    }

    @RepeatRule.Repeat(times=1)
    @Test
    public void shouldNotAllowUniquenessViolationsUnderStress_D() throws Exception {
        this.shouldNotAllowUniquenessViolationsUnderStress(new Operation(){

            @Override
            void perform() {
                this.constraintViolation = UniqueConstraintStressIT.this.slaveWork.execute(UniqueConstraintStressIT.this.performInsert(this.slave));
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.constraintCreation = UniqueConstraintStressIT.this.masterWork.execute(UniqueConstraintStressIT.this.createConstraint(this.master));
            }
        });
    }

    public void shouldNotAllowUniquenessViolationsUnderStress(Operation ops) throws Exception {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        long end = System.currentTimeMillis() + runtime;
        int successfulAttempts = 0;
        while (end > System.currentTimeMillis()) {
            this.setLabelAndPropertyForNextRound();
            this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
            try {
                this.slaveWork.execute(this.performInsert(slave)).get();
            }
            catch (ExecutionException e) {
                if (Exceptions.contains((Throwable)e, (String)"could not connect", (Class[])new Class[]{ComException.class})) continue;
            }
            ops.perform();
            this.assertConstraintsNotViolated(ops.constraintCreation, ops.constraintViolation, master);
            ++successfulAttempts;
        }
        Assert.assertThat((Object)successfulAttempts, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    private void assertConstraintsNotViolated(Future<Object> constraintCreation, Future<Integer> constraintViolation, HighlyAvailableGraphDatabase master) throws InterruptedException, ExecutionException {
        boolean constraintCreationFailed = false;
        try {
            constraintCreation.get();
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ConstraintViolationException.class));
            constraintCreationFailed = true;
        }
        int txSuccessCount = constraintViolation.get();
        if (constraintCreationFailed) {
            Assert.assertThat((Object)txSuccessCount, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            Assert.assertThat((Object)this.allPropertiesAreUnique(master, this.label, this.property), (Matcher)Matchers.equalTo((Object)false));
        } else {
            Assert.assertThat((Object)txSuccessCount, (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)this.allPropertiesAreUnique(master, this.label, this.property), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    private boolean allPropertiesAreUnique(HighlyAvailableGraphDatabase master, Label label, String property) {
        try (Transaction tx = master.beginTx();){
            HashSet<Object> values = new HashSet<Object>();
            for (Node node : IteratorUtil.loop((Iterator)master.findNodes(label))) {
                Object value = node.getProperty(property);
                if (values.contains(value)) {
                    boolean bl = false;
                    return bl;
                }
                values.add(value);
            }
            tx.success();
        }
        return true;
    }

    private OtherThreadExecutor.WorkerCommand<Object, Object> createConstraint(final HighlyAvailableGraphDatabase master) {
        return new OtherThreadExecutor.WorkerCommand<Object, Object>(){

            public Object doWork(Object state) throws Exception {
                try (Transaction tx = master.beginTx();){
                    master.schema().constraintFor(UniqueConstraintStressIT.this.label).assertPropertyIsUnique(UniqueConstraintStressIT.this.property).create();
                    tx.success();
                }
                return null;
            }
        };
    }

    private OtherThreadExecutor.WorkerCommand<Object, Integer> performInsert(final HighlyAvailableGraphDatabase slave) {
        return new OtherThreadExecutor.WorkerCommand<Object, Integer>(){

            public Integer doWork(Object state) throws Exception {
                int i;
                try {
                    for (i = 0; i < 100; ++i) {
                        try (Transaction tx = slave.beginTx();){
                            slave.createNode(new Label[]{UniqueConstraintStressIT.this.label}).setProperty(UniqueConstraintStressIT.this.property, (Object)("value-" + i));
                            tx.success();
                            continue;
                        }
                    }
                }
                catch (TransactionFailureException e) {
                }
                catch (ComException comException) {
                    // empty catch block
                }
                return i;
            }
        };
    }

    private void setLabelAndPropertyForNextRound() {
        this.property = "Key-" + this.roundNo.incrementAndGet();
        this.label = DynamicLabel.label((String)("Label-" + this.roundNo.get()));
    }

    private abstract class Operation {
        HighlyAvailableGraphDatabase master;
        HighlyAvailableGraphDatabase slave;
        Future<Object> constraintCreation;
        Future<Integer> constraintViolation;

        private Operation() {
            this.master = UniqueConstraintStressIT.this.cluster.getMaster();
            this.slave = UniqueConstraintStressIT.this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            this.constraintCreation = null;
            this.constraintViolation = null;
        }

        abstract void perform();
    }
}

