/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.util.StringLogger;

public class BranchDetectingTxVerifier
implements TxChecksumVerifier {
    private final StringLogger logger;
    private final LogicalTransactionStore txStore;

    public BranchDetectingTxVerifier(StringLogger logger, LogicalTransactionStore logicalTransactionStore) {
        this.logger = logger;
        this.txStore = logicalTransactionStore;
    }

    public void assertMatch(long txId, int masterId, long checksum) {
        boolean match;
        if (txId == 0L) {
            return;
        }
        TransactionMetadataCache.TransactionMetadata metadata = null;
        try {
            metadata = this.txStore.getMetadataFor(txId);
        }
        catch (IOException e) {
            this.logger.logMessage("Couldn't verify checksum for " + this.stringify(txId, masterId, checksum), (Throwable)e);
            throw new BranchedDataException("Unable to perform a mandatory sanity check due to an IO error.", e);
        }
        int readMaster = metadata.getMasterId();
        long readChecksum = metadata.getChecksum();
        boolean bl = match = masterId == readMaster && checksum == readChecksum;
        if (!match) {
            throw new BranchedDataException("The cluster contains two logically different versions of the database. This will be automatically resolved. Details: " + this.stringify(txId, masterId, checksum) + " does not match " + readChecksum);
        }
    }

    private String stringify(long txId, int masterId, long checksum) {
        return "txId:" + txId + ", masterId:" + masterId + ", checksum:" + checksum;
    }
}

