/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com;

import java.io.IOException;
import org.neo4j.com.RequestContext;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class RequestContextFactory
extends LifecycleAdapter {
    private long epoch;
    private final int serverId;
    private final DependencyResolver resolver;
    private LogicalTransactionStore txStore;
    private TransactionIdStore txIdStore;
    public static final int VOID_EVENT_IDENTIFIER = -3;
    public static final int DEFAULT_EVENT_IDENTIFIER = -1;

    public RequestContextFactory(int serverId, DependencyResolver resolver) {
        this.resolver = resolver;
        this.epoch = -1L;
        this.serverId = serverId;
    }

    public void start() throws Throwable {
        this.txStore = (LogicalTransactionStore)((NeoStoreDataSource)this.resolver.resolveDependency(NeoStoreDataSource.class)).getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
        this.txIdStore = (TransactionIdStore)((NeoStoreDataSource)this.resolver.resolveDependency(NeoStoreDataSource.class)).getDependencyResolver().resolveDependency(TransactionIdStore.class);
    }

    public void stop() throws Throwable {
        this.txStore = null;
        this.txIdStore = null;
    }

    public void setEpoch(long epoch) {
        this.epoch = epoch;
    }

    public RequestContext newRequestContext(long epoch, int machineId, int eventIdentifier) {
        long latestTxId = this.txIdStore.getLastCommittedTransactionId();
        if (latestTxId == 0L) {
            return new RequestContext(epoch, machineId, eventIdentifier, 0L, -1, -1L);
        }
        TransactionMetadataCache.TransactionMetadata txMetadata = null;
        try {
            txMetadata = this.txStore.getMetadataFor(latestTxId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (txMetadata != null) {
            return new RequestContext(epoch, machineId, eventIdentifier, latestTxId, txMetadata.getMasterId(), txMetadata.getChecksum());
        }
        return new RequestContext(epoch, machineId, eventIdentifier, latestTxId, -1, -1L);
    }

    public RequestContext newRequestContext(int eventIdentifier) {
        return this.newRequestContext(this.epoch, this.serverId, eventIdentifier);
    }

    public RequestContext newRequestContext() {
        return this.newRequestContext(-1);
    }
}

