/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.io.File;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.InvalidTransactionTypeException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.schema.PropertyUniqueConstraintDefinition;
import org.neo4j.test.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class UniqueConstraintHaIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule(this.getClass());

    @Test
    public void shouldCreateUniqueConstraintOnMaster() throws Exception {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            master.schema().constraintFor(DynamicLabel.label((String)"Label1")).assertPropertyIsUnique("key1").create();
            tx.success();
        }
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        for (HighlyAvailableGraphDatabase clusterMember : cluster.getAllMembers()) {
            Transaction tx = clusterMember.beginTx();
            Throwable throwable = null;
            try {
                ConstraintDefinition constraint = (ConstraintDefinition)Iterables.single((Iterable)clusterMember.schema().getConstraints(DynamicLabel.label((String)"Label1")));
                Assert.assertEquals((Object)"key1", (Object)Iterables.single((Iterable)constraint.getPropertyKeys()));
                tx.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    @Test
    public void shouldNotBePossibleToCreateConstraintsDirectlyOnSlaves() throws Exception {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction ignored = slave.beginTx();){
            slave.schema().constraintFor(DynamicLabel.label((String)"Label1")).assertPropertyIsUnique("key1").create();
            Assert.fail((String)"We expected to not be able to create a constraint on a slave in a cluster.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(InvalidTransactionTypeException.class));
        }
    }

    @Test
    public void shouldRemoveConstraints() throws Exception {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            master.schema().constraintFor(DynamicLabel.label((String)"User")).assertPropertyIsUnique("name").create();
            tx.success();
        }
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.createUser(cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]), "Bob");
        tx = master.beginTx();
        var4_4 = null;
        try {
            ((ConstraintDefinition)Iterables.single((Iterable)master.schema().getConstraints())).drop();
            tx.success();
        }
        catch (Throwable x2) {
            var4_4 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_4.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        for (HighlyAvailableGraphDatabase clusterMember : cluster.getAllMembers()) {
            Transaction tx = clusterMember.beginTx();
            Throwable throwable = null;
            try {
                Assert.assertEquals((long)Iterables.count((Iterable)clusterMember.schema().getConstraints()), (long)0L);
                Assert.assertEquals((long)Iterables.count((Iterable)clusterMember.schema().getIndexes()), (long)0L);
                this.createUser(clusterMember, "Bob");
                tx.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    @Test
    public void shouldNotAllowOldUncommittedTransactionsToResumeAndViolateConstraint() throws Exception {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster(MapUtil.stringMap((String[])new String[]{HaSettings.read_timeout.name(), "4000s"}));
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        ThreadToStatementContextBridge txBridge = (ThreadToStatementContextBridge)slave.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        this.createUser(master, "Bob");
        slave.beginTx();
        slave.createNode(new Label[]{DynamicLabel.label((String)"User")}).setProperty("name", (Object)"Bob");
        TopLevelTransaction slaveTx = txBridge.getTopLevelTransactionBoundToThisThread(true);
        txBridge.unbindTransactionFromCurrentThread();
        try (Transaction tx = master.beginTx();){
            master.schema().constraintFor(DynamicLabel.label((String)"User")).assertPropertyIsUnique("name").create();
            tx.success();
        }
        txBridge.bindTransactionToCurrentThread(slaveTx);
        try {
            slaveTx.success();
            slaveTx.finish();
            Assert.fail((String)"Expected this commit to fail :(");
        }
        catch (org.neo4j.graphdb.TransactionFailureException e) {
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)Matchers.instanceOf(TransactionFailureException.class));
        }
        this.assertOneBob(master);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertOneBob(slave);
        this.createUser(slave, "Steven");
        this.createUser(master, "Caroline");
    }

    @Test
    public void newSlaveJoiningClusterShouldNotAcceptOperationsUntilConstraintIsOnline() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        File slaveStoreDirectory = cluster.getStoreDir(slave);
        ClusterManager.RepairKit shutdownSlave = cluster.shutdown(slave);
        FileUtils.deleteRecursively((File)slaveStoreDirectory);
        try (Transaction tx = master.beginTx();){
            master.schema().constraintFor(DynamicLabel.label((String)"User")).assertPropertyIsUnique("name").create();
            tx.success();
        }
        slave = shutdownSlave.repair();
        var7_7 = null;
        try (Transaction ignored = slave.beginTx();){
            Assert.assertThat((Object)Iterables.single((Iterable)slave.schema().getConstraints()), (Matcher)Matchers.instanceOf(PropertyUniqueConstraintDefinition.class));
            PropertyUniqueConstraintDefinition constraint = (PropertyUniqueConstraintDefinition)Iterables.single((Iterable)slave.schema().getConstraints());
            Assert.assertThat((Object)Iterables.single((Iterable)constraint.getPropertyKeys()), (Matcher)Matchers.equalTo((Object)"name"));
            Assert.assertThat((Object)constraint.getLabel(), (Matcher)Matchers.equalTo((Object)DynamicLabel.label((String)"User")));
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
    }

    private void createUser(HighlyAvailableGraphDatabase db, String name) {
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{DynamicLabel.label((String)"User")}).setProperty("name", (Object)name);
            tx.success();
        }
    }

    private void assertOneBob(HighlyAvailableGraphDatabase db) {
        try (Transaction tx = db.beginTx();){
            Assert.assertThat((Object)Arrays.asList(db.findNodes(DynamicLabel.label((String)"User"), "name", (Object)"Bob")).size(), (Matcher)Matchers.equalTo((Object)1));
            tx.success();
        }
    }
}

