/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock.forseti;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.ha.lock.forseti.ForsetiLockManager;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.community.CommunityLockManger;
import org.neo4j.test.TargetDirectory;

public class ForsetiServiceLoadingTest {
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void shouldUseForsetiAsDefaultLockManager() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabase(this.dir.absolutePath());
        MatcherAssert.assertThat((Object)db.getDependencyResolver().resolveDependency(Locks.class), (Matcher)IsInstanceOf.instanceOf(ForsetiLockManager.class));
        db.shutdown();
    }

    @Test
    public void shouldAllowUsingCommunityLockManager() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.dir.absolutePath()).setConfig(InternalAbstractGraphDatabase.Configuration.lock_manager, "community").newGraphDatabase();
        MatcherAssert.assertThat((Object)db.getDependencyResolver().resolveDependency(Locks.class), (Matcher)IsInstanceOf.instanceOf(CommunityLockManger.class));
        db.shutdown();
    }
}

